/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.ContainmentFilter;
import com.sun.jndi.toolkit.dir.ContextEnumerator;
import com.sun.jndi.toolkit.dir.HierarchicalName;
import com.sun.jndi.toolkit.dir.HierarchicalNameParser;
import com.sun.jndi.toolkit.dir.LazySearchEnumerationImpl;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;

public class HierMemDirCtx
implements DirContext {
    private static final boolean debug = false;
    private static final NameParser defaultParser = new HierarchicalNameParser();
    protected Hashtable<String, Object> myEnv;
    protected Hashtable<Name, Object> bindings;
    protected Attributes attrs;
    protected boolean ignoreCase = false;
    protected NamingException readOnlyEx = null;
    protected NameParser myParser = defaultParser;
    private boolean alwaysUseFactory;

    @Override
    public void close() throws NamingException {
        this.myEnv = null;
        this.bindings = null;
        this.attrs = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Cannot determine full name");
    }

    public HierMemDirCtx() {
        this(null, false, false);
    }

    public HierMemDirCtx(boolean bl) {
        this(null, bl, false);
    }

    public HierMemDirCtx(Hashtable<String, Object> hashtable, boolean bl) {
        this(hashtable, bl, false);
    }

    protected HierMemDirCtx(Hashtable<String, Object> hashtable, boolean bl, boolean bl2) {
        this.myEnv = hashtable;
        this.ignoreCase = bl;
        this.init();
        this.alwaysUseFactory = bl2;
    }

    private void init() {
        this.attrs = new BasicAttributes(this.ignoreCase);
        this.bindings = new Hashtable(11, 0.75f);
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(this.myParser.parse(string));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.doLookup(name, this.alwaysUseFactory);
    }

    public Object doLookup(Name name, boolean bl) throws NamingException {
        Object object = null;
        name = this.canonizeName(name);
        switch (name.size()) {
            case 0: {
                object = this;
                break;
            }
            case 1: {
                object = this.bindings.get(name);
                break;
            }
            default: {
                HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.bindings.get(name.getPrefix(1));
                object = hierMemDirCtx == null ? null : hierMemDirCtx.doLookup(name.getSuffix(1), false);
            }
        }
        if (object == null) {
            throw new NameNotFoundException(name.toString());
        }
        if (bl) {
            try {
                return DirectoryManager.getObjectInstance(object, name, this, this.myEnv, object instanceof HierMemDirCtx ? ((HierMemDirCtx)object).attrs : null);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("Problem calling getObjectInstance");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return object;
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(this.myParser.parse(string), object);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.doBind(name, object, null, this.alwaysUseFactory);
    }

    @Override
    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.bind(this.myParser.parse(string), object, attributes);
    }

    @Override
    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.doBind(name, object, attributes, this.alwaysUseFactory);
    }

    protected void doBind(Name name, Object object, Attributes attributes, boolean bl) throws NamingException {
        Object object2;
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (bl) {
            object2 = DirectoryManager.getStateToBind(object, name, this, this.myEnv, attributes);
            object = ((DirStateFactory.Result)object2).getObject();
            attributes = ((DirStateFactory.Result)object2).getAttributes();
        }
        object2 = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        ((HierMemDirCtx)object2).doBindAux(this.getLeafName(name), object);
        if (attributes != null && attributes.size() > 0) {
            this.modifyAttributes(name, 1, attributes);
        }
    }

    protected void doBindAux(Name name, Object object) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        if (this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException(name.toString());
        }
        if (!(object instanceof HierMemDirCtx)) {
            throw new SchemaViolationException("This context only supports binding objects of it's own kind");
        }
        this.bindings.put(name, object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(this.myParser.parse(string), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.doRebind(name, object, null, this.alwaysUseFactory);
    }

    @Override
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.rebind(this.myParser.parse(string), object, attributes);
    }

    @Override
    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.doRebind(name, object, attributes, this.alwaysUseFactory);
    }

    protected void doRebind(Name name, Object object, Attributes attributes, boolean bl) throws NamingException {
        Object object2;
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot rebind empty name");
        }
        if (bl) {
            object2 = DirectoryManager.getStateToBind(object, name, this, this.myEnv, attributes);
            object = ((DirStateFactory.Result)object2).getObject();
            attributes = ((DirStateFactory.Result)object2).getAttributes();
        }
        object2 = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        ((HierMemDirCtx)object2).doRebindAux(this.getLeafName(name), object);
        if (attributes != null && attributes.size() > 0) {
            this.modifyAttributes(name, 1, attributes);
        }
    }

    protected void doRebindAux(Name name, Object object) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        if (!(object instanceof HierMemDirCtx)) {
            throw new SchemaViolationException("This context only supports binding objects of it's own kind");
        }
        this.bindings.put(name, object);
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(this.myParser.parse(string));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        hierMemDirCtx.doUnbind(this.getLeafName(name));
    }

    protected void doUnbind(Name name) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        this.bindings.remove(name);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(this.myParser.parse(string), this.myParser.parse(string2));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        if (name2.isEmpty() || name.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (!this.getInternalName(name2).equals(this.getInternalName(name))) {
            throw new InvalidNameException("Cannot rename across contexts");
        }
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(this.getInternalName(name2), false);
        hierMemDirCtx.doRename(this.getLeafName(name), this.getLeafName(name2));
    }

    protected void doRename(Name name, Name name2) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        name = this.canonizeName(name);
        if (this.bindings.get(name2 = this.canonizeName(name2)) != null) {
            throw new NameAlreadyBoundException(name2.toString());
        }
        Object object = this.bindings.remove(name);
        if (object == null) {
            throw new NameNotFoundException(name.toString());
        }
        this.bindings.put(name2, object);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list(this.myParser.parse(string));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(name, false);
        return hierMemDirCtx.doList();
    }

    protected NamingEnumeration<NameClassPair> doList() throws NamingException {
        return new FlatNames(this.bindings.keys());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.listBindings(this.myParser.parse(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(name, false);
        return hierMemDirCtx.doListBindings(this.alwaysUseFactory);
    }

    protected NamingEnumeration<Binding> doListBindings(boolean bl) throws NamingException {
        return new FlatBindings(this.bindings, this.myEnv, bl);
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(this.myParser.parse(string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        hierMemDirCtx.doDestroySubcontext(this.getLeafName(name));
    }

    protected void doDestroySubcontext(Name name) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        name = this.canonizeName(name);
        this.bindings.remove(name);
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(this.myParser.parse(string));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    @Override
    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        return this.createSubcontext(this.myParser.parse(string), attributes);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(this.getInternalName(name), false);
        return hierMemDirCtx.doCreateSubcontext(this.getLeafName(name), attributes);
    }

    protected DirContext doCreateSubcontext(Name name, Attributes attributes) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        if (this.bindings.get(name = this.canonizeName(name)) != null) {
            throw new NameAlreadyBoundException(name.toString());
        }
        HierMemDirCtx hierMemDirCtx = this.createNewCtx();
        this.bindings.put(name, hierMemDirCtx);
        if (attributes != null) {
            hierMemDirCtx.modifyAttributes("", 1, attributes);
        }
        return hierMemDirCtx;
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(this.myParser.parse(string));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.myParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.myParser;
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        name = this.canonizeName(name);
        name2 = this.canonizeName(name2);
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.myEnv = this.myEnv == null ? new Hashtable(11, 0.75f) : (Hashtable)this.myEnv.clone();
        return this.myEnv.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        this.myEnv = (Hashtable)this.myEnv.clone();
        return this.myEnv.remove(string);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable<String, Object>(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    @Override
    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes(this.myParser.parse(string));
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(name, false);
        return hierMemDirCtx.doGetAttributes();
    }

    protected Attributes doGetAttributes() throws NamingException {
        return (Attributes)this.attrs.clone();
    }

    @Override
    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        return this.getAttributes(this.myParser.parse(string), stringArray);
    }

    @Override
    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(name, false);
        return hierMemDirCtx.doGetAttributes(stringArray);
    }

    protected Attributes doGetAttributes(String[] stringArray) throws NamingException {
        if (stringArray == null) {
            return this.doGetAttributes();
        }
        BasicAttributes basicAttributes = new BasicAttributes(this.ignoreCase);
        Attribute attribute = null;
        for (int i = 0; i < stringArray.length; ++i) {
            attribute = this.attrs.get(stringArray[i]);
            if (attribute == null) continue;
            basicAttributes.put(attribute);
        }
        return basicAttributes;
    }

    @Override
    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(this.myParser.parse(string), n, attributes);
    }

    @Override
    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            throw new IllegalArgumentException("Cannot modify without an attribute");
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        ModificationItem[] modificationItemArray = new ModificationItem[attributes.size()];
        for (int i = 0; i < modificationItemArray.length && namingEnumeration.hasMoreElements(); ++i) {
            modificationItemArray[i] = new ModificationItem(n, namingEnumeration.next());
        }
        this.modifyAttributes(name, modificationItemArray);
    }

    @Override
    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(this.myParser.parse(string), modificationItemArray);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(name, false);
        hierMemDirCtx.doModifyAttributes(modificationItemArray);
    }

    protected void doModifyAttributes(ModificationItem[] modificationItemArray) throws NamingException {
        if (this.readOnlyEx != null) {
            throw (NamingException)this.readOnlyEx.fillInStackTrace();
        }
        HierMemDirCtx.applyMods(modificationItemArray, this.attrs);
    }

    protected static Attributes applyMods(ModificationItem[] modificationItemArray, Attributes attributes) throws NamingException {
        block5: for (int i = 0; i < modificationItemArray.length; ++i) {
            ModificationItem modificationItem = modificationItemArray[i];
            Attribute attribute = modificationItem.getAttribute();
            switch (modificationItem.getModificationOp()) {
                case 1: {
                    Attribute attribute2 = attributes.get(attribute.getID());
                    if (attribute2 == null) {
                        attributes.put((Attribute)attribute.clone());
                        continue block5;
                    }
                    NamingEnumeration<?> namingEnumeration = attribute.getAll();
                    while (namingEnumeration.hasMore()) {
                        attribute2.add(namingEnumeration.next());
                    }
                    continue block5;
                }
                case 2: {
                    if (attribute.size() == 0) {
                        attributes.remove(attribute.getID());
                        continue block5;
                    }
                    attributes.put((Attribute)attribute.clone());
                    continue block5;
                }
                case 3: {
                    Attribute attribute2 = attributes.get(attribute.getID());
                    if (attribute2 == null) continue block5;
                    if (attribute.size() == 0) {
                        attributes.remove(attribute.getID());
                        continue block5;
                    }
                    NamingEnumeration<?> namingEnumeration = attribute.getAll();
                    while (namingEnumeration.hasMore()) {
                        attribute2.remove(namingEnumeration.next());
                    }
                    if (attribute2.size() != 0) continue block5;
                    attributes.remove(attribute.getID());
                    continue block5;
                }
                default: {
                    throw new AttributeModificationException("Unknown mod_op");
                }
            }
        }
        return attributes;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes) throws NamingException {
        return this.search(string, attributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
        return this.search(name, attributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return this.search(this.myParser.parse(string), attributes, stringArray);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.doLookup(name, false);
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        return new LazySearchEnumerationImpl(hierMemDirCtx.doListBindings(false), new ContainmentFilter(attributes), searchControls, this, this.myEnv, false);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, SearchControls searchControls) throws NamingException {
        DirContext dirContext = (DirContext)this.doLookup(name, false);
        SearchFilter searchFilter = new SearchFilter(string);
        return new LazySearchEnumerationImpl(new HierContextEnumerator(dirContext, searchControls != null ? searchControls.getSearchScope() : 1), searchFilter, searchControls, this, this.myEnv, this.alwaysUseFactory);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        String string2 = SearchFilter.format(string, objectArray);
        return this.search(name, string2, searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, SearchControls searchControls) throws NamingException {
        return this.search(this.myParser.parse(string), string2, searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search(this.myParser.parse(string), string2, objectArray, searchControls);
    }

    protected HierMemDirCtx createNewCtx() throws NamingException {
        return new HierMemDirCtx(this.myEnv, this.ignoreCase);
    }

    protected Name canonizeName(Name name) throws NamingException {
        Name name2 = name;
        if (!(name instanceof HierarchicalName)) {
            name2 = new HierarchicalName();
            int n = name.size();
            for (int i = 0; i < n; ++i) {
                name2.add(i, name.get(i));
            }
        }
        return name2;
    }

    protected Name getInternalName(Name name) throws NamingException {
        return name.getPrefix(name.size() - 1);
    }

    protected Name getLeafName(Name name) throws NamingException {
        return name.getSuffix(name.size() - 1);
    }

    @Override
    public DirContext getSchema(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void setReadOnly(NamingException namingException) {
        this.readOnlyEx = namingException;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void setNameParser(NameParser nameParser) {
        this.myParser = nameParser;
    }

    public class HierContextEnumerator
    extends ContextEnumerator {
        public HierContextEnumerator(Context context, int n) throws NamingException {
            super(context, n);
        }

        protected HierContextEnumerator(Context context, int n, String string, boolean bl) throws NamingException {
            super(context, n, string, bl);
        }

        @Override
        protected NamingEnumeration<Binding> getImmediateChildren(Context context) throws NamingException {
            return ((HierMemDirCtx)context).doListBindings(false);
        }

        @Override
        protected ContextEnumerator newEnumerator(Context context, int n, String string, boolean bl) throws NamingException {
            return new HierContextEnumerator(context, n, string, bl);
        }
    }

    private final class FlatBindings
    extends BaseFlatNames<Binding> {
        private Hashtable<Name, Object> bds;
        private Hashtable<String, Object> env;
        private boolean useFactory;

        FlatBindings(Hashtable<Name, Object> hashtable, Hashtable<String, Object> hashtable2, boolean bl) {
            super(hashtable.keys());
            this.env = hashtable2;
            this.bds = hashtable;
            this.useFactory = bl;
        }

        @Override
        public Binding next() throws NamingException {
            Name name = (Name)this.names.nextElement();
            HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.bds.get(name);
            Object object = hierMemDirCtx;
            if (this.useFactory) {
                Attributes attributes = hierMemDirCtx.getAttributes("");
                try {
                    object = DirectoryManager.getObjectInstance(hierMemDirCtx, name, HierMemDirCtx.this, this.env, attributes);
                }
                catch (NamingException namingException) {
                    throw namingException;
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("Problem calling getObjectInstance");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
            }
            return new Binding(name.toString(), object);
        }
    }

    private final class FlatNames
    extends BaseFlatNames<NameClassPair> {
        FlatNames(Enumeration<Name> enumeration) {
            super(enumeration);
        }

        @Override
        public NameClassPair next() throws NamingException {
            Name name = (Name)this.names.nextElement();
            String string = HierMemDirCtx.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name.toString(), string);
        }
    }

    private abstract class BaseFlatNames<T>
    implements NamingEnumeration<T> {
        Enumeration<Name> names;

        BaseFlatNames(Enumeration<Name> enumeration) {
            this.names = enumeration;
        }

        @Override
        public final boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException namingException) {
                return false;
            }
        }

        @Override
        public final boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        @Override
        public final T nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException(namingException.toString());
            }
        }

        @Override
        public abstract T next() throws NamingException;

        @Override
        public final void close() {
            this.names = null;
        }
    }
}

