/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/*
 * Public API Surface of ngx-datatable
 */
// components
export { NgxDatatableModule } from './lib/ngx-datatable.module';
export { DatatableComponent } from './lib/components/datatable.component';
export { DataTableHeaderComponent } from './lib/components/header/header.component';
export { DataTableHeaderCellComponent } from './lib/components/header/header-cell.component';
export { DataTableBodyComponent } from './lib/components/body/body.component';
export { DataTableBodyCellComponent } from './lib/components/body/body-cell.component';
export { DataTableBodyRowComponent } from './lib/components/body/body-row.component';
export { ProgressBarComponent } from './lib/components/body/progress-bar.component';
export { ScrollerComponent } from './lib/components/body/scroller.component';
export { DataTableRowWrapperComponent } from './lib/components/body/body-row-wrapper.component';
export { DataTableSelectionComponent } from './lib/components/body/selection.component';
export { DatatableGroupHeaderDirective } from './lib/components/body/body-group-header.directive';
export { DatatableGroupHeaderTemplateDirective } from './lib/components/body/body-group-header-template.directive';
export { DataTableSummaryRowComponent } from './lib/components/body/summary/summary-row.component';
export { DataTableFooterComponent } from './lib/components/footer/footer.component';
export { DataTablePagerComponent } from './lib/components/footer/pager.component';
export { DatatableFooterDirective } from './lib/components/footer/footer.directive';
export { DataTableFooterTemplateDirective } from './lib/components/footer/footer-template.directive';
export { DataTableColumnDirective } from './lib/components/columns/column.directive';
export { DataTableColumnHeaderDirective } from './lib/components/columns/column-header.directive';
export { DataTableColumnCellDirective } from './lib/components/columns/column-cell.directive';
export { DataTableColumnCellTreeToggle } from './lib/components/columns/tree.directive';
export { DatatableRowDetailDirective } from './lib/components/row-detail/row-detail.directive';
export { DatatableRowDetailTemplateDirective } from './lib/components/row-detail/row-detail-template.directive';
// directives
export { DraggableDirective } from './lib/directives/draggable.directive';
export { LongPressDirective } from './lib/directives/long-press.directive';
export { OrderableDirective } from './lib/directives/orderable.directive';
export { ResizeableDirective } from './lib/directives/resizeable.directive';
export { VisibilityDirective } from './lib/directives/visibility.directive';
// services
export { ScrollbarHelper } from './lib/services/scrollbar-helper.service';
export { DimensionsHelper } from './lib/services/dimensions-helper.service';
export { ColumnChangesService } from './lib/services/column-changes.service';
// types
export { ColumnMode } from './lib/types/column-mode.type';
export { SortType } from './lib/types/sort.type';
export { SortDirection } from './lib/types/sort-direction.type';
export { SelectionType } from './lib/types/selection.type';
export { ClickType } from './lib/types/click.type';
export {} from './lib/types/table-column.type';
export {} from './lib/types/sort-prop-dir.type';
export { ContextmenuType } from './lib/types/contextmenu.type';
// utils
export { id } from './lib/utils/id';
export { columnsByPin, columnGroupWidths, columnTotalWidth, columnsTotalWidth, columnsByPinArr } from './lib/utils/column';
export { emptyStringGetter, getterForProp, numericIndexGetter, shallowValueGetter, deepValueGetter } from './lib/utils/column-prop-getters';
export { camelCase, deCamelCase } from './lib/utils/camel-case';
export { Keys } from './lib/utils/keys';
export { getTotalFlexGrow, adjustColumnWidths, forceFillColumnWidths } from './lib/utils/math';
export { getVendorPrefixedName } from './lib/utils/prefixes';
export { selectRows, selectRowsBetween } from './lib/utils/selection';
export { translateXY } from './lib/utils/translate';
export { throttle, throttleable } from './lib/utils/throttle';
export { nextSortDir, orderByComparator, sortRows } from './lib/utils/sort';
export { RowHeightCache } from './lib/utils/row-height-cache';
export { setColumnDefaults, isNullOrUndefined, translateTemplates } from './lib/utils/column-helper';
export { elementsFromPoint } from './lib/utils/elm-from-point';
export { optionalGetterForProp, groupRowsByParents } from './lib/utils/tree';
//# sourceMappingURL=data:application/json;base64,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