#! /usr/bin/env bash
# Copyright (C) 2022 Sebastian Pipping <sebastian@pipping.org>
# Licensed under GPL v3 or later

set -e
set -o pipefail

_BUILD_MONTH=2024-05  # for reproducible builds; bump when doing releases

sed_args=(
    # Produce familiar section "synopsis"
    -e 's,^\.SH DESCRIPTION,.SH SYNOPSIS,'
    -e 's,^usage: ,,'
    -e 's,.*\[\\-\\-yes\]$,\0\n.SH DESCRIPTION,'

    # Repair usage line bugs
    -e 's,\]\\fR,\\fR\\],'                       # un-colorize closing square bracket
    -e 's,\[\(\\-\\-[a-z\\-]\+\),[\\fB\1\\fR,g'  # colorize --argument in brackets

    # Be robust towards version difference between local help2man and CI help2man
    -e 's,It was generated by help2man .*,It was generated by help2man.,'

    # Put epilog in its own section
    -e 's,^Software libre.*,.SH EPILOG\n\0,'

    # Format "git-delete-merged-branches" in bold everywhere after section "NAME"
    -e 's,\(^\| \)\(git\\-\(delete\\-merged\\-branches\|dmb\)\) ,\n.B \2\n,g'

    # Un-colorize --merged in "git branch --merged"
    -e 's,git branch \\fB\\-\\-merged\\fR,git branch \\-\\-merged,'
)

for i in git-delete-merged-branches git-dmb ; do
    SOURCE_DATE_EPOCH="$(date --date="${_BUILD_MONTH}-15" +%s)" \
        NO_COLOR=please \
        COLUMNS=400 \
        help2man \
            --locale='en_US.UTF-8' \
            --no-info \
            --name 'Command-line tool to delete merged Git branches' \
            ${i} \
        | sed "${sed_args[@]}" \
        > ${i}.1
done
