/**
 * \file doc_mainpage.h
 *
 * \brief Main page documentation file.
 */
/*
 *
 *  Copyright The Mbed TLS Contributors
 *  SPDX-License-Identifier: Apache-2.0 OR GPL-2.0-or-later
 */

/**
 * @mainpage Mbed TLS v4.0.0 API Documentation
 *
 * This documentation describes the application programming interface (API)
 * of Mbed TLS.
 * It was automatically generated from specially formatted comment blocks in
 * Mbed TLS's source code using [Doxygen](https://www.doxygen.nl).
 *
 * ## Main entry points
 *
 * You can explore the full API from the “Files” or “Files list” section.
 * Locate the header file for the module that you are interested in and
 * explore its contents.
 *
 * Some parts of the API are best explored from the “Topics” or
 * “Group list” section.
 * This is notably the case for the PSA Cryptography API.
 * Note that many parts of the API are not classified under a topic and
 * can only be seen through the file structure.
 *
 * For information on configuring the library at compile time, see the
 * configuration header files mbedtls/mbedtls_config.h and
 * psa/crypto_config.h.
 *
 * ## Private interfaces
 *
 * For technical reasons, the rendered documentation includes elements
 * that are not considered part of the stable API. Private elements may
 * be removed or may have their semantics changed in a future minor release
 * without notice.
 *
 * The following elements are considered private:
 *
 * - Any header file whose path contains `/private`, and its contents
 *   (unless re-exported and documented in another non-private header).
 * - Any structure or union field whose name starts with `private_`.
 * - Any preprocessor macro that is just listed with its automatically
 *   rendered parameter list, value and location. Macros are part of
 *   the API only if their documentation has custom text.
 *
 */
