/* SPDX-License-Identifier: GPL-2.0-only */

#include "gpio.h"

/*
 * GPIO Pad configuration in ramstage.
 */
static const struct pad_config gpio_table_config[] = {
	PAD_CFG_GPO(GPIO_0, 1, DEEP),
	PAD_CFG_GPO(GPIO_1, 1, DEEP),
	PAD_CFG_NF(GPIO_2, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_3, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_4, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_5, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_6, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_7, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_8, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_9, DN_20K, DEEP, NF1),
	PAD_CFG_GPI(GPIO_10, DN_20K, DEEP),
	PAD_CFG_NF(GPIO_11, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_12, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_13, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_14, DN_20K, DEEP, NF1),
	PAD_CFG_GPO(GPIO_15, 1, DEEP),
	PAD_CFG_GPI(GPIO_16, UP_20K, DEEP),
	PAD_CFG_NF(GPIO_17, UP_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_18, UP_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_19, UP_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_20, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_21, DN_20K, DEEP, NF1),
	PAD_CFG_GPO(GPIO_22, 1, DEEP),/* Power Enable */
	PAD_CFG_GPO(GPIO_23, 1, DEEP),/* LB USB Power */
	PAD_CFG_NF(GPIO_24, DN_20K, DEEP, NF5),/* SATA_DEVSLP0 */
	PAD_CFG_GPI(GPIO_25, DN_20K, DEEP),/* OSS MD/DA SCI */
	PAD_CFG_NF(GPIO_26, DN_20K, DEEP, NF5),/* SATA_LEDN */
	PAD_CFG_GPO(GPIO_27, 1, DEEP),/* DFU */
	PAD_CFG_NF(GPIO_28, DN_20K, DEEP, NF2),
	PAD_CFG_NF(GPIO_29, DN_20K, DEEP, NF2),
	PAD_CFG_NF(GPIO_30, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_31, DN_20K, DEEP, NF5),/* SUSCLK1 */
	PAD_CFG_NF(GPIO_32, DN_20K, DEEP, NF5),
	PAD_CFG_NF(GPIO_33, DN_20K, DEEP, NF5),/* SUSCLK3 */
	/* PWM */
	PAD_CFG_NF(GPIO_34, DN_20K, DEEP, NF1),/* PWM */
	PAD_CFG_GPO(GPIO_35, 1, DEEP),/* Power Enable */
	PAD_CFG_NF(GPIO_36, DN_20K, DEEP, NF1),/* PWM */
	PAD_CFG_NF(GPIO_37, NONE, DEEP, NF1),/* Reset */
	/* UART */
	PAD_CFG_NF(GPIO_38, UP_20K, DEEP, NF1),/* LPSS_UART0_RXD */
	PAD_CFG_NF(GPIO_39, UP_20K, DEEP, NF1),/* LPSS_UART0_TXD */
	PAD_CFG_NF(GPIO_40, UP_20K, DEEP, NF1),/* LPSS_UART0_RTS_B */
	PAD_CFG_NF(GPIO_41, UP_20K, DEEP, NF1),/* LPSS_UART0_CTS_B */
	PAD_CFG_NF(GPIO_42, UP_20K, DEEP, NF1),/* LPSS_UART1_RXD */
	PAD_CFG_NF(GPIO_43, UP_20K, DEEP, NF1),/* LPSS_UART1_TXD */
	PAD_CFG_NF(GPIO_44, UP_20K, DEEP, NF1),/* LPSS_UART1_RTS_B */
	PAD_CFG_NF(GPIO_45, NONE, DEEP, NF1),/* LPSS_UART1_CTS_B */

	PAD_CFG_NF(GPIO_46, UP_20K, DEEP, NF1), /* LPSS_UART2_RXD */
	PAD_CFG_NF(GPIO_47, UP_20K, DEEP, NF1), /* LPSS_UART2_TXD */

	PAD_CFG_GPI(GPIO_48, UP_20K, DEEP),/* LPSS_UART2_RTS_B */
	PAD_CFG_NF(GPIO_49, UP_20K, DEEP, NF1),/* LPSS_UART2_CTS_B */
	PAD_CFG_GPO(GPIO_62, 0, DEEP),/* GP_CAMERASB00 */
	PAD_CFG_GPO(GPIO_63, 0, DEEP),/* GP_CAMERASB01 */
	PAD_CFG_GPO(GPIO_64, 0, DEEP),/* GP_CAMERASB02 */
	PAD_CFG_GPO(GPIO_65, 0, DEEP),/* GP_CAMERASB03 */
	PAD_CFG_GPO(GPIO_66, 0, DEEP),/* GP_CAMERASB04 */
	PAD_CFG_GPO(GPIO_67, 0, DEEP),/* GP_CAMERASB05 */
	PAD_CFG_GPO(GPIO_68, 0, DEEP),/* GP_CAMERASB06 */
	PAD_CFG_GPO(GPIO_69, 0, DEEP),/* GP_CAMERASB07 */
	PAD_CFG_GPO(GPIO_70, 0, DEEP),/* GP_CAMERASB08 */
	PAD_CFG_GPO(GPIO_71, 0, DEEP),/* GP_CAMERASB09 */
	PAD_CFG_GPO(GPIO_72, 0, DEEP),/* GP_CAMERASB10 */
	PAD_CFG_GPO(GPIO_73, 0, DEEP),/* GP_CAMERASB11 */
	PAD_CFG_NF(TCK, DN_20K, DEEP, NF1), /* TCK */
	PAD_CFG_NF(TRST_B, DN_20K, DEEP, NF1),/* TRST_B */
	PAD_CFG_NF(TMS, UP_20K, DEEP, NF1),/* TMS */
	PAD_CFG_NF(TDI, UP_20K, DEEP, NF1),/* TDI */
	PAD_CFG_NF(CX_PMODE, NONE, DEEP, NF1),/* CX_PMODE */
	PAD_CFG_NF(CX_PREQ_B, UP_20K, DEEP, NF1),/* CX_PREQ_B */
	PAD_CFG_NF(JTAGX, UP_20K, DEEP, NF1),/* JTAGX */
	PAD_CFG_NF(CX_PRDY_B, UP_20K, DEEP, NF1),/* CX_PRDY_B */
	PAD_CFG_NF(TDO, UP_20K, DEEP, NF1),/* TDO */
	PAD_CFG_GPI(CNV_BRI_DT, DN_20K, DEEP),/* CNV_BRI_DT */
	PAD_CFG_GPI(CNV_BRI_RSP, DN_20K, DEEP),/* CNV_BRI_RSP */
	PAD_CFG_GPI(CNV_RGI_DT, DN_20K, DEEP),/* CNV_RGI_DT */
	PAD_CFG_GPI(CNV_RGI_RSP, DN_20K, DEEP),/* CNV_RGI_RSP */
	PAD_CFG_NF(SVID0_ALERT_B, NONE, DEEP, NF1),/* SVID0_ALERT_B */
	PAD_CFG_NF(SVID0_DATA, UP_20K, DEEP, NF1),/* SVID0_DATA */
	PAD_CFG_NF(SVID0_CLK, UP_20K, DEEP, NF1),/* SVID0_CLK */

	/* North West Community */
	PAD_CFG_NF(GPIO_187, UP_20K, DEEP, NF1),/* DDI0_CTRL_DATA */
	PAD_CFG_NF(GPIO_188, UP_20K, DEEP, NF1),/* DDI0_CTRL_CLK */
	PAD_CFG_NF(GPIO_189, UP_20K, DEEP, NF1),/* DDI1_CTRL_DATA */
	PAD_CFG_NF(GPIO_190, UP_20K, DEEP, NF1),/* DDI1_CTRL_CLK */
	PAD_CFG_NF(GPIO_191, DN_20K, DEEP, NF1),/* DBI_SDA */
	PAD_CFG_NF(GPIO_192, DN_20K, DEEP, NF1),/* DBI_SCL */
	PAD_CFG_NF(GPIO_193, DN_20K, DEEP, NF1),/* DISP0_VDDEN */
	PAD_CFG_NF(GPIO_194, DN_20K, DEEP, NF1),/* DISP0_BKLTEN */
	PAD_CFG_NF(GPIO_195, DN_20K, DEEP, NF1),/* DISP0_BLTCTL */
	PAD_CFG_GPO(GPIO_196, 1, DEEP),/* DISP1_VDDEN */
	PAD_CFG_GPO(GPIO_197, 1, DEEP),/* DISP1_BKLTEN */
	PAD_CFG_GPO(GPIO_198, 1, DEEP),/* DISP1_BLTCTL */
	PAD_CFG_NF(GPIO_199, DN_20K, DEEP, NF2),/* HDMI_HPD */
	PAD_CFG_NF(GPIO_200, DN_20K, DEEP, NF2),/* EDP_HPD */
	PAD_CFG_NF(GPIO_201, DN_20K, DEEP, NF1),/* DISP_INTD_TE1 */
	PAD_CFG_NF(GPIO_202, DN_20K, DEEP, NF1),/* DISP_INTD_TE2 */
	PAD_CFG_NF(GPIO_203, UP_20K, DEEP, NF1),/* HOST_USB_OC_N */
	PAD_CFG_NF(GPIO_204, UP_20K, DEEP, NF1),/* OTG_USB_OC_N */
	PAD_CFG_NF(PMC_SPI_FS0, UP_20K, DEEP, NF1),/* PMC_SPI_FS0 */
	PAD_CFG_NF(PMC_SPI_FS1, UP_20K, DEEP, NF2),/* PMC_SPI_FS1 */
	PAD_CFG_NF(PMC_SPI_FS2, UP_20K, DEEP, NF1),/* PMC_SPI_FS2 */
	PAD_CFG_NF(PMC_SPI_RXD, DN_20K, DEEP, NF1),/* PMC_SPI_RXD */
	PAD_CFG_NF(PMC_SPI_TXD, DN_20K, DEEP, NF1),/* PMC_SPI_TXD */
	PAD_CFG_NF(PMC_SPI_CLK, DN_20K, DEEP, NF1),/* PMC_SPI_CLK */
	PAD_CFG_GPO(PMIC_PWRGOOD, 1, DEEP),/* PMIC_PWRGOOD */
	PAD_CFG_GPI(PMIC_RESET_B, NONE, DEEP),/* PMIC_RESET_B */
	PAD_CFG_GPO(GPIO_213, 0xFF, DEEP),/* PMIC_SDWN_B */
	PAD_CFG_GPO(GPIO_214, 1, DEEP),/* PMIC_BCUDISW2 */
	PAD_CFG_GPO(GPIO_215, 1, DEEP),/* PMIC_BCUDISCRIT */
	PAD_CFG_NF(PMIC_THERMTRIP_B, UP_20K, DEEP, NF1),/* PMIC_THERMTRIP_B */
	PAD_CFG_GPO(PMIC_STDBY, 1, DEEP),/* PMIC_STDBY */
	PAD_CFG_NF(PROCHOT_B, UP_20K, DEEP, NF1),/* PROCHOT_B */
	PAD_CFG_NF(PMIC_I2C_SCL, UP_1K, DEEP, NF1),/* PMIC_I2C_SCL */
	PAD_CFG_NF(PMIC_I2C_SDA, UP_1K, DEEP, NF1),/* PMIC_I2C_SDA */

	PAD_CFG_NF(GPIO_74, DN_20K, DEEP, NF1),/* AVS_I2S1_MCLK */
	PAD_CFG_NF(GPIO_75, DN_20K, DEEP, NF1),/* AVS_I2S1_BCLK */
	PAD_CFG_GPO(GPIO_76, 1, DEEP),/* AVS_I2S1_WS_SYNC */
	PAD_CFG_GPI(GPIO_77, DN_20K, DEEP),/* AVS_I2S1_SDI */
	PAD_CFG_GPI(GPIO_78, DN_20K, DEEP),/* AVS_I2S1_SDO */
	PAD_CFG_NF(GPIO_79, DN_20K, DEEP, NF1),/* AVS_M_CLK_A1 */
	PAD_CFG_NF(GPIO_80, DN_20K, DEEP, NF1),/* AVS_M_CLK_B1 */
	PAD_CFG_NF(GPIO_81, DN_20K, DEEP, NF1),/* AVS_M_DATA_1 */
	PAD_CFG_NF(GPIO_82, DN_20K, DEEP, NF1),/* AVS_M_CLK_AB2 */
	PAD_CFG_NF(GPIO_83, DN_20K, DEEP, NF1),/* AVS_M_DATA_2 */
	PAD_CFG_NF(GPIO_84, DN_20K, DEEP, NF2),/* AVS_I2S2_MCLK */
	PAD_CFG_NF(GPIO_85, DN_20K, DEEP, NF1),/* AVS_I2S2_BCLK */
	PAD_CFG_NF(GPIO_86, DN_20K, DEEP, NF1),/* AVS_I2S2_WS_SYNC */
	PAD_CFG_NF(GPIO_87, DN_20K, DEEP, NF1),/* AVS_I2S2_SDI */
	PAD_CFG_NF(GPIO_88, DN_20K, DEEP, NF1),/* AVS_I2S2_SDO */
	PAD_CFG_NF(GPIO_89, DN_20K, DEEP, NF1),/* AVS_I2S3_BCLK */
	PAD_CFG_NF(GPIO_90, DN_20K, DEEP, NF1),/* AVS_I2S3_WS_SYNC */
	PAD_CFG_NF(GPIO_91, DN_20K, DEEP, NF1),/* AVS_I2S3_SDI */
	PAD_CFG_NF(GPIO_92, DN_20K, DEEP, NF1),/* AVS_I2S3_SDO */
	PAD_CFG_NF(GPIO_97, NONE, DEEP, NF1),/* FST_SPI_CS0_B */
	PAD_CFG_NF(GPIO_98, NONE, DEEP, NF1),/* FST_SPI_CS1_B */
	PAD_CFG_NF(GPIO_99, NONE, DEEP, NF1),/* FST_SPI_MOSI_IO0 */
	PAD_CFG_NF(GPIO_100, NONE, DEEP, NF1),/* FST_SPI_MISO_IO1 */
	PAD_CFG_NF(GPIO_101, NONE, DEEP, NF1),/* FST_SPI_IO2 */
	PAD_CFG_NF(GPIO_102, NONE, DEEP, NF1),/* FST_SPI_IO3 */
	PAD_CFG_NF(GPIO_103, NONE, DEEP, NF1),/* FST_SPI_CLK */
	PAD_CFG_NF(FST_SPI_CLK_FB, NONE, DEEP, NF1),/* FST_SPI_CLK_FB */
	PAD_CFG_NF(GPIO_104, DN_20K, DEEP, NF1),/* GP_SSP_0_CLK */
	PAD_CFG_NF(GPIO_105, DN_20K, DEEP, NF1),/* GP_SSP_0_FS0 */
	PAD_CFG_NF(GPIO_106, DN_20K, DEEP, NF3),/* GP_SSP_0_FS1 */
	PAD_CFG_NF(GPIO_109, DN_20K, DEEP, NF1),/* GP_SSP_0_RXD */
	PAD_CFG_NF(GPIO_110, DN_20K, DEEP, NF1),/* GP_SSP_0_TXD */
	PAD_CFG_GPI(GPIO_111, DN_20K, DEEP),/* GP_SSP_1_CLK */
	PAD_CFG_NF(GPIO_112, DN_20K, DEEP, NF2),/* GP_SSP_1_FS0 */
	PAD_CFG_GPI(GPIO_113, DN_20K, DEEP),/* GP_SSP_1_FS1 */
	PAD_CFG_NF(GPIO_116, DN_20K, DEEP, NF2),/* GP_SSP_1_RXD */
	PAD_CFG_NF(GPIO_117, DN_20K, DEEP, NF2),/* GP_SSP_1_TXD */
	PAD_CFG_NF(GPIO_118, DN_20K, DEEP, NF1),/* GP_SSP_2_CLK */
	PAD_CFG_NF(GPIO_119, DN_20K, DEEP, NF1),/* GP_SSP_2_FS0 */
	PAD_CFG_NF(GPIO_120, DN_20K, DEEP, NF1),/* GP_SSP_2_FS1 */
	PAD_CFG_NF(GPIO_121, DN_20K, DEEP, NF1),/* GP_SSP_2_FS2 */
	PAD_CFG_NF(GPIO_122, DN_20K, DEEP, NF1),/* GP_SSP_2_RXD */
	PAD_CFG_NF(GPIO_123, DN_20K, DEEP, NF1),/* GP_SSP_2_TXD */

	/* West Community */
	PAD_CFG_NF(GPIO_124, UP_1K, DEEP, NF1),/* LPSS_I2C0_SDA */
	PAD_CFG_NF(GPIO_125, UP_1K, DEEP, NF1),/* LPSS_I2C0_SCL */
	PAD_CFG_NF(GPIO_126, UP_1K, DEEP, NF1),/* LPSS_I2C1_SDA */
	PAD_CFG_NF(GPIO_127, UP_1K, DEEP, NF1),/* LPSS_I2C1_SCL */
	PAD_CFG_NF(GPIO_128, UP_1K, DEEP, NF1),/* LPSS_I2C2_SDA */
	PAD_CFG_NF(GPIO_129, UP_1K, DEEP, NF1),/* LPSS_I2C2_SCL */
	PAD_CFG_NF(GPIO_130, UP_1K, DEEP, NF2),/* LPSS_I2C3_SDA */
	PAD_CFG_NF(GPIO_131, UP_1K, DEEP, NF2),/* LPSS_I2C3_SCL */
	PAD_CFG_NF(GPIO_132, UP_1K, DEEP, NF1),/* LPSS_I2C4_SDA */
	PAD_CFG_NF(GPIO_133, UP_1K, DEEP, NF1),/* LPSS_I2C4_SCL */

	PAD_CFG_NF(GPIO_134, UP_20K, DEEP, NF2),/* ISH_I2C0_SDA */
	PAD_CFG_NF(GPIO_135, UP_20K, DEEP, NF2),/* ISH_I2C0_SCL */
	PAD_CFG_NF(GPIO_136, UP_20K, DEEP, NF2),/* ISH_I2C1_SDA */
	PAD_CFG_NF(GPIO_137, UP_20K, DEEP, NF2),/* ISH_I2C1_SCL */

	PAD_CFG_NF(GPIO_138, UP_1K, DEEP, NF1),/* LPSS_I2C7_SDA */
	PAD_CFG_NF(GPIO_139, UP_1K, DEEP, NF1),/* LPSS_I2C7_SCL */
	PAD_CFG_NF(GPIO_146, DN_20K, DEEP, NF3),/* ISH_GPIO_0 */
	PAD_CFG_NF(GPIO_147, DN_20K, DEEP, NF3),/* ISH_GPIO_1 */
	PAD_CFG_NF(GPIO_148, DN_20K, DEEP, NF3),/* ISH_GPIO_2 */
	PAD_CFG_NF(GPIO_149, DN_20K, DEEP, NF3),/* ISH_GPIO_3 */
	PAD_CFG_NF(GPIO_150, DN_20K, DEEP, NF2),/* ISH_GPIO_4 */

	PAD_CFG_GPO(GPIO_151, 0, DEEP),/* ISH_GPIO_5 */
	PAD_CFG_NF(GPIO_152, DN_20K, DEEP, NF2),/* ISH_GPIO_6 */
	PAD_CFG_NF(GPIO_153, DN_20K, DEEP, NF1),/* ISH_GPIO_7 */
	PAD_CFG_GPO(GPIO_154, 1, DEEP),/* ISH_GPIO_8 */
	PAD_CFG_NF(GPIO_155, DN_20K, DEEP, NF2),/* ISH_GPIO_9 */

	PAD_CFG_NF(GPIO_209, NONE, DEEP, NF1),/* PCIE_CLKREQ0_B */
	PAD_CFG_NF(GPIO_210, DN_20K, DEEP, NF1),/* PCIE_CLKREQ1_B */
	PAD_CFG_NF(GPIO_211, DN_20K, DEEP, NF1),/* PCIE_CLKREQ2_B */
	PAD_CFG_NF(GPIO_212, DN_20K, DEEP, NF1),/* PCIE_CLKREQ3_B */

	PAD_CFG_NF(OSC_CLK_OUT_0, DN_20K, DEEP, NF1),/* OSC_CLK_OUT_0 */
	PAD_CFG_NF(OSC_CLK_OUT_1, DN_20K, DEEP, NF1),/* OSC_CLK_OUT_1 */
	PAD_CFG_NF(OSC_CLK_OUT_2, DN_20K, DEEP, NF1),/* OSC_CLK_OUT_2 */
	PAD_CFG_NF(OSC_CLK_OUT_3, DN_20K, DEEP, NF1),/* OSC_CLK_OUT_3 */
	PAD_CFG_GPI(OSC_CLK_OUT_4, DN_20K, DEEP),/* OSC_CLK_OUT_4 */

	PAD_CFG_NF(PMU_AC_PRESENT, DN_20K, DEEP, NF1),/*PMU_AC_PRESENT  */
	PAD_CFG_NF(PMU_BATLOW_B, UP_20K, DEEP, NF1),/* PMU_BATLOW_B */
	PAD_CFG_NF(PMU_PLTRST_B, NONE, DEEP, NF1),/* PMU_PLTRST_B */
	PAD_CFG_NF(PMU_PWRBTN_B, UP_20K, DEEP, NF1),/* PMU_PWRBTN_B */
	PAD_CFG_NF(PMU_RESETBUTTON_B, NONE, DEEP, NF1),/* PMU_RESETBUTTON_B */
	PAD_CFG_NF(PMU_SLP_S0_B, NONE, DEEP, NF1),/* PMU_SLP_S0_B */
	PAD_CFG_NF(PMU_SLP_S3_B, NONE, DEEP, NF1),/* PMU_SLP_S3_B */
	PAD_CFG_NF(PMU_SLP_S4_B, NONE, DEEP, NF1),/* PMU_SLP_S4_B */
	PAD_CFG_NF(PMU_SUSCLK, NONE, DEEP, NF1),/* PMU_SUSCLK */
	PAD_CFG_GPO(PMU_WAKE_B, 1, DEEP),/* PMU_WAKE_B */
	PAD_CFG_NF(SUS_STAT_B, NONE, DEEP, NF1),/* SUS_STAT_B */
	PAD_CFG_NF(SUSPWRDNACK, NONE, DEEP, NF1),/* SUSPWRDNACK */

	/* South West Community */
	PAD_CFG_NF(GPIO_205, UP_20K, DEEP, NF1),/* PCIE_WAKE0_B */
	PAD_CFG_NF(GPIO_206, UP_20K, DEEP, NF1),/* PCIE_WAKE1_B */
	PAD_CFG_NF(GPIO_207, UP_20K, DEEP, NF1),/* PCIE_WAKE2_B */
	PAD_CFG_NF(GPIO_208, UP_20K, DEEP, NF1),/* PCIE_WAKE3_B */
	PAD_CFG_NF(GPIO_156, DN_20K, DEEP, NF1),/* EMMC0_CLK */
	PAD_CFG_NF(GPIO_157, UP_20K, DEEP, NF1),/* EMMC0_D0 */
	PAD_CFG_NF(GPIO_158, UP_20K, DEEP, NF1),/* EMMC0_D1 */
	PAD_CFG_NF(GPIO_159, UP_20K, DEEP, NF1),/* EMMC0_D2 */
	PAD_CFG_NF(GPIO_160, UP_20K, DEEP, NF1),/* EMMC0_D3 */
	PAD_CFG_NF(GPIO_161, UP_20K, DEEP, NF1),/* EMMC0_D4 */
	PAD_CFG_NF(GPIO_162, UP_20K, DEEP, NF1),/* EMMC0_D5 */
	PAD_CFG_NF(GPIO_163, UP_20K, DEEP, NF1),/* EMMC0_D6 */
	PAD_CFG_NF(GPIO_164, UP_20K, DEEP, NF1),/* EMMC0_D7 */
	PAD_CFG_NF(GPIO_165, UP_20K, DEEP, NF1),/* EMMC0_CMD */
	PAD_CFG_NF(GPIO_166, DN_20K, DEEP, NF1),/* SDIO_CLK */
	PAD_CFG_NF(GPIO_167, UP_20K, DEEP, NF1),/* SDIO_D0 */
	PAD_CFG_NF(GPIO_168, UP_20K, DEEP, NF1),/* SDIO_D1 */
	PAD_CFG_NF(GPIO_169, UP_20K, DEEP, NF1),/* SDIO_D2 */
	PAD_CFG_NF(GPIO_170, UP_20K, DEEP, NF1),/* SDIO_D3 */
	PAD_CFG_NF(GPIO_171, UP_20K, DEEP, NF1),/* SDIO_CMD */
	PAD_CFG_NF(GPIO_172, DN_20K, DEEP, NF1),/* SDCARD_CLK */
	PAD_CFG_NF(GPIO_179, DN_20K, DEEP, NF1),/* SDCARD_CLK_FB */
	PAD_CFG_NF(GPIO_173, UP_20K, DEEP, NF1),/* SDCARD_D0 */
	PAD_CFG_NF(GPIO_174, UP_20K, DEEP, NF1),/* SDCARD_D1 */
	PAD_CFG_NF(GPIO_175, UP_20K, DEEP, NF1),/* SDCARD_D2 */
	PAD_CFG_NF(GPIO_176, UP_20K, DEEP, NF1),/* SDCARD_D3 */
	PAD_CFG_GPI(GPIO_177, NONE, DEEP),/* SDCARD_CD_B */
	PAD_CFG_NF(GPIO_178, UP_20K, DEEP, NF1),/* SDCARD_CMD */
	PAD_CFG_GPI(GPIO_186, DN_20K, DEEP),/* SDCARD_LVL_WP */
	PAD_CFG_NF(GPIO_182, DN_20K, DEEP, NF1),/* EMMC0_STROBE */
	PAD_CFG_GPO(GPIO_183, 0, DEEP),/* SDIO_PWR_DOWN_B */
	PAD_CFG_NF(SMB_ALERTB, UP_20K, DEEP, NF1),/* SMB_ALERTB */

	PAD_CFG_NF(SMB_CLK, UP_20K, DEEP, NF1),/* SMB_CLK */
	PAD_CFG_NF(SMB_DATA, UP_20K, DEEP, NF1),/* SMB_DATA */
	PAD_CFG_NF(LPC_ILB_SERIRQ, UP_20K, DEEP, NF1),/* LPC_ILB_SERIRQ */
	PAD_CFG_NF(LPC_CLKOUT0, NONE, DEEP, NF1),/*LPC_CLKOUT0  */
	PAD_CFG_NF(LPC_CLKOUT1, NONE, DEEP, NF1),/* LPC_CLKOUT1 */
	PAD_CFG_NF(LPC_AD0, UP_20K, DEEP, NF1),/* LPC_AD0 */
	PAD_CFG_NF(LPC_AD1, UP_20K, DEEP, NF1),/* LPC_AD1 */
	PAD_CFG_NF(LPC_AD2, UP_20K, DEEP, NF1),/* LPC_AD2 */
	PAD_CFG_NF(LPC_AD3, UP_20K, DEEP, NF1),/* LPC_AD3 */
	PAD_CFG_NF(LPC_CLKRUNB, UP_20K, DEEP, NF1),/* LPC_CLKRUNB */
	PAD_CFG_NF(LPC_FRAMEB, UP_20K, DEEP, NF1),/* LPC_FRAMEB */
};

const struct pad_config *gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table_config);
	return gpio_table_config;
}

/* GPIOs needed prior to ramstage. */
static const struct pad_config early_gpio_table_config[] = {
	PAD_CFG_NF(GPIO_134, UP_20K, DEEP, NF2), /* ISH_I2C0_SDA/IO-OD */
	PAD_CFG_NF(GPIO_135, UP_20K, DEEP, NF2), /* ISH_I2C0_SCL/IO-OD */
	PAD_CFG_NF(GPIO_136, UP_20K, DEEP, NF2), /* ISH_I2C1_SDA/IO-OD */
	PAD_CFG_NF(GPIO_137, UP_20K, DEEP, NF2), /* ISH_I2C1_SCL/IO-OD */

	PAD_CFG_NF(GPIO_0, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_1, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_2, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_3, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_4, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_5, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_6, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_7, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPIO_8, DN_20K, DEEP, NF1),

	/* EXP_I2C_SDA and I2C_PSS_SDA and I2C_2_SDA_IOEXP */
	PAD_CFG_NF(GPIO_7, UP_1K, DEEP, NF1),
	/* EXP_I2C_SCL and I2C_PSS_SCL and I2C_2_SCL_IOEXP */
	PAD_CFG_NF(GPIO_8, UP_1K, DEEP, NF1),

	PAD_CFG_GPO(GPIO_152, 0, DEEP), /* PERST# */
	PAD_CFG_GPO(GPIO_19, 1, DEEP), /* PFET */
	PAD_CFG_GPO(GPIO_13, 0, DEEP), /* PERST# */
	PAD_CFG_GPO(GPIO_17, 1, DEEP), /* PFET */
	PAD_CFG_GPO(GPIO_15, 0, DEEP), /* PERST# */

	PAD_CFG_NF(GPIO_210, DN_20K, DEEP, NF1), /* CLKREQ# */

	PAD_CFG_NF(SMB_CLK, UP_20K, DEEP, NF1),
	PAD_CFG_NF(SMB_DATA, UP_20K, DEEP, NF1),
	PAD_CFG_NF(LPC_ILB_SERIRQ, UP_20K, DEEP, NF1),
	PAD_CFG_NF(LPC_CLKOUT0, NONE, DEEP, NF1),
	PAD_CFG_NF(LPC_CLKOUT1, NONE, DEEP, NF1),
	PAD_CFG_NF(LPC_AD0, UP_20K, DEEP, NF1),
	PAD_CFG_NF(LPC_AD1, UP_20K, DEEP, NF1),
	PAD_CFG_NF(LPC_AD2, UP_20K, DEEP, NF1),
	PAD_CFG_NF(LPC_AD3, UP_20K, DEEP, NF1),
	PAD_CFG_NF(LPC_CLKRUNB, UP_20K, DEEP, NF1),
	PAD_CFG_NF(LPC_FRAMEB, UP_20K, DEEP, NF1),
};

const struct pad_config *early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table_config);
	return early_gpio_table_config;
}

/* GPIO settings before entering sleep. */
static const struct pad_config sleep_gpio_table_config[] = {
};

const struct pad_config *sleep_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(sleep_gpio_table_config);
	return sleep_gpio_table_config;
}
