/** @file

Copyright (c) 2015, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __GPIOCONFIG_H__
#define __GPIOCONFIG_H__
#include <stdint.h>

/* For any GpioPad usage in code use GPIO_PAD type*/
typedef u32 GPIO_PAD;	

/* For any GpioGroup usage in code use GPIO_GROUP type */	
typedef u32 GPIO_GROUP;	

/*	
  GPIO configuration structure used for pin programming.	
  Structure contains fields that can be used to configure pad.	
*/	
typedef struct {	
  /*	
  Pad Mode	
  Pad can be set as GPIO or one of its native functions.	
  When in native mode setting Direction, OutputState, Interrupt is unnecessary.	
  Refer to definition of GPIO_PAD_MODE.	
  Refer to EDS for each native mode according to the pad.	
  */	
  u32 PadMode            : 3;	
  /*	
  Host Software Pad Ownership	
  Set pad to ACPI mode or GPIO Driver Mode.	
  Refer to definition of GPIO_HOSTSW_OWN.	
  */	
  u32 HostSoftPadOwn     : 2;	
  /*	
  GPIO Direction	
  Can choose between In, In with inversion Out, both In and Out, both In with inversion and out or d
isabling both.	
  Refer to definition of GPIO_DIRECTION for supported settings.	
  */	
  u32 Direction           : 5;	
  /*	
  Output State	
  Set Pad output value.	
  Refer to definition of GPIO_OUTPUT_STATE for supported settings.	
  This setting takes place when output is enabled.	
  */	
  u32 OutputState         : 2;	
  /*	
  GPIO Interrupt Configuration	
  Set Pad to cause one of interrupts (IOxAPIC/SCI/SMI/NMI). This setting is applicable only if GPIO 
is in input mode.	
  If GPIO is set to cause an SCI then also Gpe is enabled for this pad.	
  Refer to definition of GPIO_INT_CONFIG for supported settings.	
  */	
  u32 InterruptConfig     : 8;	
  /*	
  GPIO Power Configuration.	
  This setting controls Pad Reset Configuration and Power Rail Type.	
  Refer to definition of GPIO_RESET_CONFIG for supported settings.	
  */	
  u32 PowerConfig        : 5;	
  /*	
  GPIO Electrical Configuration	
  This setting controls pads termination and voltage tolerance.	
  Refer to definition of GPIO_ELECTRICAL_CONFIG for supported settings.	
  */	
  u32 ElectricalConfig   : 7;	
  /*	
  GPIO Lock Configuration	
  This setting controls pads lock.	
  Refer to definition of GPIO_LOCK_CONFIG for supported settings.	
  */	
  u32 LockConfig         : 3;	
  /*	
  Additional GPIO configuration	
  Refer to definition of GPIO_OTHER_CONFIG for supported settings.	
  */	
  u32 OtherSettings     :  2;	
  u32 RsvdBits          : 27;	
} GPIO_CONFIG;	

typedef struct {	
  GPIO_PAD           GpioPad;	
  GPIO_CONFIG        GpioConfig;	
} GPIO_INIT_CONFIG;	

typedef enum {	
  GpioHardwareDefault = 0x0	
} GPIO_HARDWARE_DEFAULT;	

/* GPIO Pad Mode */	
typedef enum {	
  GpioPadModeGpio     = 0x1,	
  GpioPadModeNative1  = 0x3,	
  GpioPadModeNative2  = 0x5,	
  GpioPadModeNative3  = 0x7	
} GPIO_PAD_MODE;	


/* Host Software Pad Ownership modes */	
typedef enum {	
  GpioHostOwnDefault = 0x0,   /* Leave ownership value unmodified */	
  GpioHostOwnAcpi    = 0x1,   /* Set HOST ownership to ACPI */	
  GpioHostOwnGpio    = 0x3    /* Set HOST ownership to GPIO */	
} GPIO_HOSTSW_OWN;	

/* GPIO Direction */	
typedef enum {	
  GpioDirDefault    = 0x0,                /* Leave pad direction setting unmodified */	
  GpioDirInOut      = (0x1 | (0x1 << 3)), /* Set pad for both output and input */	
  GpioDirInInvOut   = (0x1 | (0x3 << 3)), /* Set pad for both output and input with inversion */	
  GpioDirIn         = (0x3 | (0x1 << 3)), /* Set pad for input only */	
  GpioDirInInv      = (0x3 | (0x3 << 3)), /* Set pad for input with inversion */	
  GpioDirOut        = 0x5,                /* Set pad for output only */	
  GpioDirNone       = 0x7                 /* Disable both output and input */	
} GPIO_DIRECTION;	

/* GPIO Output State */	
typedef enum {	
  GpioOutDefault = 0x0,	
  GpioOutLow     = 0x1,	
  GpioOutHigh    = 0x3	
} GPIO_OUTPUT_STATE;	

/*	
  GPIO interrupt configuration	
  This setting is applicable only if GPIO is in input mode.	
  GPIO_INT_CONFIG allows to choose which interrupt is generted	
  (IOxAPIC/SCI/SMI/NMI) and how it is triggered (edge or level).	
  Field from GpioIntNmi to GpioIntApic can be OR'ed with GpioIntLevel to	
  GpioIntBothEdgecan to describe an interrupt e.g. GpioIntApic | GpioIntLevel	
  If GPIO is set to cause an SCI then also Gpe is enabled for this pad.	
  Not all GPIO are capable of generating an SMI or NMI interrupt	
*/	
typedef enum {	
  GpioIntDefault   = 0x0,         /* Leave value of interrupt routing unmodified */	
  GpioIntDis       = 0x1,         /* Disable IOxAPIC/SCI/SMI/NMI interrupt generation */	
  GpioIntNmi       = 0x3,         /* Enable NMI interrupt only */	
  GpioIntSmi       = 0x5,         /* Enable SMI interrupt only */	
  GpioIntSci       = 0x9,         /* Enable SCI interrupt only */	
  GpioIntApic      = 0x11,        /* Enable IOxAPIC interrupt only */	
  GpioIntLevel     = (0x1 << 5),  /* Set interrupt as level triggered */	
  GpioIntEdge      = (0x3 << 5),  /* Set interrupt as edge triggered */ 	
  GpioIntLvlEdgDis = (0x5 << 5),  /* Disable interrupt trigger */	
  GpioIntBothEdge  = (0x7 << 5)   /* Set interrupt as both edge triggered */	
} GPIO_INT_CONFIG;	

/*	
  GPIO Power Configuration	
  GPIO_RESET_CONFIG allows to set GPIO Reset (used to reset the specified	
  Pad Register fields).	
*/	
typedef enum {	
  GpioResetDefault   = 0x0,           /* Leave value of pad reset unmodified */	
  GpioResetPwrGood   = 0x1,           /* Powergood reset */	
  GpioResetDeep      = 0x3,           /* Deep GPIO Reset */	
  GpioResetNormal    = 0x5,           /* GPIO Reset */	
  GpioResetResume    = 0x7            /* Resume Reset */	
} GPIO_RESET_CONFIG;	

/*	
  GPIO Electrical Configuration	
  Set GPIO termination and Pad Tolerance (applicable only for some pads)	
  Field from GpioTermDefault to GpioTermNative can be OR'ed with 	
  GpioTolerance1v8.	
*/	
typedef enum {	
  GpioTermDefault    = 0x0,          /* Leave termination setting unmodified */	
  GpioTermNone       = 0x1,          /* none */	
  GpioTermWpd5K      = 0x5,          /* 5kOhm weak pull-down */	
  GpioTermWpd20K     = 0x9,          /* 20kOhm weak pull-down */	
  GpioTermWpu1K      = 0x13,         /* 1kOhm weak pull-up */	
  GpioTermWpu2K      = 0x17,         /* 2kOhm weak pull-up */	
  GpioTermWpu5K      = 0x15,         /* 5kOhm weak pull-up */	
  GpioTermWpu20K     = 0x19,         /* 20kOhm weak pull-up */	
  GpioTermWpu1K2K    = 0x1B,         /* 1kOhm & 2kOhm weak pull-up */	
  GpioTermNative     = 0x1F,         /* Native function for pads termination */	
  GpioNoTolerance1v8 = (0x1 << 5),   /* Disable 1.8V pad tolerance */	
  GpioTolerance1v8   = (0x3 << 5)    /* Enable 1.8V pad tolerance */	
} GPIO_ELECTRICAL_CONFIG;	

/*	
  GPIO LockConfiguration	
  Set GPIO configuration lock and output state lock	
  GpioLockPadConfig and GpioLockOutputState can be OR'ed	
*/	
typedef enum {	
  GpioLockDefault     = 0x0,          /* Leave lock setting unmodified */	
  GpioPadConfigLock   = 0x3,          /* Lock Pad Configuration */	
  GpioOutputStateLock = 0x5           /* Lock GPIO pad output value */	
} GPIO_LOCK_CONFIG;	

/*	
  Other GPIO Configuration	
  GPIO_OTHER_CONFIG is used for less often settings and for future extensions	
  Supported settings:	
   - RX raw override to '1' - allows to override input value to '1'	
       This is applicable only if in input mode (both in GPIO and native usage)	
       The override takes place at the internal pad state directly from buffer	
       and before the RXINV.	
*/	
typedef enum {	
  GpioRxRaw1Default = 0x0,      /* Use default input override value */	
  GpioRxRaw1Dis     = 0x1,      /* Don't override input */	
  GpioRxRaw1En      = 0x3       /* Override input to '1' */	
} GPIO_OTHER_CONFIG;	

/*	
  SKL LP GPIO pins	
  Use below for functions from PCH GPIO Lib which	
  require GpioPad as argument. Encoding used here	
  has all information required by library functions	
*/	
#define GPIO_SKL_LP_GPP_A0      0x02000000	
#define GPIO_SKL_LP_GPP_A1      0x02000001	
#define GPIO_SKL_LP_GPP_A2      0x02000002	
#define GPIO_SKL_LP_GPP_A3      0x02000003	
#define GPIO_SKL_LP_GPP_A4      0x02000004	
#define GPIO_SKL_LP_GPP_A5      0x02000005	
#define GPIO_SKL_LP_GPP_A6      0x02000006	
#define GPIO_SKL_LP_GPP_A7      0x02000007	
#define GPIO_SKL_LP_GPP_A8      0x02000008	
#define GPIO_SKL_LP_GPP_A9      0x02000009	
#define GPIO_SKL_LP_GPP_A10     0x0200000A	
#define GPIO_SKL_LP_GPP_A11     0x0200000B	
#define GPIO_SKL_LP_GPP_A12     0x0200000C	
#define GPIO_SKL_LP_GPP_A13     0x0200000D	
#define GPIO_SKL_LP_GPP_A14     0x0200000E	
#define GPIO_SKL_LP_GPP_A15     0x0200000F	
#define GPIO_SKL_LP_GPP_A16     0x02000010	
#define GPIO_SKL_LP_GPP_A17     0x02000011	
#define GPIO_SKL_LP_GPP_A18     0x02000012	
#define GPIO_SKL_LP_GPP_A19     0x02000013	
#define GPIO_SKL_LP_GPP_A20     0x02000014	
#define GPIO_SKL_LP_GPP_A21     0x02000015	
#define GPIO_SKL_LP_GPP_A22     0x02000016	
#define GPIO_SKL_LP_GPP_A23     0x02000017	
#define GPIO_SKL_LP_GPP_B0      0x02010000	
#define GPIO_SKL_LP_GPP_B1      0x02010001	
#define GPIO_SKL_LP_GPP_B2      0x02010002	
#define GPIO_SKL_LP_GPP_B3      0x02010003	
#define GPIO_SKL_LP_GPP_B4      0x02010004	
#define GPIO_SKL_LP_GPP_B5      0x02010005	
#define GPIO_SKL_LP_GPP_B6      0x02010006	
#define GPIO_SKL_LP_GPP_B7      0x02010007	
#define GPIO_SKL_LP_GPP_B8      0x02010008	
#define GPIO_SKL_LP_GPP_B9      0x02010009	
#define GPIO_SKL_LP_GPP_B10     0x0201000A	
#define GPIO_SKL_LP_GPP_B11     0x0201000B	
#define GPIO_SKL_LP_GPP_B12     0x0201000C	
#define GPIO_SKL_LP_GPP_B13     0x0201000D	
#define GPIO_SKL_LP_GPP_B14     0x0201000E	
#define GPIO_SKL_LP_GPP_B15     0x0201000F	
#define GPIO_SKL_LP_GPP_B16     0x02010010	
#define GPIO_SKL_LP_GPP_B17     0x02010011	
#define GPIO_SKL_LP_GPP_B18     0x02010012	
#define GPIO_SKL_LP_GPP_B19     0x02010013	
#define GPIO_SKL_LP_GPP_B20     0x02010014	
#define GPIO_SKL_LP_GPP_B21     0x02010015	
#define GPIO_SKL_LP_GPP_B22     0x02010016	
#define GPIO_SKL_LP_GPP_B23     0x02010017	
#define GPIO_SKL_LP_GPP_C0      0x02020000	
#define GPIO_SKL_LP_GPP_C1      0x02020001	
#define GPIO_SKL_LP_GPP_C2      0x02020002	
#define GPIO_SKL_LP_GPP_C3      0x02020003	
#define GPIO_SKL_LP_GPP_C4      0x02020004	
#define GPIO_SKL_LP_GPP_C5      0x02020005	
#define GPIO_SKL_LP_GPP_C6      0x02020006	
#define GPIO_SKL_LP_GPP_C7      0x02020007	
#define GPIO_SKL_LP_GPP_C8      0x02020008	
#define GPIO_SKL_LP_GPP_C9      0x02020009	
#define GPIO_SKL_LP_GPP_C10     0x0202000A	
#define GPIO_SKL_LP_GPP_C11     0x0202000B	
#define GPIO_SKL_LP_GPP_C12     0x0202000C	
#define GPIO_SKL_LP_GPP_C13     0x0202000D	
#define GPIO_SKL_LP_GPP_C14     0x0202000E	
#define GPIO_SKL_LP_GPP_C15     0x0202000F	
#define GPIO_SKL_LP_GPP_C16     0x02020010	
#define GPIO_SKL_LP_GPP_C17     0x02020011	
#define GPIO_SKL_LP_GPP_C18     0x02020012	
#define GPIO_SKL_LP_GPP_C19     0x02020013	
#define GPIO_SKL_LP_GPP_C20     0x02020014	
#define GPIO_SKL_LP_GPP_C21     0x02020015	
#define GPIO_SKL_LP_GPP_C22     0x02020016	
#define GPIO_SKL_LP_GPP_C23     0x02020017	
#define GPIO_SKL_LP_GPP_D0      0x02030000	
#define GPIO_SKL_LP_GPP_D1      0x02030001	
#define GPIO_SKL_LP_GPP_D2      0x02030002	
#define GPIO_SKL_LP_GPP_D3      0x02030003	
#define GPIO_SKL_LP_GPP_D4      0x02030004	
#define GPIO_SKL_LP_GPP_D5      0x02030005	
#define GPIO_SKL_LP_GPP_D6      0x02030006	
#define GPIO_SKL_LP_GPP_D7      0x02030007	
#define GPIO_SKL_LP_GPP_D8      0x02030008	
#define GPIO_SKL_LP_GPP_D9      0x02030009	
#define GPIO_SKL_LP_GPP_D10     0x0203000A	
#define GPIO_SKL_LP_GPP_D11     0x0203000B	
#define GPIO_SKL_LP_GPP_D12     0x0203000C	
#define GPIO_SKL_LP_GPP_D13     0x0203000D	
#define GPIO_SKL_LP_GPP_D14     0x0203000E	
#define GPIO_SKL_LP_GPP_D15     0x0203000F	
#define GPIO_SKL_LP_GPP_D16     0x02030010	
#define GPIO_SKL_LP_GPP_D17     0x02030011	
#define GPIO_SKL_LP_GPP_D18     0x02030012	
#define GPIO_SKL_LP_GPP_D19     0x02030013	
#define GPIO_SKL_LP_GPP_D20     0x02030014	
#define GPIO_SKL_LP_GPP_D21     0x02030015	
#define GPIO_SKL_LP_GPP_D22     0x02030016	
#define GPIO_SKL_LP_GPP_D23     0x02030017	
#define GPIO_SKL_LP_GPP_E0      0x02040000	
#define GPIO_SKL_LP_GPP_E1      0x02040001	
#define GPIO_SKL_LP_GPP_E2      0x02040002	
#define GPIO_SKL_LP_GPP_E3      0x02040003	
#define GPIO_SKL_LP_GPP_E4      0x02040004	
#define GPIO_SKL_LP_GPP_E5      0x02040005	
#define GPIO_SKL_LP_GPP_E6      0x02040006	
#define GPIO_SKL_LP_GPP_E7      0x02040007	
#define GPIO_SKL_LP_GPP_E8      0x02040008	
#define GPIO_SKL_LP_GPP_E9      0x02040009	
#define GPIO_SKL_LP_GPP_E10     0x0204000A	
#define GPIO_SKL_LP_GPP_E11     0x0204000B	
#define GPIO_SKL_LP_GPP_E12     0x0204000C	
#define GPIO_SKL_LP_GPP_E13     0x0204000D	
#define GPIO_SKL_LP_GPP_E14     0x0204000E	
#define GPIO_SKL_LP_GPP_E15     0x0204000F	
#define GPIO_SKL_LP_GPP_E16     0x02040010	
#define GPIO_SKL_LP_GPP_E17     0x02040011	
#define GPIO_SKL_LP_GPP_E18     0x02040012	
#define GPIO_SKL_LP_GPP_E19     0x02040013	
#define GPIO_SKL_LP_GPP_E20     0x02040014	
#define GPIO_SKL_LP_GPP_E21     0x02040015	
#define GPIO_SKL_LP_GPP_E22     0x02040016	
#define GPIO_SKL_LP_GPP_E23     0x02040017	
#define GPIO_SKL_LP_GPP_F0      0x02050000	
#define GPIO_SKL_LP_GPP_F1      0x02050001	
#define GPIO_SKL_LP_GPP_F2      0x02050002	
#define GPIO_SKL_LP_GPP_F3      0x02050003	
#define GPIO_SKL_LP_GPP_F4      0x02050004	
#define GPIO_SKL_LP_GPP_F5      0x02050005	
#define GPIO_SKL_LP_GPP_F6      0x02050006	
#define GPIO_SKL_LP_GPP_F7      0x02050007	
#define GPIO_SKL_LP_GPP_F8      0x02050008	
#define GPIO_SKL_LP_GPP_F9      0x02050009	
#define GPIO_SKL_LP_GPP_F10     0x0205000A	
#define GPIO_SKL_LP_GPP_F11     0x0205000B	
#define GPIO_SKL_LP_GPP_F12     0x0205000C	
#define GPIO_SKL_LP_GPP_F13     0x0205000D	
#define GPIO_SKL_LP_GPP_F14     0x0205000E	
#define GPIO_SKL_LP_GPP_F15     0x0205000F	
#define GPIO_SKL_LP_GPP_F16     0x02050010	
#define GPIO_SKL_LP_GPP_F17     0x02050011	
#define GPIO_SKL_LP_GPP_F18     0x02050012	
#define GPIO_SKL_LP_GPP_F19     0x02050013	
#define GPIO_SKL_LP_GPP_F20     0x02050014	
#define GPIO_SKL_LP_GPP_F21     0x02050015	
#define GPIO_SKL_LP_GPP_F22     0x02050016	
#define GPIO_SKL_LP_GPP_F23     0x02050017	
#define GPIO_SKL_LP_GPP_G0      0x02060000	
#define GPIO_SKL_LP_GPP_G1      0x02060001	
#define GPIO_SKL_LP_GPP_G2      0x02060002	
#define GPIO_SKL_LP_GPP_G3      0x02060003	
#define GPIO_SKL_LP_GPP_G4      0x02060004	
#define GPIO_SKL_LP_GPP_G5      0x02060005	
#define GPIO_SKL_LP_GPP_G6      0x02060006	
#define GPIO_SKL_LP_GPP_G7      0x02060007	
#define GPIO_SKL_LP_GPD0        0x02070000	
#define GPIO_SKL_LP_GPD1        0x02070001	
#define GPIO_SKL_LP_GPD2        0x02070002	
#define GPIO_SKL_LP_GPD3        0x02070003	
#define GPIO_SKL_LP_GPD4        0x02070004	
#define GPIO_SKL_LP_GPD5        0x02070005	
#define GPIO_SKL_LP_GPD6        0x02070006	
#define GPIO_SKL_LP_GPD7        0x02070007	
#define GPIO_SKL_LP_GPD8        0x02070008	
#define GPIO_SKL_LP_GPD9        0x02070009	
#define GPIO_SKL_LP_GPD10       0x0207000A	
#define GPIO_SKL_LP_GPD11       0x0207000B	

#define END_OF_GPIO_TABLE   0xFFFFFFFF	

//Sample GPIO Table

static GPIO_INIT_CONFIG mGpioTableLpDdr3Rvp3[] =
{
//skip for eSPI function  {GPIO_SKL_LP_GPP_A0, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//H_RCIN_N
//skip for eSPI function  {GPIO_SKL_LP_GPP_A1, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//LPC_AD0_ESPI_IO0
//skip for eSPI function  {GPIO_SKL_LP_GPP_A2, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//LPC_AD1_ESPI_IO1
//skip for eSPI function  {GPIO_SKL_LP_GPP_A3, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//LPC_AD2_ESPI_IO2
//skip for eSPI function  {GPIO_SKL_LP_GPP_A4, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//LPC_AD3_ESPI_IO3
//skip for eSPI function  {GPIO_SKL_LP_GPP_A5,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//LPC_FRAME_ESPI_CS_N
//skip for eSPI function  {GPIO_SKL_LP_GPP_A6,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//INT_SERIRQ
//skip for eSPI function  {GPIO_SKL_LP_GPP_A7,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermNone}},//PM_SLP_S0ix_R_N
  {GPIO_SKL_LP_GPP_A8,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//PM_CLKRUN_N
//skip for eSPI function    {GPIO_SKL_LP_GPP_A9,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//LPC_CLK_ESPI_CLK
  {GPIO_SKL_LP_GPP_A10, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//PCH_CLK_PCI_TPM
  {GPIO_SKL_LP_GPP_A11, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntApic, GpioResetDeep,  GpioTermNone}},//EC_HID_INTR
  {GPIO_SKL_LP_GPP_A12, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermNone}},//M.2_WWAN_GNSS_UART_RST_N
  {GPIO_SKL_LP_GPP_A13, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SUS_PWR_ACK_R
//skip for eSPI function    {GPIO_SKL_LP_GPP_A14, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//PM_SUS_STAT_ESPI_RST_N
  {GPIO_SKL_LP_GPP_A15, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//SUSACK_R_N
  {GPIO_SKL_LP_GPP_A16, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_1P8_SEL
  {GPIO_SKL_LP_GPP_A17, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_PWR_EN_N
  {GPIO_SKL_LP_GPP_A18, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_GP_0_SENSOR
  {GPIO_SKL_LP_GPP_A19, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_GP_1_SENSOR
  {GPIO_SKL_LP_GPP_A20, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_GP_2_SENSOR
  {GPIO_SKL_LP_GPP_A21, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//GNSS_CHUB_IRQ
  {GPIO_SKL_LP_GPP_A22, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermNone}},//FPS_SLP_N
  {GPIO_SKL_LP_GPP_A23, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntApic, GpioResetDeep,  GpioTermNone}},//FPS_DRDY
  {GPIO_SKL_LP_GPP_B0,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//V0.85A_VID0
  {GPIO_SKL_LP_GPP_B1,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//V0.85A_VID1
  {GPIO_SKL_LP_GPP_B2,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//GP_VRALERTB
  {GPIO_SKL_LP_GPP_B3,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntApic, GpioResetNormal,  GpioTermNone}},//TCH_PAD_INTR_R_N
  {GPIO_SKL_LP_GPP_B4,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermNone}},//BT_RF_KILL_N
  {GPIO_SKL_LP_GPP_B5,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntApic, GpioResetDeep,  GpioTermNone}},//M.2_BT_UART_WAKE_N
  // {GPIO_SKL_LP_GPP_B6,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//CLK_REQ_SLOT1_N
  // {GPIO_SKL_LP_GPP_B7,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//CLK_REQ_SLOT2_LAN_N
  // {GPIO_SKL_LP_GPP_B8,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//CLK_REQ_M.2_SSD_SLOT3_N
  // {GPIO_SKL_LP_GPP_B9,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//CLK_REQ_M.2_WIGIG_N
  // {GPIO_SKL_LP_GPP_B10, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//CLK_REQ_M.2_WLAN_N
  {GPIO_SKL_LP_GPP_B11, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//MPHY_EXT_PWR_GATEB
  {GPIO_SKL_LP_GPP_B12, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//PCH_SLP_S0_N
  {GPIO_SKL_LP_GPP_B13, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//PLT_RST_N
  {GPIO_SKL_LP_GPP_B14, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//TCH_PNL_PWREN
  {GPIO_SKL_LP_GPP_B15, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutLow,     GpioIntDis, GpioResetDeep,  GpioTermNone}},//PCH_NFC_DFU
  {GPIO_SKL_LP_GPP_B16, {GpioPadModeGpio,    GpioHostOwnAcpi, GpioDirInInv, GpioOutDefault, GpioIntLevel | GpioIntSci, GpioResetNormal,  GpioTermNone}},//M.2_WLAN_WIFI_WAKE_N
  {GPIO_SKL_LP_GPP_B17, {GpioPadModeGpio,    GpioHostOwnAcpi, GpioDirInInv, GpioOutDefault, GpioIntEdge | GpioIntSci, GpioResetDeep,  GpioTermWpd20K}},//TBT_CIO_PLUG_EVENT_N
  {GPIO_SKL_LP_GPP_B18, {GpioPadModeGpio,    GpioHostOwnAcpi, GpioDirInInv, GpioOutDefault, GpioIntLevel | GpioIntSci, GpioResetNormal,  GpioTermWpu20K}},//PCH_SLOT1_WAKE_N
  {GPIO_SKL_LP_GPP_B19, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,   GpioTermNone}},//FPS_GSPI1_CS_R1_N
  {GPIO_SKL_LP_GPP_B20, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//FPS_GSPI1_CLK_R1
  {GPIO_SKL_LP_GPP_B21, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//FPS_GSPI1_MISO_R1
  {GPIO_SKL_LP_GPP_B22, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//FPS_GSPI1_MOSI_R1
  {GPIO_SKL_LP_GPP_B23, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//DISCRETE_GNSS_RESET_N
  {GPIO_SKL_LP_GPP_C0,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SMB_CLK
  {GPIO_SKL_LP_GPP_C1,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//SMB_DATA
  {GPIO_SKL_LP_GPP_C2,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//SKIN_THRM_SNSR_ALERT_N
  {GPIO_SKL_LP_GPP_C3,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SML0_CLK
  {GPIO_SKL_LP_GPP_C4,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SML0_DATA
  {GPIO_SKL_LP_GPP_C5,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirInInv, GpioOutDefault, GpioIntLevel | GpioIntApic, GpioResetDeep, GpioTermWpd20K}},//M.2_WIGIG_WAKE_N
  {GPIO_SKL_LP_GPP_C6,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SML1_CLK
  {GPIO_SKL_LP_GPP_C7,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//SML1_DATA
  {GPIO_SKL_LP_GPP_C8,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART0_RXD
  {GPIO_SKL_LP_GPP_C9,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART0_TXD
  {GPIO_SKL_LP_GPP_C10, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART0_RTS_N
  {GPIO_SKL_LP_GPP_C11, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART0_CTS_N
  {GPIO_SKL_LP_GPP_C12, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART1_ISH_UART1_RXD
  {GPIO_SKL_LP_GPP_C13, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART1_ISH_UART1_TXD
  {GPIO_SKL_LP_GPP_C14, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART1_ISH_UART1_RTS_N
  {GPIO_SKL_LP_GPP_C15, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART1_ISH_UART1_CTS_N
  {GPIO_SKL_LP_GPP_C16, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_I2C0_SDA
  {GPIO_SKL_LP_GPP_C17, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_I2C0_SCL
  {GPIO_SKL_LP_GPP_C18, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_I2C1_SDA
  {GPIO_SKL_LP_GPP_C19, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_I2C1_SCL
  {GPIO_SKL_LP_GPP_C20, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART2_RXD
  {GPIO_SKL_LP_GPP_C21, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART2_TXD
  {GPIO_SKL_LP_GPP_C22, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART2_RTS_N
  {GPIO_SKL_LP_GPP_C23, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SERIALIO_UART2_CTS_N
  {GPIO_SKL_LP_GPP_D0,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SPI1_TCHPNL_CS_N
  {GPIO_SKL_LP_GPP_D1,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SPI1_TCHPNL_CLK
  {GPIO_SKL_LP_GPP_D2,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SPI1_TCHPNL_MISO
  {GPIO_SKL_LP_GPP_D3,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SPI1_TCHPNL_MOSI
  {GPIO_SKL_LP_GPP_D4,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//CSI2_FLASH_STROBE
  {GPIO_SKL_LP_GPP_D5,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_I2C0_SDA
  {GPIO_SKL_LP_GPP_D6,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_I2C0_SCL
  {GPIO_SKL_LP_GPP_D7,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_I2C1_SDA
  {GPIO_SKL_LP_GPP_D8,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_I2C1_SCL
  {GPIO_SKL_LP_GPP_D9,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntDis, GpioResetDeep,  GpioTermNone}},//HOME_BTN
  {GPIO_SKL_LP_GPP_D10, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntDis, GpioResetDeep,  GpioTermNone}},//SCREEN_LOCK_PCH
  {GPIO_SKL_LP_GPP_D11, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntDis, GpioResetDeep,  GpioTermNone}},//VOL_UP_PCH
  {GPIO_SKL_LP_GPP_D12, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntDis, GpioResetDeep,  GpioTermNone}},//VOL_DOWN_PCH
  {GPIO_SKL_LP_GPP_D13, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_UART0_RXD_SML0B_DATA
  {GPIO_SKL_LP_GPP_D14, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_UART0_TXD_SML0B_CLK
  {GPIO_SKL_LP_GPP_D15, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_UART0_RTS_N
  {GPIO_SKL_LP_GPP_D16, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//ISH_UART0_CTS_SML0B_ALERT_N
  {GPIO_SKL_LP_GPP_D17, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DMIC_CLK_1
  {GPIO_SKL_LP_GPP_D18, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DMIC_DATA_1
  {GPIO_SKL_LP_GPP_D19, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DMIC_CLK_0
  {GPIO_SKL_LP_GPP_D20, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DMIC_DATA_0
  {GPIO_SKL_LP_GPP_D21, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SPI1_TCHPNL_IO2
  {GPIO_SKL_LP_GPP_D22, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SPI1_TCHPNL_IO3
  {GPIO_SKL_LP_GPP_D23, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SSP_MCLK
  {GPIO_SKL_LP_GPP_E0,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirInInv, GpioOutDefault, GpioIntEdge | GpioIntApic, GpioResetDeep,  GpioTermNone}},//SPI_TPM_HDR_IRQ_N
  {GPIO_SKL_LP_GPP_E1,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SATA_ODD_PRSNT_N
  {GPIO_SKL_LP_GPP_E2,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntLvlEdgDis | GpioIntApic, GpioResetDeep,  GpioTermNone}},//M.2_SSD_SATA2_PCIE3_DET_N
  {GPIO_SKL_LP_GPP_E3,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//EINK_SSR_DFU_N
  {GPIO_SKL_LP_GPP_E4,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//PCH_NFC_RESET
  {GPIO_SKL_LP_GPP_E5,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SATA1_PHYSLP1_DIRECT_R
  {GPIO_SKL_LP_GPP_E6,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutLow,     GpioIntDis, GpioResetDeep,  GpioTermNone}},//SATA2_PHYSLP2_M.2SSD_R
  {GPIO_SKL_LP_GPP_E8,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//PCH_SATA_LED_N
  {GPIO_SKL_LP_GPP_E9,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//USB_OC_0_WP1_OTG_N
  {GPIO_SKL_LP_GPP_E10, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//USB_OC_1_WP4_N
  {GPIO_SKL_LP_GPP_E11, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//USB_OC_2_WP2_WP3_WP5_R_N
  {GPIO_SKL_LP_GPP_E12, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntDis, GpioResetDeep,  GpioTermNone}},//PCH_NFC_IRQ
  {GPIO_SKL_LP_GPP_E13, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DDI1_HPD_Q
  {GPIO_SKL_LP_GPP_E14, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DDI2_HPD_Q
  {GPIO_SKL_LP_GPP_E15, {GpioPadModeGpio,    GpioHostOwnAcpi, GpioDirInInv, GpioOutDefault, GpioIntEdge | GpioIntSmi, GpioResetDeep,  GpioTermNone}},//SMC_EXTSMI_R_N
  {GPIO_SKL_LP_GPP_E16, {GpioPadModeGpio,    GpioHostOwnAcpi, GpioDirInInv, GpioOutDefault, GpioIntLevel | GpioIntSci, GpioResetNormal,  GpioTermNone}},//SMC_RUNTIME_SCI_R_N
  {GPIO_SKL_LP_GPP_E17, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EDP_HPD
  {GPIO_SKL_LP_GPP_E18, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DDI1_CTRL_CLK
  {GPIO_SKL_LP_GPP_E19, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//DDI1_CTRL_DATA
  {GPIO_SKL_LP_GPP_E20, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//DDI2_CTRL_CLK
  {GPIO_SKL_LP_GPP_E21, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//DDI2_CTRL_DATA
  {GPIO_SKL_LP_GPP_E22, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirInInv, GpioOutDefault, GpioIntLevel | GpioIntApic, GpioResetDeep,  GpioTermNone}},//PCH_CODEC_IRQ
  {GPIO_SKL_LP_GPP_E23, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirOut,   GpioOutHigh,    GpioIntDis, GpioResetDeep,  GpioTermWpd20K}},//TCH_PNL_RST_N
  {GPIO_SKL_LP_GPP_F0,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SSP2_SCLK
  {GPIO_SKL_LP_GPP_F1,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SSP2_SFRM
  {GPIO_SKL_LP_GPP_F2,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SSP2_TXD
  {GPIO_SKL_LP_GPP_F3,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SSP2_RXD
  {GPIO_SKL_LP_GPP_F4,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C2_SDA
  {GPIO_SKL_LP_GPP_F5,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C2_SCL
  {GPIO_SKL_LP_GPP_F6,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C3_SDA
  {GPIO_SKL_LP_GPP_F7,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C3_SCL
  {GPIO_SKL_LP_GPP_F8,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C4_SDA
  {GPIO_SKL_LP_GPP_F9,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C4_SCL
  {GPIO_SKL_LP_GPP_F10, {GpioPadModeNative2, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C5_ISH_12C2_SDA
  {GPIO_SKL_LP_GPP_F11, {GpioPadModeNative2, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep, GpioTolerance1v8 | GpioTermNone}},//SERIALIO_I2C5_ISH_12C2_SCL
  {GPIO_SKL_LP_GPP_F12, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_CMD
  {GPIO_SKL_LP_GPP_F13, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA0
  {GPIO_SKL_LP_GPP_F14, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA1
  {GPIO_SKL_LP_GPP_F15, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA2
  {GPIO_SKL_LP_GPP_F16, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA3
  {GPIO_SKL_LP_GPP_F17, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA4
  {GPIO_SKL_LP_GPP_F18, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA5
  {GPIO_SKL_LP_GPP_F19, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA6
  {GPIO_SKL_LP_GPP_F20, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_DATA7
  {GPIO_SKL_LP_GPP_F21, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_RCLK
  {GPIO_SKL_LP_GPP_F22, {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//EMMC_CLK
  {GPIO_SKL_LP_GPP_F23, {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntApic, GpioResetDeep,  GpioTermNone}},//PCH_M.2_WWAN_UIM_SIM_DET
  {GPIO_SKL_LP_GPP_G0,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_CMD
  {GPIO_SKL_LP_GPP_G1,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_DATA0
  {GPIO_SKL_LP_GPP_G2,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_DATA1
  {GPIO_SKL_LP_GPP_G3,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_DATA2
  {GPIO_SKL_LP_GPP_G4,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_DATA3
  {GPIO_SKL_LP_GPP_G5,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_CDB
  {GPIO_SKL_LP_GPP_G6,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_CLK
  {GPIO_SKL_LP_GPP_G7,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetDeep,  GpioTermNone}},//SD_WP
  {GPIO_SKL_LP_GPD0,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//PM_BATLOW_R_N
  {GPIO_SKL_LP_GPD1,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//AC_PRESENT_R
  {GPIO_SKL_LP_GPD2,   {GpioPadModeNative1, GpioHostOwnAcpi, GpioDirIn,    GpioOutDefault, GpioIntLevel | GpioIntSci, GpioResetPwrGood,  GpioTermNone}},//LANWAKE_SMC_WAKE_SCI_N
  {GPIO_SKL_LP_GPD3,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermWpu20K}},//PM_PWRBTN_R_N
  {GPIO_SKL_LP_GPD4,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//SLP_S3_R_N
  {GPIO_SKL_LP_GPD5,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//SLP_S4_R_N
  {GPIO_SKL_LP_GPD6,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//SLP_M_R_N
  {GPIO_SKL_LP_GPD7,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//USB_WAKEOUT_INTRUDET_N
  {GPIO_SKL_LP_GPD8,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//SUS_CLK
  {GPIO_SKL_LP_GPD9,   {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//PCH_SLP_WLAN_N
  {GPIO_SKL_LP_GPD10,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//SLP_S5_R_N
  {GPIO_SKL_LP_GPD11,  {GpioPadModeNative1, GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//PM_LANPHY_ENABLE
  {END_OF_GPIO_TABLE,  {GpioPadModeGpio,    GpioHostOwnGpio, GpioDirNone,  GpioOutDefault, GpioIntDis, GpioResetPwrGood,  GpioTermNone}},//Marking End of Table
};

#endif 	//_GPIO_CONFIG_H_
