---
title: Прошивка ThinkPad X200 вперше
x-toc-enable: true
...

NOTE: Libreboot standardises on [flashprog](https://flashprog.org/wiki/Flashprog)
now, as of 27 January 2024, which is a fork of flashrom.

**If you haven't bought an X200 yet: the [Dell Latitude
E6400](../../news/e6400.md) is much easier to flash; no disassembly required,
it can be flashed entirely in software from Dell BIOS to Libreboot. It is the
same hardware generation (GM45), with same CPUs, video processor, etc.**

Цей посібник призначений для тих, хто бажає libreboot на своєму ThinkPad X200,
поки у нього все ще є оригінальний Lenovo BIOS в наявності. Цього керівництва також можна
дотримуватися (адаптувати), якщо ви перетворили ваш X200 на цеглину, щоб знати, як його відновити.

Якщо у вас виконується оригінальна мікропрограма Lenovo, вам потрібно буде зняти
клавіатуру та підставку для рук, щоб мати доступ до мікросхеми флеш-пам'яті, яка знаходиться прямо
під підставкою для рук. Потім ви підключите зовнішній програматор SPI, щоб
повторно прошити мікросхему зовні, коли вона вимкнена та акумулятор висунуто.

ПРИМІТКА: Цей посібник стосується лише звичайного X200. Для перепрошивки X200S та X200 Tablet,
будь-ласка прочитайте інші посібники, доступні на libreboot.org.

Розмір флеш-чіпа
===============

Виконайте цю команду на x200, щоб дізнатися модель флеш-чіпа та його розмір:

    flashprog -p internal

MAC адреса
===========

Зверніться до [mac\_address.md](../hardware/mac_address.md).

Процедура
-------------

Цей розділ стосується X200. Цей не стосується X200S або X200
Tablet (для цих систем потрібно повністю видалити материнську плату,
оскільки мікросхема флеш-пам'яті знаходиться з іншого боку плати).

Викрутіть ці гвинти:\
![](https://av.libreboot.org/x200/disassembly/0003.jpg)

Обережно притисніть клавіатуру до екрана, потім підніміть її та за бажанням
від'єднайте від плати:\
![](https://av.libreboot.org/x200/disassembly/0004.jpg)
![](https://av.libreboot.org/x200/disassembly/0005.jpg)

Від'єднайте кабель пристрою для зчитування відбитків пальців, а потім потягніть упор для рук,
піднявши його ліву та праву сторону:\
![](https://av.libreboot.org/x200/disassembly/0006.1.jpg)
![](https://av.libreboot.org/x200/disassembly/0006.jpg)

Тут показано розташування мікросхеми флеш-пам'яті, для обох SOIC-8 та SOIC-16:\
![](https://av.libreboot.org/x200/x200_soic16.jpg)
![](https://av.libreboot.org/x200/x200_soic8.jpg)

Підніміть стрічку, яка закриває частину флеш-пам'яті, а потім
приєднайте затискач:\
![](https://av.libreboot.org/x200/disassembly/0008.jpg)

Тепер ви повинні бути готові до встановлення libreboot.

Зверніться до [інструкцій програмування SPI](spi.md).

Закінчивши, знову зберіть систему. Якщо вона не завантажується, спробуйте інші
модулі оперативної пам'яті, тому що raminit дуже ненадійний на цій платформі (в coreboot).

Пам'ять
======

У машинах DDR3 з Cantiga (GM45/GS45/PM45), північний міст потребує стіків,
які працюватимуть як PC3-8500 (швидші стіки PC3/PC3L можуть працювати як PC3-8500).
Пари, що не збігаються, можуть не працювати. Один модуль (тобто один із слотів
буде порожнім) наразі працюватиме лише в слоті 0.

ПРИМІТКА: згідно зі звітами користувачів, у деяких випадках невідповідні пари ( 1+2 ГБ) можуть
працювати в деяких випадках.

Переконайтесь, що оперативна пам'ять, яку ви купуєте, має конфігурацію 2Rx8, купуючи стіки по 4 ГБ
(Іншими словами: максимально 2 ГБ на ранг, 2 ранга на картку).

На цьому фото встановлено 8 ГБ оперативної пам'яті (2x4ГБ):

![](https://av.libreboot.org/x200/disassembly/0018.jpg)

Завантажуйтесь!
--------

Ви маєте побачити щось подібне цьому:

![](https://av.libreboot.org/x200/disassembly/0019.jpg)

Тепер [встановлюйте Linux](../linux/).

Користувачі X200S та X200 Tablet: трюк GPIO33 не спрацює.
--------------------------------------------------------

sgsit дізнався про контакт під назвою GPIO33, який можна заземлити,
щоб вимкнути захист прошивки за допомогою дескриптора та зупинити ME від
запуску (який сам по собі перешкоджає спробам прошивки). Теорія була
доведена правильною; однак на практиці це все одно марно.

Подивіться трохи вище 7 у TP37 (це GPIO33):

![](https://av.libreboot.org/x200/gpio33_location.jpg)

Це замовчуванням ми побачимо це в lenovobios, під час спроби flashprog -p
internal -w rom.rom:

    FREG0: Warning: Flash Descriptor region (0x00000000-0x00000fff) is read-only.
    FREG2: Warning: Management Engine region (0x00001000-0x005f5fff) is locked.

Коли GPIO33 було заземлено під час завантаження, це вимкнуло захист флеш-пам'яті,
встановлений дескриптором, і зупинило запуск ME. Результат змінився
на:

    The Flash Descriptor Override Strap-Pin is set. Restrictions implied by
    the Master Section of the flash descriptor are NOT in effect. Please note
    that Protected Range (PR) restrictions still apply.

Частина, виділена жирним шрифтом, - це те, що нас дістало. Це все ж спостерігалось:

    PR0: Warning: 0x007e0000-0x01ffffff is read-only.
    PR4: Warning: 0x005f8000-0x005fffff is locked.

Насправді ці засоби захисту можна відключити. Lenovobios робить це,
під час оновлення BIOS (пропрієтарного). Одним із можливих способів вирішити цю проблему
було б відлагодити утиліту оновлення BIOS від Lenovo, для віднаходження,
як вона вимикає ці засоби захисту. Додаткові дослідження доступні
тут:
<http://www.coreboot.org/Board:lenovo/x200/internal_flashing_research>

Звичайно, ймовірно, що Lenovo BIOS перевіряє якийсь біт в пам'яті,
який говорить йому не вимикати перепрошивку, а потім він не встановлює регістри PRx. Принцип
роботи програми оновлення BIOS Lenovo полягає в тому, що вона спочатку виконується в Windows,
а потім відбувається перезавантаження, ініціюючи перепрошивку під час раннього завантаження. Ймовірно,
це встановлює щось у пам'яті та завантажує ROM, плюс програму корисного навантаження,
яка виконує перепрошивання; тоді Lenovo BIOS, ймовірно, бачить це та запускає це замість
встановлення PRx і переходу до нормального завантаження. Теоретично можливо, що ми
зможемо дізнатися, як це працює, налагодивши утиліту оновлення BIOS Lenovo (у
Windows), а потім відтворивши її дії за допомогою якогось інструменту для Linux,
а потім завантаживши двійковий файл flashprog в пам'ять та ROM для прошивки (для BIOS
регіона). Ви б зробили це з заземленням GPIO33, і програма корисного навантаження
фактично прошиє весь чіп, лише звичайним образом libreboot.

Це можливо. Ймовірно, це єдиний спосіб роботи програми оновлення BIOS Lenovo.
Отже, якщо ми дізнаємося, як саме це зробити, тоді ви можете просто підключити кілька
контактів pogo для заземлення GPIO33, потім завантажитися, запустити програмне забезпечення
(яке потрібно було б написати), яке виконує вищезазначене.

У зв'язку з цим у libreboot є утиліта, яка може допомогти
розслідувати це:
[ich9utils.md#demefactory](ich9utils.md#demefactory)
