---
title: ThinkPad X200 
x-toc-enable: true
...

<div class="specs">
<center>
<img tabindex=1 alt="ThinkPad X200" class="p" src="https://av.libreboot.org/x200/disassembly/0019.jpg" /><span class="f"><img src="https://av.libreboot.org/x200/disassembly/0019.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | Lenovo                                         |
| **Name**                   | ThinkPad X200/X200S/X200 Tablet                |
| **Released**               | July/September 2009                            |
| **Chipset**                | Intel Cantiga GM45                             |
| **CPU**                    | Intel Core 2 Duo (Penryn family)               |
| **Graphics**               | Intel GMA X4500MHD                             |
| **Display**                | 1280x800/1440x900 TFT                          |
| **Memory**                 | 1,2,3 or 4GB (Upgradable to 8GB, unofficially) |
| **Architecture**           | x86_64                                         |
| **EC**                     | Proprietary                                    |
| **Original boot firmware** | LenovoBIOS                                     |
| **Intel ME/AMD PSP**       | Present. Can be completly disabled.            |
| **Flash chip**             | SOIC-8/SOIC-16/WSON-8 4MiB/8MiB (Upgradable 
                                                                    to 16MiB) |
```
W+: Works without blobs; 
N: Doesn't work; 
W*: Works with blobs; 
U: Untested; 
P+: Partially works; 
P*: Partially works with blobs
```

| ***Features*** |                                       |
|----------------|---------------------------------------|
| **Internal flashing with original boot firmware** | N  |
| **Display**                                       | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |
| **External output**                               | W+ |
| **Display brightness**                            | P+ |

| ***Payloads supported***  |           |
|---------------------------|-----------|
| **GRUB**              | Works     |
| **SeaBIOS**               | Works     |
| **SeaBIOS with GRUB** | Works     |
</div>
Dell Latitude E6400
===================

**If you haven't bought an X200 yet: the [Dell Latitude
E6400](../../news/e6400.md) is much easier to flash; no disassembly required,
it can be flashed entirely in software from Dell BIOS to Libreboot. It is the
same hardware generation (GM45), with same CPUs, video processor, etc.**

Introduction
============

It is believed that all X200 laptops are compatible. X200S and X200
Tablet will also work, [depending on the configuration](#x200s).

It may be possible to put an X200 motherboard in an X201 chassis, though this
is currently untested by the libreboot project. The same may also apply between
X200S and X201S; again, this is untested. *It's most likely true.*

There are two possible flash chip sizes for the X200: 4MiB (32Mbit) or
8MiB (64Mbit). This can be identified by the type of flash chip below
the palmrest: 4MiB is SOIC-8, 8MiB is SOIC-16.

*The X200 laptops come with the ME (and sometimes AMT in addition)
before flashing libreboot. libreboot disables and removes it by using a
modified descriptor: see [../install/ich9utils.md](../install/ich9utils.md)*
(contains notes, plus instructions)

Flashing instructions can be found at
[../install/\#flashprog](../install/#flashprog)

NOTE: Libreboot standardises on [flashprog](https://flashprog.org/wiki/Flashprog)
now, as of 27 January 2024, which is a fork of flashrom.

EC update {#ecupdate}
=========

It is recommended that you update to the latest EC firmware version. The
[EC firmware](../../faq.md#ec-embedded-controller-firmware) is separate from
libreboot, so we don't actually provide that, but if you still have
Lenovo BIOS then you can just run the Lenovo BIOS update utility, which
will update both the BIOS and EC version. See:

-   [../install/#flashprog](../install/#flashprog)
-   <http://www.thinkwiki.org/wiki/BIOS_update_without_optical_disk>
-   [X200, X200s, X200si BIOS Update](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-laptops/thinkpad-x200/downloads/ds015007)
-   [X200t BIOS Update](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-tablet-laptops/thinkpad-x200-tablet/downloads/ds018814)

NOTE: this can only be done when you are using Lenovo BIOS. How to
update the EC firmware while running libreboot is unknown. libreboot
only replaces the BIOS firmware, not EC.

Updated EC firmware has several advantages e.g. better battery
handling.

Battery Recall {#batteryrecall}
==============

[On 21 April 2015, Lenovo expanded a recall on Lenovo batteries found in some ThinkPad models, which includes the X200 and X200S.](https://pcsupport.lenovo.com/cr/en/solutions/hf004122) 
To find out if you are affected, use [this Lenovo tool.](https://lenovobattery2014.orderz.com/) 
Lenovo advises that owners of the recalled models "should turn off the system, remove the battery, 
and only power your ThinkPad by plugging in the AC adapter and power cord." 
Upon battery verification, Lenovo will replace recalled batteries free of charge. 
Battery replacement instructions for the X200/X200s are found [on this page.](https://pcsupport.lenovo.com/cr/en/parts/pd003507/)

LCD compatibility list {#lcd_supported_list}
----------------------

LCD panel list (X200 panels listed there):
<http://www.thinkwiki.org/wiki/TFT_display>

All LCD panels for the X200, X200S and X200 Tablet are known to work.

### AFFS/IPS panels {#ips}

#### X200

Adapted from
<https://github.com/bibanon/Coreboot-ThinkPads/wiki/ThinkPad-X200>

Look at wikipedia for difference between TN and IPS panels. IPS have
much better colour/contrast than a regular TN, and will typically have
good viewing angles.

These seem to be from the X200 tablet. You need to find one without the
glass touchscreen protection on it (might be able to remove it, though).
It also must not have a digitizer on it (again, might be possible to
just simply remove the digitizer).

-   BOE-Hydis HV121WX4-120, HV121WX4-110 or HV121WX4-100 - cheap-ish,
    might be hard to find

-   Samsung LTN121AP02-001 - common to find, cheap

*If your X200 has an LED backlit panel in it, then you also need to get
an inverter and harness cable that is compatible with the CCFL panels.
To see which panel type you have, see
[\#led\_howtotell](#led_howtotell). If you need the inverter/cable, here
are part numbers: 44C9909 for CCFL LVDS cable with bluetooth and camera
connections, and 42W8009 or 42W8010 for the inverter.*

There are glossy and matte versions of these. Matte means anti-glare,
which is what you want (in this authors opinion).

Refer to the HMM (hardware maintenance manual) for how to replace the
screen.

Sources:

-   [ThinkPad Forums - Matte AFFS Panel on
    X200](http://forum.thinkpads.com/viewtopic.php?f=2&t=84941)
-   [ThinkPad Forums - Parts for X200 AFFS
    Mod](http://forum.thinkpads.com/viewtopic.php?p=660662#p660662)
-   [ThinkWiki.de - X200 Displayumbau](http://thinkwiki.de/X200_Displayumbau)

### X200S

<http://forum.thinkpads.com/viewtopic.php?p=618928#p618928> explains that the
X200S screens/assemblies are thinner. You need to replace the whole lid with
one from a normal X200/X201.

How to tell if it has an LED or CCFL? {#led_howtotell}
-------------------------------------

Some X200s have a CCFL backlight and some have an LED backlight, in their LCD
panel. This also means that the inverters will vary, so you must be careful if
ever replacing either the panel and/or inverter. (a CCFL inverter is
high-voltage and will destroy an LED backlit panel).

CCFLs contain mercury. An X200 with a CCFL backlight will (unless it has been
changed to an LED, with the correct inverter. Check with your supplier!) say
the following: *"This product contains Lithium Ion Battery, Lithium Battery and
a lamp which contains mercury; dispose according to local, state or federal
laws"* (one with an LED backlit panel will say something different).

Hardware register dumps {#regdumps}
-----------------------

The coreboot wiki
[shows](http://www.coreboot.org/Motherboard_Porting_Guide) how to
collect various logs useful in porting to new boards. Following are
outputs from the X200:

-   BIOS 3.15, EC 1.06
    -   [hwdumps/x200/](hwdumps/x200/)

