---
title: HP EliteBook 2560p
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../../news/safety.md),
OR YOU MIGHT BRICK YOUR MACHINE: [SAFETY PRECAUTIONS](../../news/safety.md)**

<div class="specs">
<center>
<img tabindex=1 alt="HP EliteBook 2560p" class="p" src="https://av.libreboot.org/hp2560p/grub.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2560p/grub.jpg" /></span>
</center>

| ***Specifications***      |                                   |
|---------------------------|-----------------------------------|
| **Manufacturer**          | HP                                |
| **Name**                  | EliteBook 2560p                   |
| **Released**              | 2011                              |
| **Chipset**               | Intel QM67                        |
| **CPU**                   | Intel Sandy Bridge, socketed      |
| **Graphics**              | Intel HD Graphics                 |
| **Display**               | 12.5" 1366x768                    |
| **Memory**                | Up to 16GB (2x8GB)                |
| **Architecture**          | x86_64                            |
| **EC**                    | KBC1126, proprietary              |
| **Intel ME/AMD PSP**      | Present, neutered                 |
| **Flash chip**            | SOIC-8 8MiB                       |


| ***Payloads supported***  |       |
|---------------------------|-------|
| **GRUB**                  | Works |
| **SeaBIOS**               | Works |
| **SeaBIOS with GRUB**     | Works |
</div>


BROKEN WIFI
===========

Wifi is broken in current revisions. This is because hardware `rfkill` is set,
and pressing the button combo to enable wifi doesn't work; we believe that the
EC is sending rfkill. We do not yet know how to enable it, at least as of
Libreboot 202405xx.

Introduction
============

Libreboot has support for this, in the Git repository and release versions
from Libreboot 20230423 onwards.

Brief board info
----------------

HP EliteBook 2560p is a 12.5" laptop you can read more about here:

<https://support.hp.com/us-en/product/hp-elitebook-2560p-notebook-pc/5071201>

Installation of Libreboot
-------------------------

You can actually just compile the Libreboot ROM for this, and flash the
entire ROM, then flash it. The *coreboot* project proper, has information
about this:

<https://doc.coreboot.org/mainboard/hp/2560p.html#programming>

Refer to the coreboot guide for flashing instructions, and you can build the
images for it in Libreboot like so:

	./build roms hp2560p_8mb

More information about building ROM images can be found in
the [build guide](../build/).

This is a *Sandybridge* board which means that a neutered ME image is required
if you wish to flash the ME region. Libreboot's build system automatically
downloads, neuters (using `me_cleaner`) and inserts this if compiling from
source.

If you're using *Libreboot release* ROM images, the ME image has been scrubbed
and you must re-insert it. Use the information on this guide to know how
to do that:

[Insert vendor files on Intel Sandybridge/Ivybridge/Haswell
platforms](../install/ivy_has_common.md)

You may also wish to change the *default MAC address* if you're planning to
use the onboard Intel Gigabit Ethernet. You can do this using the information
in the same guide linked above, or read the nvmutil manual:

[Modify MAC addresses with nvmutil](../install/nvmutil.md).

