/* SPDX-License-Identifier: GPL-2.0-only */

#include <gpio.h>
#include <soc/meminit.h>
#include <soc/romstage.h>
#include <string.h>
#include <variants.h>
#include <types.h>

/* Early pad configuration in bootblock. */
const struct pad_config early_gpio_table[] = {
	/* GPIO_64:	UART2_TXD	*/
	PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_64, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),
	/* GPIO_65:	UART2_RXD	*/
	PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_65, UP_20K, DEEP, NF1, TxLASTRxE, DISPUPD),
};

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}

/* Pad configuration in ramstage. */
const struct pad_config gpio_table[] = {
	/* ------- GPIO Group NorthWest ------- */
	/* GPIO_0:	XDP_H_TCK		*/
	PAD_NC(GPIO_0, DN_20K),
	/* GPIO_1:	XDP_H_TRST_N		*/
	PAD_NC(GPIO_1, DN_20K),
	/* GPIO_2:	XDP_H_TMS		*/
	PAD_NC(GPIO_2, DN_20K),
	/* GPIO_3:	XDP_H_TDI		*/
	PAD_NC(GPIO_3, DN_20K),
	/* GPIO_4:	XDP_H_TDO		*/
	PAD_NC(GPIO_4, DN_20K),
	/* GPIO_5:	Not Connected		*/
	PAD_NC(GPIO_5, DN_20K),
	/* GPIO_6:	XDP_H_PREQ_N		*/
	PAD_NC(GPIO_6, DN_20K),
	/* GPIO_7:	XDP_H_PRDY_N		*/
	PAD_NC(GPIO_7, DN_20K),
	/* GPIO_8:	Not Connected		*/
	PAD_NC(GPIO_8, DN_20K),
	/* GPIO_9:	Not Connected		*/
	PAD_NC(GPIO_9, DN_20K),
	/* GPIO_10:	Not Connected		*/
	PAD_NC(GPIO_10, DN_20K),
	/* GPIO_11:	Not Connected		*/
	PAD_NC(GPIO_11, DN_20K),
	/* GPIO_12:	Not Connected		*/
	PAD_NC(GPIO_12, DN_20K),
	/* GPIO_13:	Not Connected		*/
	PAD_NC(GPIO_13, DN_20K),
	/* GPIO_14:	Not Connected		*/
	PAD_NC(GPIO_14, DN_20K),
	/* GPIO_15:	Not Connected		*/
	PAD_NC(GPIO_15, DN_20K),
	/* GPIO_16:	Not Connected		*/
	PAD_NC(GPIO_16, DN_20K),
	/* GPIO_17:	Not Connected		*/
	PAD_NC(GPIO_17, DN_20K),
	/* GPIO_18:	Not Connected		*/
	PAD_NC(GPIO_18, DN_20K),
	/* GPIO_19:	PMIC_IRQ#		*/
	_PAD_CFG_STRUCT(GPIO_19, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(EDGE_SINGLE) |
		PAD_IRQ_ROUTE(IOAPIC) | PAD_BUF(TX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) |
		PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(ENPU)),
	/* GPIO_20:	Not Connected		*/
	PAD_NC(GPIO_20, DN_20K),
	/* GPIO_21:	Not Connected		*/
	PAD_NC(GPIO_21, DN_20K),
	/* GPIO_22:	Not Connected		*/
	PAD_NC(GPIO_22, DN_20K),
	/* GPIO_23:	Not Connected		*/
	PAD_NC(GPIO_23, DN_20K),
	/* GPIO_24:	Not Connected		*/
	PAD_NC(GPIO_24, DN_20K),
	/* GPIO_25:	Not Connected		*/
	PAD_NC(GPIO_25, DN_20K),
	/* GPIO_26:	TCH_INT_N		*/
	PAD_NC(GPIO_26, DN_20K),
	/* GPIO_27:	GPIO_27			*/
	PAD_NC(GPIO_27, DN_20K),
	/* GPIO_28:	GPIO_28			*/
	PAD_NC(GPIO_27, DN_20K),
	/* GPIO_29:	Not Connected		*/
	PAD_NC(GPIO_29, DN_20K),
	/* GPIO_30:	SAR_PROX_INT		*/
	_PAD_CFG_STRUCT(GPIO_30, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_IRQ_ROUTE(IOAPIC) |
		PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) |
		PAD_IOSSTATE(IGNORE)),
	/* GPIO_31:	ACCEL1_INT		*/
	PAD_NC(GPIO_31, DN_20K),
	/* GPIO_32:	SAR_PROX_RST		*/
	PAD_CFG_GPI_TRIG_IOS_OWN(GPIO_32, DN_20K, DEEP, OFF, IGNORE, ENPD, ACPI),
	/* GPIO_33:	Not Connected		*/
	PAD_NC(GPIO_33, DN_20K),
	/* GPIO_34:	Not Connected		*/
	PAD_NC(GPIO_34, DN_20K),
	/* GPIO_35:	Not Connected		*/
	PAD_NC(GPIO_35, DN_20K),
	/* GPIO_36:	Not Connected		*/
	PAD_NC(GPIO_36, DN_20K),
	/* GPIO_37:	Not Connected		*/
	PAD_NC(GPIO_37, DN_20K),
	/* GPIO_38:	WAKE_SCI#		*/
	_PAD_CFG_STRUCT(GPIO_38, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(EDGE_SINGLE) |
		PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_39:	FP_RST#			*/
	PAD_NC(GPIO_39, DN_20K),
	/* GPIO_40:	Not Connected		*/
	PAD_NC(GPIO_40, DN_20K),
	/* GPIO_41:	Not Connected		*/
	PAD_NC(GPIO_41, DN_20K),
	/* GPIO_42:	SECURITY_FLASH		*/
	_PAD_CFG_STRUCT(GPIO_42, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K)),
	/* GPIO_43:	GPIO_43			*/
	_PAD_CFG_STRUCT(GPIO_43, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K)),
	/* GPIO_44:	GPIO_44			*/
	_PAD_CFG_STRUCT(GPIO_44, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSTERM(ENPU)),
	/* GPIO_45:	GPIO_45			*/
	_PAD_CFG_STRUCT(GPIO_45, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSTERM(ENPU)),
	/* GPIO_46:	Not Connected		*/
	PAD_NC(GPIO_46, DN_20K),
	/* GPIO_47:	Not Connected		*/
	PAD_NC(GPIO_47, DN_20K),
	/* GPIO_48:	OZ8283_I2C_SDA		*/
	_PAD_CFG_STRUCT(GPIO_48, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_1K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_49:	OZ8283_I2C_SCL		*/
	_PAD_CFG_STRUCT(GPIO_49, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_1K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_50:	ISH_I2C0_SDA		*/
	_PAD_CFG_STRUCT(GPIO_50, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_1K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	/* GPIO_51:	ISH_I2C0_SCL		*/
	_PAD_CFG_STRUCT(GPIO_51, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_1K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	/* GPIO_52:	I2C1_SDA		*/
	_PAD_CFG_STRUCT(GPIO_52, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	/* GPIO_53:	I2C1_SCL		*/
	_PAD_CFG_STRUCT(GPIO_53, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	/* GPIO_54:	Not Connected		*/
	PAD_NC(GPIO_54, DN_20K),
	/* GPIO_55:	Not Connected		*/
	PAD_NC(GPIO_55, DN_20K),
	/* GPIO_56:	Not Connected		*/
	PAD_NC(GPIO_56, DN_20K),
	/* GPIO_57:	Not Connected		*/
	PAD_NC(GPIO_57, DN_20K),
	/* GPIO_57:	TOUCH_I2C_SDA		*/
	PAD_NC(GPIO_58, DN_20K),
	/* GPIO_57:	TOUCH_I2C_CLK		*/
	PAD_NC(GPIO_59, DN_20K),
	_PAD_CFG_STRUCT(GPIO_60, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_61, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPIO_62, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_63, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	/* GPIO_66:	UART2_RTS		*/
	PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_66, 1, DEEP, UP_20K, TxLASTRxE, ENPU),
	/* GPIO_67:	EC_SMI_N		*/
	_PAD_CFG_STRUCT(GPIO_67, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_IRQ_ROUTE(SMI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) |
		(1 << 1), PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	_PAD_CFG_STRUCT(GPIO_68, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_69, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_70, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_71, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_72, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_73, 1, DEEP, UP_20K, IGNORE, ENPU),
	_PAD_CFG_STRUCT(GPIO_74, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(UP_20K)
		| PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	_PAD_CFG_STRUCT(GPIO_75, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),
	/* GPIO_211 - RESERVED */
	/* GPIO_212:	Not Connected		*/
	 PAD_NC(GPIO_212, DN_20K),
	/* GPIO_213:	Not Connected		*/
	PAD_NC(GPIO_213, DN_20K),
	/* GPIO_214:	Not Connected		*/
	PAD_NC(GPIO_214, DN_20K),

	/* ------- GPIO Group North ------- */
	/* GPIO_76:	VCCIN_VIDALERT_N	*/
	_PAD_CFG_STRUCT(GPIO_76, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_IOSSTATE(IGNORE)),
	/* GPIO_77:	VCCIN_VIDSOUT		*/
	_PAD_CFG_STRUCT(GPIO_77, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_IOSSTATE(IGNORE)),
	/* GPIO_78:	VCCIN_VIDSCK		*/
	_PAD_CFG_STRUCT(GPIO_78, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_IOSSTATE(IGNORE)),
	/* GPIO_79:	FP_SSP0_CLK		*/
	_PAD_CFG_STRUCT(GPIO_79, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPD)),
	/* GPIO_80:	FP_SSP0_FS0		*/
	_PAD_CFG_STRUCT(GPIO_80, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPD)),
	/* GPIO_81:	GPIO_81			*/
	_PAD_CFG_STRUCT(GPIO_81, PAD_FUNC(NF3) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF) | (1 << 1), PAD_PULL(DN_20K) | PAD_IOSSTATE(IGNORE)),
	/* GPIO_82:	FP_SSP0_MISO		*/
	_PAD_CFG_STRUCT(GPIO_82, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPD)),
	/* GPIO_83:	GPIO_83			*/
	_PAD_CFG_STRUCT(GPIO_83, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPD)),

	PAD_CFG_GPI_TRIG_OWN(GPIO_84, DN_20K, DEEP, OFF, ACPI),
	PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_85, 1, DEEP, UP_20K, IGNORE, ENPU),
	_PAD_CFG_STRUCT(GPIO_86, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K)),
	_PAD_CFG_STRUCT(GPIO_87, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_88, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_89, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_90, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE) | (1 << 1), PAD_PULL(NATIVE)),
	_PAD_CFG_STRUCT(GPIO_91, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE) | PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_92, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE), PAD_PULL(NATIVE)),
	_PAD_CFG_STRUCT(GPIO_93, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE) | (1 << 1), PAD_PULL(NATIVE)),
	_PAD_CFG_STRUCT(GPIO_94, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE) | (1 << 1), PAD_PULL(NATIVE)),
	_PAD_CFG_STRUCT(GPIO_95, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE) | (1 << 1), PAD_PULL(NATIVE)),
	_PAD_CFG_STRUCT(GPIO_96, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE), PAD_PULL(NATIVE)),
	/* GPIO_97:	GPIO_97			*/
	_PAD_CFG_STRUCT(GPIO_97, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE), PAD_PULL(NATIVE)),
	/* GPIO_98:	PMU_PLTRST_N		*/
	_PAD_CFG_STRUCT(GPIO_98, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_IOSSTATE(IGNORE)),
	/* GPIO_99:	SOC_PMU_PWRBTN_N	*/
	_PAD_CFG_STRUCT(GPIO_99, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_100:	SLP_S0#			*/
	_PAD_CFG_STRUCT(GPIO_100, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_IOSSTATE(IGNORE)),
	/* GPIO_101:	SLP_S3#			*/
	_PAD_CFG_STRUCT(GPIO_101, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_IOSSTATE(IGNORE)),
	/* GPIO_102:	SLP_S4#			*/
	_PAD_CFG_STRUCT(GPIO_102, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_IOSSTATE(IGNORE)),
	/* GPIO_103:	SUSPWRDNACK		*/
	_PAD_CFG_STRUCT(GPIO_103, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_IOSSTATE(IGNORE)),
	/* GPIO_104:	Not Connected		*/
	PAD_NC(GPIO_104, DN_20K),
	/* GPIO_105:	GPIO_105		*/
	_PAD_CFG_STRUCT(GPIO_105, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_106:	PMU_BATLOW_N		*/
	_PAD_CFG_STRUCT(GPIO_106, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_107:	PMU_RSTBTN#		*/
	_PAD_CFG_STRUCT(GPIO_107, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_108:	SUS_CLK			*/
	_PAD_CFG_STRUCT(GPIO_108, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_IOSSTATE(IGNORE)),
	/* GPIO_109:	PMU_SUS_STAT#		*/
	_PAD_CFG_STRUCT(GPIO_109, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_IOSSTATE(IGNORE)),
	/* GPIO_110:	Not Connected		*/
	PAD_NC(GPIO_110, DN_20K),
	/* GPIO_111:	Not Connected		*/
	PAD_NC(GPIO_111, DN_20K),
	/* GPIO_112:	Not Connected		*/
	PAD_NC(GPIO_112, DN_20K),
	/* GPIO_113:	Not Connected		*/
	PAD_NC(GPIO_113, DN_20K),
	/* GPIO_114:	I2C_SDA_CPU		*/
	_PAD_CFG_STRUCT(GPIO_114, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_1K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	/* GPIO_115:	I2C_SDL_CPU		*/
	_PAD_CFG_STRUCT(GPIO_115, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_1K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	/* GPIO_116:	WLAN_PCIE_WAKE#		*/
	_PAD_CFG_STRUCT(GPIO_116, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE) | PAD_IOSTERM(ENPU)),
	/* GPIO_117:	WLAN_PCIE_WAKE#1	*/
	PAD_NC(GPIO_117, DN_20K),
	/* GPIO_118:	Not Connected		*/
	PAD_NC(GPIO_118, DN_20K),
	/* GPIO_119:	Not Connected		*/
	PAD_NC(GPIO_119, DN_20K),
	/* GPIO_120:	WLAN_CLK_REQ#		*/
	_PAD_CFG_STRUCT(GPIO_120, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	/* GPIO_121:	WLAN_CLK_REQ#		*/
	_PAD_CFG_STRUCT(GPIO_121, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	/* GPIO_122:	Not Connected		*/
	PAD_NC(GPIO_122, DN_20K),
	/* GPIO_123:	Not Connected		*/
	PAD_NC(GPIO_123, DN_20K),
	/* GPIO_124:	DDI0_DDC_SDA		*/
	_PAD_CFG_STRUCT(GPIO_124, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_IOSSTATE(HIZCRx0) | PAD_IOSTERM(ENPU)),
	/* GPIO_125:	DDI0_DDC_SCL		*/
	_PAD_CFG_STRUCT(GPIO_125, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_IOSSTATE(HIZCRx0) | PAD_IOSTERM(ENPU)),
	/* GPIO_126:	Not Connected		*/
	PAD_NC(GPIO_126, DN_20K),
	/* GPIO_127:	Not Connected		*/
	PAD_NC(GPIO_127, DN_20K),
	/* GPIO_128:	EDP_VDD_EN		*/
	_PAD_CFG_STRUCT(GPIO_128, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_PULL(DN_20K) | PAD_IOSSTATE(Tx0RxDCRx0) | PAD_IOSTERM(ENPD)),
	/* GPIO_129:	EDP_BKLT_EN		*/
	_PAD_CFG_STRUCT(GPIO_129, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_PULL(DN_20K) | PAD_IOSSTATE(Tx0RxDCRx0) | PAD_IOSTERM(ENPD)),
	/* GPIO_130:	EDP_BKLT_PWM		*/
	_PAD_CFG_STRUCT(GPIO_130, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF),
		PAD_PULL(DN_20K) | PAD_IOSSTATE(Tx0RxDCRx0) | PAD_IOSTERM(ENPD)),
	/* GPIO_131:	DDI0_HPD_N		*/
	_PAD_CFG_STRUCT(GPIO_131, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(ENPU)),
	/* GPIO_132:	DDI0_HPD_SOC		*/
	_PAD_CFG_STRUCT(GPIO_132, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(UP_20K) | PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(ENPU)),
	/* GPIO_133:	EDP_HPD_LS		*/
	_PAD_CFG_STRUCT(GPIO_133, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_IOSSTATE(TxDRxE) | PAD_IOSTERM(ENPU)),
	/* GPIO_134:	Touch_Panel_RST#	*/
	PAD_NC(GPIO_134, DN_20K),
	/* GPIO_15:	MIPI_RST		*/
	PAD_CFG_GPI_TRIG_OWN(GPIO_135, DN_20K, DEEP, OFF, ACPI),
	/* GPIO_136:	Not Connected		*/
	PAD_NC(GPIO_136, DN_20K),
	/* GPIO_137:	Not Connected		*/
	PAD_NC(GPIO_137, DN_20K),
	/* GPIO_138:	GPIO_138		*/
	_PAD_CFG_STRUCT(GPIO_138, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	/* GPIO_139:	Not Connected		*/
	PAD_NC(GPIO_139, DN_20K),
	/* GPIO_140:	SATA_DEVSLP_C		*/
	PAD_CFG_GPI_TRIG_OWN(GPIO_140, DN_20K, DEEP, OFF, ACPI),
	/* GPIO_141:	Not Connected		*/
	PAD_NC(GPIO_141, DN_20K),
	/* GPIO_142:	PMU_WAKE#		*/
	_PAD_CFG_STRUCT(GPIO_142, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_IRQ_ROUTE(IOAPIC) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) |
		(1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPU)),
	/* GPIO_143:	Not Connected		*/
	PAD_NC(GPIO_143, DN_20K),
	_PAD_CFG_STRUCT(GPIO_144, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_145, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_146, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_147, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) | PAD_IOSTERM(ENPU)),
	_PAD_CFG_STRUCT(GPIO_148, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(HIZCRx1)),
	_PAD_CFG_STRUCT(GPIO_149, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(HIZCRx1)),
	_PAD_CFG_STRUCT(GPIO_150, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) |
		PAD_IOSTERM(ENPU)),
	_PAD_CFG_STRUCT(GPIO_151, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) |
		PAD_IOSTERM(ENPU)),
	_PAD_CFG_STRUCT(GPIO_152, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) |
		PAD_IOSTERM(ENPU)), _PAD_CFG_STRUCT(GPIO_153, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) |
		PAD_IOSTERM(ENPU)), _PAD_CFG_STRUCT(GPIO_154, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPIO_155, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K) | PAD_IOSSTATE(HIZCRx1) |
		PAD_IOSTERM(ENPU)),

	/* ----- GPIO Group Audio ----- */
	/* GPIO_156:	FP_INT#			*/
	PAD_NC(GPIO_156, DN_20K),
	PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_157, 1, DEEP, UP_20K, IGNORE, ENPU),
	_PAD_CFG_STRUCT(GPIO_158, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	PAD_CFG_GPI_TRIG_OWN(GPIO_159, DN_20K, DEEP, OFF, ACPI),
	PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_160, 1, DEEP, UP_20K, TxLASTRxE, ENPU),
	PAD_CFG_GPI_TRIG_OWN(GPIO_161, DN_20K, DEEP, OFF, ACPI),
	_PAD_CFG_STRUCT(GPIO_162, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_163, 1, DEEP, UP_20K, IGNORE, ENPU),
	/* GPIO_164:	GPIO_164		*/
	PAD_CFG_GPI_TRIG_OWN(GPIO_164, DN_20K, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPIO_165, DN_20K, DEEP, OFF, ACPI),
	_PAD_CFG_STRUCT(GPIO_166, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPD)),
	_PAD_CFG_STRUCT(GPIO_167, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPD)),
	_PAD_CFG_STRUCT(GPIO_168, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_IOSSTATE(HIZCRx1)),
	_PAD_CFG_STRUCT(GPIO_169, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPD)),
	_PAD_CFG_STRUCT(GPIO_170, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(DN_20K) | PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(ENPD)),
	_PAD_CFG_STRUCT(GPIO_171, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	PAD_CFG_GPI_TRIG_OWN(GPIO_172, DN_20K, DEEP, OFF, ACPI),
	_PAD_CFG_STRUCT(GPIO_173, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	PAD_CFG_GPO_IOSSTATE_IOSTERM(GPIO_174, 1, DEEP, UP_20K, TxLASTRxE, ENPU),
	PAD_CFG_GPI_TRIG_OWN(GPIO_175, DN_20K, DEEP, OFF, ACPI),

	/* ----- GPIO Group SCC ----- */
	/* GPIO_176:	TP_INT#			*/
	PAD_CFG_GPI_GPIO_DRIVER(GPIO_176, NONE, PLTRST),
	/* GPIO_177:	SMB_SOC_CLK		*/
	_PAD_CFG_STRUCT(GPIO_177, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),
	/* GPIO_178:	Not Connected		*/
	PAD_NC(GPIO_178, DN_20K),
	/* GPIO_197:	Not Connected		*/
	PAD_NC(GPIO_197, DN_20K),
	/* GPIO_179:	Not Connected		*/
	PAD_NC(GPIO_179, DN_20K),
	/* GPIO_181:	Not Connected		*/
	PAD_NC(GPIO_181, DN_20K),
	/* GPIO_182:	Not Connected		*/
	PAD_NC(GPIO_182, DN_20K),
	/* GPIO_183:	Not Connected		*/
	PAD_NC(GPIO_183, DN_20K),
	/* GPIO_184:	Not Connected		*/
	PAD_NC(GPIO_184, DN_20K),
	/* GPIO_185:	Not Connected		*/
	PAD_NC(GPIO_185, DN_20K),
	/* GPIO_186:	Not Connected		*/
	PAD_NC(GPIO_186, DN_20K),
	/* GPIO_187:	Not Connected		*/
	PAD_NC(GPIO_187, DN_20K),
	/* GPIO_188:	SDMMC3_PWR_EN_N		*/
	_PAD_CFG_STRUCT(GPIO_188, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	/* GPIO_210:	GPIO_210		*/
	_PAD_CFG_STRUCT(GPIO_210, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),
	/* GPIO_189:	Not Connected		*/
	PAD_NC(GPIO_189, DN_20K),
	/* GPIO_190:	Not Connected		*/
	PAD_NC(GPIO_190, DN_20K),

	_PAD_CFG_STRUCT(GPIO_191, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_192, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF) | (1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE) |
		PAD_IOSTERM(ENPU)),
	_PAD_CFG_STRUCT(GPIO_193, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_194, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE) |
		PAD_IOSTERM(ENPU)),
	/* GPIO_195:	CNVI_RF_RESET_N		*/
	_PAD_CFG_STRUCT(GPIO_195, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_IOSSTATE(IGNORE)),

	_PAD_CFG_STRUCT(GPIO_196, PAD_FUNC(NF1) | PAD_RESET(DEEP) |
		PAD_TRIG(OFF), PAD_IOSSTATE(IGNORE)),
	_PAD_CFG_STRUCT(GPIO_197, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) |
		PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K) | PAD_IOSTERM(ENPD)),
	/* GPIO_198:	EMMC_CLK		*/
	PAD_NC(GPIO_198, DN_20K),
	/* GPIO_200:	EMMC_DATA_0		*/
	PAD_NC(GPIO_200, DN_20K),
	/* GPIO_201:	EMMC_DATA_1		*/
	PAD_NC(GPIO_201, DN_20K),
	/* GPIO_202:	EMMC_DATA_2		*/
	PAD_NC(GPIO_202, DN_20K),
	/* GPIO_203:	EMMC_DATA_3		*/
	PAD_NC(GPIO_203, DN_20K),
	/* GPIO_204:	EMMC_DATA_4		*/
	PAD_NC(GPIO_204, DN_20K),
	/* GPIO_205:	EMMC_DATA_5		*/
	PAD_NC(GPIO_205, DN_20K),
	/* GPIO_206:	EMMC_DATA_6		*/
	PAD_NC(GPIO_206, DN_20K),
	/* GPIO_207:	EMMC_DATA_7		*/
	PAD_NC(GPIO_207, DN_20K),
	/* GPIO_208:	EMMC_CMD		*/
	PAD_NC(GPIO_208, DN_20K),
	/* GPIO_209:	EMMC_STROBE		*/
	PAD_NC(GPIO_209, DN_20K),
};

const struct pad_config *variant_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table);
	return gpio_table;
}
