/*
 * This file is part of the coreboot project.
 *
 * Copyright 2014 Google Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __SOC_NVIDIA_TEGRA132_PINMUX_H__
#define __SOC_NVIDIA_TEGRA132_PINMUX_H__

#include <stdint.h>
#include <soc/nvidia/tegra/gpio.h>
#include <soc/nvidia/tegra/pinmux.h>

enum {
	PINMUX_FUNC_MASK = 3 << 0,

	PINMUX_PULL_MASK = 3 << 2,
	PINMUX_PULL_NONE = 0 << 2,
	PINMUX_PULL_DOWN = 1 << 2,
	PINMUX_PULL_UP = 2 << 2,

	PINMUX_TRISTATE = 1 << 4,
	PINMUX_INPUT_ENABLE = 1 << 5,
	PINMUX_OPEN_DRAIN = 1 << 6,
	PINMUX_LOCK = 1 << 7,
	PINMUX_IO_RESET = 1 << 8,
	PINMUX_RCV_SEL = 1 << 9
};

/* GPIO index constants. */

#define GPIO_PORT_CONSTANTS(port) \
	GPIO_##port##0_INDEX, GPIO_##port##1_INDEX, GPIO_##port##2_INDEX, \
	GPIO_##port##3_INDEX, GPIO_##port##4_INDEX, GPIO_##port##5_INDEX, \
	GPIO_##port##6_INDEX, GPIO_##port##7_INDEX

enum {
	GPIO_PORT_CONSTANTS(A),
	GPIO_PORT_CONSTANTS(B),
	GPIO_PORT_CONSTANTS(C),
	GPIO_PORT_CONSTANTS(D),
	GPIO_PORT_CONSTANTS(E),
	GPIO_PORT_CONSTANTS(F),
	GPIO_PORT_CONSTANTS(G),
	GPIO_PORT_CONSTANTS(H),
	GPIO_PORT_CONSTANTS(I),
	GPIO_PORT_CONSTANTS(J),
	GPIO_PORT_CONSTANTS(K),
	GPIO_PORT_CONSTANTS(L),
	GPIO_PORT_CONSTANTS(M),
	GPIO_PORT_CONSTANTS(N),
	GPIO_PORT_CONSTANTS(O),
	GPIO_PORT_CONSTANTS(P),
	GPIO_PORT_CONSTANTS(Q),
	GPIO_PORT_CONSTANTS(R),
	GPIO_PORT_CONSTANTS(S),
	GPIO_PORT_CONSTANTS(T),
	GPIO_PORT_CONSTANTS(U),
	GPIO_PORT_CONSTANTS(V),
	GPIO_PORT_CONSTANTS(W),
	GPIO_PORT_CONSTANTS(X),
	GPIO_PORT_CONSTANTS(Y),
	GPIO_PORT_CONSTANTS(Z),
	GPIO_PORT_CONSTANTS(AA),
	GPIO_PORT_CONSTANTS(BB),
	GPIO_PORT_CONSTANTS(CC),
	GPIO_PORT_CONSTANTS(DD),
	GPIO_PORT_CONSTANTS(EE),
	GPIO_PORT_CONSTANTS(FF),
	GPIO_NONE_INDEX = 0,
};

#define PINMUX_CONSTANTS_GPIO(name, gpio) \
	PINMUX_GPIO_##gpio = PINMUX_##name##_INDEX

#define PINMUX_CONSTANTS(index, name, por_pu, gpio, has_gpio, \
				func0, func1, func2, func3) \
	PINMUX_##name##_INDEX = index, \
	PINMUX_##name##_FUNC_##func0 = 0, \
	PINMUX_##name##_FUNC_##func1 = 1, \
	PINMUX_##name##_FUNC_##func2 = 2, \
	PINMUX_##name##_FUNC_##func3 = 3, \
	PAD_TO_GPIO_##name = GPIO_##gpio##_INDEX, \
	PAD_HAS_GPIO_##name = has_gpio, \
	PAD_POR_PU_##name = por_pu

#define PAD_GPIO(index, name, por_pu, gpio, func0, func1, func2, func3) \
	PINMUX_CONSTANTS(index, name, por_pu, gpio, 1, \
				func0, func1, func2, func3), \
	PINMUX_CONSTANTS_GPIO(name, gpio)

#define PAD_NO_GPIO(index, name, por_pu, func0, func1, func2, func3) \
	PINMUX_CONSTANTS(index, name, por_pu, NONE, 0, \
				func0, func1, func2, func3)

enum {
	/* Power-on-reset pull states. */
	POR_PU = 1,
	POR_PD = 0,
	POR_NP = 0,

	PAD_GPIO(0, ULPI_DATA0, POR_PU, O1, SPI3, HSI, UA3, ULPI),
	PAD_GPIO(1, ULPI_DATA1, POR_PU, O2, SPI3, HSI, UA3, ULPI),
	PAD_GPIO(2, ULPI_DATA2, POR_PU, O3, SPI3, HSI, UA3, ULPI),
	PAD_GPIO(3, ULPI_DATA3, POR_PU, O4, SPI3, HSI, UA3, ULPI),
	PAD_GPIO(4, ULPI_DATA4, POR_PU, O5, SPI2, HSI, UA3, ULPI),
	PAD_GPIO(5, ULPI_DATA5, POR_PU, O6, SPI2, HSI, UA3, ULPI),
	PAD_GPIO(6, ULPI_DATA6, POR_PU, O7, SPI2, HSI, UA3, ULPI),
	PAD_GPIO(7, ULPI_DATA7, POR_PU, O0, SPI2, HSI, UA3, ULPI),
	PAD_GPIO(8, ULPI_CLK, POR_NP, Y0, SPI1, SPI5, UD3, ULPI),
	PAD_GPIO(9, ULPI_DIR, POR_NP, Y1, SPI1, SPI5, UD3, ULPI),
	PAD_GPIO(10, ULPI_NXT, POR_NP, Y2, SPI1, SPI5, UD3, ULPI),
	PAD_GPIO(11, ULPI_STP, POR_NP, Y3, SPI1, SPI5, UD3, ULPI),
	PAD_GPIO(12, DAP3_FS, POR_PD, P0, I2S2, SPI5, DCA, DCB),
	PAD_GPIO(13, DAP3_DIN, POR_PD, P1, I2S2, SPI5, DCA, DCB),
	PAD_GPIO(14, DAP3_DOUT, POR_PD, P2, I2S2, SPI5, DCA, RES3),
	PAD_GPIO(15, DAP3_SCLK, POR_PD, P3, I2S2, SPI5, RES2, DCB),
	PAD_GPIO(16, GPIO_PV0, POR_NP, V0, RES0, RES1, RES2, RES3),
	PAD_GPIO(17, GPIO_PV1, POR_NP, V1, RES0, RES1, RES2, RES3),
	PAD_GPIO(18, SDMMC1_CLK, POR_PD, Z0, SDMMC1, CLK12M, RES2, RES3),
	PAD_GPIO(19, SDMMC1_CMD, POR_PU, Z1, SDMMC1, SPDIF, SPI4, UA3),
	PAD_GPIO(20, SDMMC1_DAT3, POR_PU, Y4, SDMMC1, SPDIF, SPI4, UA3),
	PAD_GPIO(21, SDMMC1_DAT2, POR_PU, Y5, SDMMC1, PWM0, SPI4, UA3),
	PAD_GPIO(22, SDMMC1_DAT1, POR_PU, Y6, SDMMC1, PWM1, SPI4, UA3),
	PAD_GPIO(23, SDMMC1_DAT0, POR_PU, Y7, SDMMC1, RES1, SPI4, UA3),
	PAD_GPIO(26, CLK2_OUT, POR_PD, W5, EXTPERIPH2, RES1, RES2, RES3),
	PAD_GPIO(27, CLK2_REQ, POR_NP, CC5, DAP, RES1, RES2, RES3),
	PAD_GPIO(68, HDMI_INT, POR_PD, N7, RES0, RES1, RES2, RES3),
	PAD_GPIO(69, DDC_SCL, POR_NP, V4, I2C4, RES1, RES2, RES3),
	PAD_GPIO(70, DDC_SDA, POR_NP, V5, I2C4, RES1, RES2, RES3),
	PAD_GPIO(89, UART2_RXD, POR_PU, C3, IR3, SPDIF, UA3, SPI4),
	PAD_GPIO(90, UART2_TXD, POR_PU, C2, IR3, SPDIF, UA3, SPI4),
	PAD_GPIO(91, UART2_RTS_N, POR_PU, J6, UA3, UB3, NOR, SPI4),
	PAD_GPIO(92, UART2_CTS_N, POR_PU, J5, UA3, UB3, NOR, SPI4),
	PAD_GPIO(93, UART3_TXD, POR_PU, W6, UC3, RES1, NOR, SPI4),
	PAD_GPIO(94, UART3_RXD, POR_PU, W7, UC3, RES1, NOR, SPI4),
	PAD_GPIO(95, UART3_CTS_N, POR_PU, A1, UC3, SDMMC1, DTV, NOR),
	PAD_GPIO(96, UART3_RTS_N, POR_PU, C0, UC3, PWM0, DTV, NOR),
	PAD_GPIO(97, GPIO_PU0, POR_NP, U0, OWR, UA3, NOR, RES3),
	PAD_GPIO(98, GPIO_PU1, POR_NP, U1, RES0, UA3, NOR, RES3),
	PAD_GPIO(99, GPIO_PU2, POR_NP, U2, RES0, UA3, NOR, RES3),
	PAD_GPIO(100, GPIO_PU3, POR_NP, U3, PWM0, UA3, NOR, DCB),
	PAD_GPIO(101, GPIO_PU4, POR_NP, U4, PWM1, UA3, NOR, DCB),
	PAD_GPIO(102, GPIO_PU5, POR_NP, U5, PWM2, UA3, NOR, DCB),
	PAD_GPIO(103, GPIO_PU6, POR_NP, U6, PWM3, UA3, RES2, NOR),
	PAD_GPIO(104, GEN1_I2C_SDA, POR_NP, C5, I2C1, RES1, RES2, RES3),
	PAD_GPIO(105, GEN1_I2C_SCL, POR_NP, C4, I2C1, RES1, RES2, RES3),
	PAD_GPIO(106, DAP4_FS, POR_PD, P4, I2S3, NOR, DTV, RES3),
	PAD_GPIO(107, DAP4_DIN, POR_PD, P5, I2S3, NOR, RES2, RES3),
	PAD_GPIO(108, DAP4_DOUT, POR_PD, P6, I2S3, NOR, DTV, RES3),
	PAD_GPIO(109, DAP4_SCLK, POR_PD, P7, I2S3, NOR, RES2, RES3),
	PAD_GPIO(110, CLK3_OUT, POR_NP, EE0, EXTPERIPH3, RES1, RES2, RES3),
	PAD_GPIO(111, CLK3_REQ, POR_NP, EE1, DEV3, RES1, RES2, RES3),
	PAD_GPIO(112, GPIO_PC7, POR_PU, C7, RES0, RES1, NOR_WP_N, NOR_INT1),
	PAD_GPIO(113, GPIO_PI5, POR_PU, I5, SDMMC2, RES1, NOR, RES3),
	PAD_GPIO(114, GPIO_PI7, POR_PU, I7, RES0, TRACE, NOR, DTV),
	PAD_GPIO(115, GPIO_PK0, POR_PU, K0, RES0, SDMMC3, NOR, SOC_THERM),
	PAD_GPIO(116, GPIO_PK1, POR_PD, K1, SDMMC2, TRACE, NOR, RES3),
	PAD_GPIO(117, GPIO_PJ0, POR_PU, J0, RES0, RES1, NOR, USB),
	PAD_GPIO(118, GPIO_PJ2, POR_PU, J2, RES0, RES1, NOR, SOC_THERM),
	PAD_GPIO(119, GPIO_PK3, POR_PU, K3, SDMMC2, TRACE, NOR, CCLA),
	PAD_GPIO(120, GPIO_PK4, POR_PU, K4, SDMMC2, RES1, NOR_AD22, NOR_INT1),
	PAD_GPIO(121, GPIO_PK2, POR_PU, K2, RES0, RES1, NOR, RES3),
	PAD_GPIO(122, GPIO_PI3, POR_PU, I3, RES0, RES1, NOR, SPI4),
	PAD_GPIO(123, GPIO_PI6, POR_PU, I6, RES0, RES1, NOR, SDMMC2),
	PAD_GPIO(124, GPIO_PG0, POR_NP, G0, RES0, RES1, NOR, RES3),
	PAD_GPIO(125, GPIO_PG1, POR_NP, G1, RES0, RES1, NOR, RES3),
	PAD_GPIO(126, GPIO_PG2, POR_NP, G2, RES0, TRACE, NOR, RES3),
	PAD_GPIO(127, GPIO_PG3, POR_NP, G3, RES0, TRACE, NOR, RES3),
	PAD_GPIO(128, GPIO_PG4, POR_NP, G4, RES0, TMDS, NOR, SPI4),
	PAD_GPIO(129, GPIO_PG5, POR_NP, G5, RES0, RES1, NOR, SPI4),
	PAD_GPIO(130, GPIO_PG6, POR_NP, G6, RES0, RES1, NOR, SPI4),
	PAD_GPIO(131, GPIO_PG7, POR_NP, G7, RES0, RES1, NOR, SPI4),
	PAD_GPIO(132, GPIO_PH0, POR_PD, H0, PWM0, TRACE, NOR, DTV),
	PAD_GPIO(133, GPIO_PH1, POR_PD, H1, PWM1, TMDS, NOR, DCA),
	PAD_GPIO(134, GPIO_PH2, POR_PD, H2, PWM2, TDMS, NOR, CLDVFS),
	PAD_GPIO(135, GPIO_PH3, POR_PD, H3, PWM3, SPI4, NOR, CLDVFS),
	PAD_GPIO(136, GPIO_PH4, POR_PU, H4, SDMMC2, RES1, NOR, RES3),
	PAD_GPIO(137, GPIO_PH5, POR_PD, H5, SDMMC2, RES1, NOR, RES3),
	PAD_GPIO(138, GPIO_PH6, POR_PU, H6, SDMMC2, TRACE, NOR, DTV),
	PAD_GPIO(139, GPIO_PH7, POR_PU, H7, SDMMC2, TRACE, NOR, DTV),
	PAD_GPIO(140, GPIO_PJ7, POR_NP, J7, UD3, RES1, NOR_AD16, NOR_INT2),
	PAD_GPIO(141, GPIO_PB0, POR_NP, B0, UD3, RES1, NOR, RES3),
	PAD_GPIO(142, GPIO_PB1, POR_NP, B1, UD3, RES1, NOR, RES3),
	PAD_GPIO(143, GPIO_PK7, POR_NP, K7, UD3, RES1, NOR, RES3),
	PAD_GPIO(144, GPIO_PI0, POR_PU, I0, RES0, RES1, NOR, RES3),
	PAD_GPIO(145, GPIO_PI1, POR_PU, I1, RES0, RES1, NOR, RES3),
	PAD_GPIO(146, GPIO_PI2, POR_PU, I2, SDMMC2, TRACE, NOR, RES3),
	PAD_GPIO(147, GPIO_PI4, POR_PD, I4, SPI4, TRACE, NOR, DCA),
	PAD_GPIO(148, GEN2_I2C_SCL, POR_NP, T5, I2C2, RES1, NOR, RES3),
	PAD_GPIO(149, GEN2_I2C_SDA, POR_NP, T6, I2C2, RES1, NOR, RES3),
	PAD_GPIO(150, SDMMC4_CLK, POR_PD, CC4, SDMMC4, RES1, NOR, RES3),
	PAD_GPIO(151, SDMMC4_CMD, POR_PU, T7, SDMMC4, RES1, NOR, RES3),
	PAD_GPIO(152, SDMMC4_DAT0, POR_PU, AA0, SDMMC4, SPI3, NOR, RES3),
	PAD_GPIO(153, SDMMC4_DAT1, POR_PU, AA1, SDMMC4, SPI3, NOR, RES3),
	PAD_GPIO(154, SDMMC4_DAT2, POR_PU, AA2, SDMMC4, SPI3, NOR, RES3),
	PAD_GPIO(155, SDMMC4_DAT3, POR_PU, AA3, SDMMC4, SPI3, NOR, RES3),
	PAD_GPIO(156, SDMMC4_DAT4, POR_PU, AA4, SDMMC4, SPI3, NOR, RES3),
	PAD_GPIO(157, SDMMC4_DAT5, POR_PU, AA5, SDMMC4, SPI3, RES2, RES3),
	PAD_GPIO(158, SDMMC4_DAT6, POR_PU, AA6, SDMMC4, SPI3, NOR, RES3),
	PAD_GPIO(159, SDMMC4_DAT7, POR_PU, AA7, SDMMC4, RES1, NOR, RES3),
	PAD_GPIO(161, CAM_MCLK, POR_PU, CC0, VIMCLK_PRI, VIMCLK_ALT1,
			 VIMCLK_ALT3, SDMMC2),
	PAD_GPIO(162, GPIO_PCC1, POR_PU, CC1, I2S4, RES1, RES2, SDMMC2),
	PAD_GPIO(163, GPIO_PBB0, POR_PD, BB0, VGP6, VIMCLK2_PRI, SDMMC2, VIMCLK2_ALT3),
	PAD_GPIO(164, CAM_I2C_SCL, POR_NP, BB1, VGP1, I2C3, RES2, SDMMC2),
	PAD_GPIO(165, CAM_I2C_SDA, POR_NP, BB2, VGP2, I2C3, RES2, SDMMC2),
	PAD_GPIO(166, GPIO_PBB3, POR_PD, BB3, VGP3, DCA, DCB, SDMMC2),
	PAD_GPIO(167, GPIO_PBB4, POR_PD, BB4, VGP4, DCA, DCB, SDMMC2),
	PAD_GPIO(168, GPIO_PBB5, POR_PD, BB5, VGP5, DCA, RES2, SDMMC2),
	PAD_GPIO(169, GPIO_PBB6, POR_PD, BB6, I2S4, RES1, DCB, SDMMC2),
	PAD_GPIO(170, GPIO_PBB7, POR_PD, BB7, I2S4, RES1, RES2, SDMMC2),
	PAD_GPIO(171, GPIO_PCC2, POR_PU, CC2, I2S4, RES1, SDMMC3, SDMMC2),
	PAD_NO_GPIO(172, JTAG_RTCK, POR_PU, RTCK, RES1, RES2, RES3),
	PAD_GPIO(173, PWR_I2C_SCL, POR_NP, Z6, I2CPMU, RES1, RES2, RES3),
	PAD_GPIO(174, PWR_I2C_SDA, POR_NP, Z7, I2CPMU, RES1, RES2, RES3),
	PAD_GPIO(175, KB_ROW0, POR_PD, R0, RES0, RES1, RES2, RES3),
	PAD_GPIO(176, KB_ROW1, POR_PD, R1, RES0, RES1, RES2, RES3),
	PAD_GPIO(177, KB_ROW2, POR_PD, R2, RES0, RES1, RES2, RES3),
	PAD_GPIO(178, KB_ROW3, POR_NP, R3, RES0, DCA, SYS_CLK, DCB),
	PAD_GPIO(179, KB_ROW4, POR_PD, R4, RES0, DCA, RES2, DCB),
	PAD_GPIO(180, KB_ROW5, POR_PD, R5, RES0, DCA, RES2, DCB),
	PAD_GPIO(181, KB_ROW6, POR_PD, R6, RES0, DCA_LSC0, DCA_LSPII, DCB),
	PAD_GPIO(182, KB_ROW7, POR_PD, R7, RES0, RES1, CLDVFS, UA3),
	PAD_GPIO(183, KB_ROW8, POR_PD, S0, RES0, RES1, CLDVFS, UA3),
	PAD_GPIO(184, KB_ROW9, POR_PD, S1, RES0, RES1, RES2, UA3),
	PAD_GPIO(185, KB_ROW10, POR_PD, S2, RES0, RES1, RES2, UA3),
	PAD_GPIO(186, KB_ROW11, POR_PD, S3, RES0, RES1, RES2, IR3),
	PAD_GPIO(187, KB_ROW12, POR_PD, S4, RES0, RES1, RES2, IR3),
	PAD_GPIO(188, KB_ROW13, POR_PD, S5, RES0, RES1, SPI2, RES3),
	PAD_GPIO(189, KB_ROW14, POR_PD, S6, RES0, RES1, SPI2, RES3),
	PAD_GPIO(190, KB_ROW15, POR_PD, S7, RES0, SOC_THERM, RES2, RES3),
	PAD_GPIO(191, KB_COL0, POR_PU, Q0, RES0, RES1, SPI2, RES3),
	PAD_GPIO(192, KB_COL1, POR_PU, Q1, RES0, RES1, SPI2, RES3),
	PAD_GPIO(193, KB_COL2, POR_PU, Q2, RES0, RES1, SPI2, RES3),
	PAD_GPIO(194, KB_COL3, POR_PU, Q3, RES0, DCA, PWM2, UA3),
	PAD_GPIO(195, KB_COL4, POR_PU, Q4, RES0, OWR, SDMMC3, UA3),
	PAD_GPIO(196, KB_COL5, POR_PU, Q5, RES0, RES1, SDMMC3, RES3),
	PAD_GPIO(197, KB_COL6, POR_PU, Q6, RES0, RES1, SPI2, UD3),
	PAD_GPIO(198, KB_COL7, POR_PU, Q7, RES0, RES1, SPI2, UD3),
	PAD_GPIO(199, CLK_32K_OUT, POR_PD, A0, BLINK, SOC_THERM, RES2, RES3),
	PAD_NO_GPIO(201, CORE_PWR_REQ, POR_NP, PWRON, RES1, RES2, RES3),
	PAD_NO_GPIO(202, CPU_PWR_REQ, POR_NP, CPU, RES1, RES2, RES3),
	PAD_NO_GPIO(203, PWR_INT_N, POR_NP, PMICINTR, RES1, RES2, RES3),
	PAD_NO_GPIO(204, CLK_32K_IN, POR_NP, CLK_32K_IN, RES1, RES2, RES3),
	PAD_NO_GPIO(205, OWR, POR_NP, OWR, RES1, RES2, RES3),
	PAD_GPIO(206, DAP1_FS, POR_PD, N0, I2S0, DAP1, NOR, RES3),
	PAD_GPIO(207, DAP1_DIN, POR_PD, N1, I2S0, DAP1, NOR, RES3),
	PAD_GPIO(208, DAP1_DOUT, POR_PD, N2, I2S0, DAP1, NOR, SATA),
	PAD_GPIO(209, DAP1_SCLK, POR_PD, N3, I2S0, DAP1, NOR, RES3),
	PAD_GPIO(210, DAP_MCLK1_REQ, POR_PD, EE2, DAP, DAP1, SATA, RES3),
	PAD_GPIO(211, DAP_MCLK1, POR_PD, W4, EXTPERIPH1, DAP2, RES2, RES3),
	PAD_GPIO(212, SPDIF_IN, POR_PU, K6, SPDIF, RES1, RES2, I2C3),
	PAD_GPIO(213, SPDIF_OUT, POR_PU, K5, SPDIF, RES1, RES2, I2C3),
	PAD_GPIO(214, DAP2_FS, POR_PD, A2, I2S1, DAP2, NOR, RES3),
	PAD_GPIO(215, DAP2_DIN, POR_PD, A4, I2S1, DAP2, NOR, RES3),
	PAD_GPIO(216, DAP2_DOUT, POR_PD, A5, I2S1, DAP2, NOR, RES3),
	PAD_GPIO(217, DAP2_SCLK, POR_PD, A3, I2S1, SAP2, NOR, RES3),
	PAD_GPIO(218, DVFS_PWM, POR_PD, X0, SPI6, CLDVFS, NOR, RES3),
	PAD_GPIO(219, GPIO_X1_AUD, POR_PD, X1, SPI6, RES1, NOR, RES3),
	PAD_GPIO(220, GPIO_X3_AUD, POR_PU, X3, SPI6, SPI1, NOR, RES3),
	PAD_GPIO(221, DVFS_CLK, POR_PU, X2, SPI6, CLDVFS_CLK, NOR, RES3),
	PAD_GPIO(222, GPIO_X4_AUD, POR_PD, X4, NOR, SPI1, SPI2, DAP2),
	PAD_GPIO(223, GPIO_X5_AUD, POR_PU, X5, NOR, SPI1, SPI2, RES3),
	PAD_GPIO(224, GPIO_X6_AUD, POR_PU, X6, SPI6, SPI1, SPI2, NOR),
	PAD_GPIO(225, GPIO_X7_AUD, POR_PD, X7, RES0, SPI1, SPI2, RES3),
	PAD_GPIO(228, SDMMC3_CLK, POR_PD, A6, SDMMC3, RES1, RES2, SPI3),
	PAD_GPIO(229, SDMMC3_CMD, POR_PU, A7, SDMMC3, PWM3, UA3, SPI3),
	PAD_GPIO(230, SDMMC3_DAT0, POR_PU, B7, SDMMC3, RES1, RES2, SPI3),
	PAD_GPIO(231, SDMMC3_DAT1, POR_PU, B6, SDMMC3, PWM2, UA3, SPI3),
	PAD_GPIO(232, SDMMC3_DAT2, POR_PU, B5, SDMMC3, PWM1, DCA, SPI3),
	PAD_GPIO(233, SDMMC3_DAT3, POR_PU, B4, SDMMC3, PWM0, DCB, SPI3),
	PAD_GPIO(239, PEX_L0_RST_N, POR_NP, DD1, PE0, RES1, RES2, RES3),
	PAD_GPIO(240, PEX_L0_CLKREQ_N, POR_NP, DD2, PE0, RES1, RES2, RES3),
	PAD_GPIO(241, PEX_WAKE_N, POR_NP, DD3, PE, RES1, RES2, RES3),
	PAD_GPIO(243, PEX_L1_RST_N, POR_NP, DD5, PE1, RES1, RES2, RES3),
	PAD_GPIO(244, PEX_L1_CLKREQ_N, POR_NP, DD6, PE1, RES1, RES2, RES3),
	PAD_GPIO(248, HDMI_CEC, POR_NP, EE3, CEC, RES1, RES2, RES3),
	PAD_GPIO(249, SDMMC1_WP_N, POR_PU, V3, SDMMC1, CLK12M, SPI4, UA3),
	PAD_GPIO(250, SDMMC3_CD_N, POR_PU, V2, SDMMC3, OWR, RES2, RES3),
	PAD_GPIO(251, GPIO_W2_AUD, POR_PU, W2, SPI6, RES1, SPI2, I2C1),
	PAD_GPIO(252, GPIO_W3_AUD, POR_PU, W3, SPI6, SPI1, SPI2, I2C1),
	PAD_GPIO(253, USB_VBUS_EN0, POR_NP, N4, USB, RES1, RES2, RES3),
	PAD_GPIO(254, USB_VBUS_EN1, POR_NP, N5, USB, RES1, RES2, RES3),
	PAD_GPIO(255, SDMMC3_CLK_LB_IN, POR_PD, EE5, SDMMC3, RES1, RES2, RES3),
	PAD_GPIO(256, SDMMC3_CLK_LB_OUT, POR_NP, EE4, SDMMC3, RES1, RES2, RES3),
	PAD_NO_GPIO(258, RESET_OUT_N, POR_NP, RES0, RES1, RES2, RESET),
	PAD_GPIO(259, KB_ROW16, POR_PD, T0, RES0, RES1, RES2, UC3),
	PAD_GPIO(260, KB_ROW17, POR_PD, T1, RES0, RES1, RES2, UC3),
	PAD_GPIO(261, USB_VBUS_EN2, POR_NP, FF1, USB, RES1, RES2, RES3),
	PAD_GPIO(262, GPIO_PFF2, POR_NP, FF2, SATA, RES1, RES2, RES3),
	PAD_GPIO(268, DP_HPD, POR_NP, FF0, DP, RES1, RES2, RES3),
};

#endif	/* __SOC_NVIDIA_TEGRA132_PINMUX_H__ */
