/*
 * This file is part of the coreboot project.
 *
 * Copyright 2015 Google Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/* This file assembles the bootblock program by the order of the includes. Thus,
 * it's extremely important that one pays very careful attention to the order
 * of the includes. */

#include <arch/x86/prologue.inc>
#include <cpu/x86/16bit/entry16.inc>
#include <cpu/x86/16bit/reset16.inc>
#include <cpu/x86/32bit/entry32.inc>

#ifdef CONFIG_CHIPSET_BOOTBLOCK_INCLUDE
#include CONFIG_CHIPSET_BOOTBLOCK_INCLUDE
#endif

#if IS_ENABLED(CONFIG_SSE)
#include <cpu/x86/sse_enable.inc>
#endif

/*
 * This bootblock.inc file is generated by ROMCC. The above program flow
 * falls through to this point. ROMCC assumes the last function it parsed
 * is the main function and it places its instructions at the beginning of
 * the generated file. Moreover, any library/common code needed in bootblock
 * needs to come after bootblock.inc.
 */
#include <generated/bootblock.inc>
