---
title: ThinkPad X200 
x-toc-enable: true
...

<div class="specs">
<center>
<img tabindex=1 alt="ThinkPad X200" class="p" src="https://av.canoeboot.org/x200/disassembly/0019.jpg" /><span class="f"><img src="https://av.canoeboot.org/x200/disassembly/0019.jpg" /></span>
</center>

| ***Характеристики***       |                                                |
|----------------------------|------------------------------------------------|
| **Виробник**               | Lenovo                                         |
| **Назва**                  | ThinkPad X200/X200S/X200 Tablet                |
| **Випущено**               | Липень/Вересень 2009 року                      |
| **Чіпсет**                 | Intel Cantiga GM45                             |
| **ЦП**                     | Intel Core 2 Duo (сімейство Penryn)            |
| **Графіка**                | Intel GMA X4500MHD                             |
| **Дісплей**                | 1280x800/1440x900 TFT                          |
| **Пам'ять**                | 1,2,3 or 4GB (оновлюється до 8GB, неофіційно)  |
| **Архітектура**            | x86_64                                         |
| **EC**                     | Пропрієтарний                                  |
| **Оригінальна прошивка**   | LenovoBIOS                                     |
| **Intel ME/AMD PSP**       | Наявний. Можна повністю вимкнути.              |
| **Флеш-чіп**               | SOIC-8/SOIC-16/WSON-8 4MiB/8MiB (Оновлюється 
                                                                    до 16MБ)  |
```
W+: Працює без бінарних компонентів; 
N: Не працює; 
U: Не перевірялось; 
P+: Частково працює; 
```

| ***Функції***  |                                       |
|----------------|---------------------------------------|
| **Внутрішня прошивка з оригінальною прошивкою**   | N  |
| **Дісплей**                                       | W+ |
| **Аудіо**                                         | W+ |
| **Ініціалізація ПДД**                             | W+ |
| **Зовнішній вивід**                               | W+ |
| **Яскравість дісплею**                            | P+ |

| ***Корисні навантаження***  |           |
|-----------------------------|-----------|
| **GRUB**                | Працює    |
| **SeaBIOS**                 | Працює    |
| **SeaBIOS з GRUB**      | Працює    |
</div>

Вступ
============

Вважається що всі ноутбуки X200 сумісні. X200S та X200
Tablet також працюватимуть, [залежно від конфігурації](#x200s).

Можливо, можна розмістити материнську плату X200 у шасі X201, хоча це
наразі не перевірено проектом Canoeboot. Те ж саме може стосуватися
X200S та X201S; знову ж таки, це неперевірено. *Швидше за все, це правда.*

Є два можливих розміра флеш-чіпа для X200: 4MБ (32 Мбіт) або
8МБ (64 Мбіт). Це можна визначити за типом флеш-чіпа під
упором для рук: 4МБ це SOIC-8, 8МБ це SOIC-16.

*Ноутбуки X200 постачаються з ME (та іноді AMT додатково)
перед перепрошивкою Canoeboot. Canoeboot вимикає та видаляє його за допомогою
модифікованого дескриптора: дивіться [../install/ich9utils.md](../install/ich9utils.md)*
(містить примітки та інструкції)

Інструкції з перепрошивки можна знайти за адресою
[../install/\#flashprog](../install/#flashprog)

NOTE: Libreboot standardises on [flashprog](https://flashprog.org/wiki/Flashprog)
now, as of 3 May 2024, which is a fork of flashrom.

Оновлення EC {#ecupdate}
=========

Рекомендується оновити мікропрограму EC до останньої версії.
[Прошивка EC](../../faq.md#ec-embedded-controller-firmware) є окремою від
Canoeboot, тому ми її фактично не надаємо, але якщо у вас все ще є
Lenovo BIOS, ви можете просто запустити утиліту оновлення BIOS Lenovo, яка
оновить як BIOS, так і версію EC. Дивіться:

-   [../install/#flashprog](../install/#flashprog)
-   <http://www.thinkwiki.org/wiki/BIOS_update_without_optical_disk>
-   [Оновлення BIOS X200, X200s, X200i](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-laptops/thinkpad-x200/downloads/ds015007)
-   [Оновлення BIOS X200t](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-tablet-laptops/thinkpad-x200-tablet/downloads/ds018814)

ПРИМІТКА: це можна зробити, лише якщо ви використовуєте Lenovo BIOS. Як
оновити мікропрограму EC, користуючись Canoeboot, невідомо. Canoeboot
тільки замінює прошивку BIOS, не EC.

Оновлена мікропрограма EC має декілька переваг, напр. краще поводження
з акумулятором.

Відкликання батареї {#batteryrecall}
==============

[21 квітня 2015 року, Lenovo розширила відкликання акумуляторів Lenovo, які були встановлені в деяких моделях Thinkpad, зокрема X200 та X200S.](https://pcsupport.lenovo.com/cr/en/solutions/hf004122) 
Щоб дізнатися, чи вас це стосується, використовуйте [цей інструмент Lenovo.](https://lenovobattery2014.orderz.com/) 
Lenovo радить власникам відкликаних моделей "вимкнути систему, вийняти батарею, 
та живити ThinkPad лише шляхом підключення адаптера змінного струму та шнура живлення." 
Після перевірки батареї, Lenovo безкоштовно замінить відкликані батареї. 
Інструкції щодо заміни батареї для X200/X200s [можна знайти на цій сторінці.](https://pcsupport.lenovo.com/cr/en/parts/pd003507/)

Список сумісності LCD {#lcd_supported_list}
----------------------

Список РК-панелей (там перераховані панелі X200):
<http://www.thinkwiki.org/wiki/TFT_display>

Відомо, що всі РК-панелі для X200, X200S та X200 Tablet працюють.

### AFFS/IPS панелі {#ips}

#### X200

Адаптовано з
<https://github.com/bibanon/Coreboot-ThinkPads/wiki/ThinkPad-X200>

Подивіться у Вікіпедії різницю між панелями TN та IPS. IPS мають
набагато кращий колір/контраст, ніж звичайний TN, і зазвичай мають
хороші кути огляду.

Це, здається, з X200 tablet. Вам потрібно знайти таку
без скляного захисту сенсорного екрана (проте її можна зняти).
На ньому також не повинно бути дигітайзера (знову ж таки, можна
просто видалити дигітайзер).

-   BOE-Hydis HV121WX4-120, HV121WX4-110 або HV121WX4-100 - дешево,
    може бути тяжко знайти

-   Samsung LTN121AP02-001 - звичайно знайти, недорого

*Якщо ваш X200 має панель зі світлодіодним підсвічуванням, вам також потрібно придбати
інвертор і кабель, сумісний з панелями CCFL.
Щоб дізнатися, який у вас тип панелі, перегляньте
[\#led\_howtotell](#led_howtotell). Якщо вам потрібен інвертор/кабель, ось
номери деталей: 44C9909 для кабелю CCFL LVDS із підключенням bluetooth і камери,
та 42W8009 або 42W8010 для інвертора.*

Існують глянцеві та матові варіанти. Матовий означає антивідблиск,,
чого ви і хочете (на думку авторів).

Зверніться до HMM (посібник з обслуговування обладнання), щоб дізнатися, як
замінити екран.

Джерела:

-   [Форуми ThinkPad - матова панель AFFS на
    X200](http://forum.thinkpads.com/viewtopic.php?f=2&t=84941)
-   [Форуми ThinkPad - Частини для мода X200 AFFS
    Mod](http://forum.thinkpads.com/viewtopic.php?p=660662#p660662)
-   [ThinkWiki.de - X200 Displayumbau](http://thinkwiki.de/X200_Displayumbau)

### X200S

<http://forum.thinkpads.com/viewtopic.php?p=618928#p618928> пояснює, що
екрани/блоки X200S тонші. Вам потрібно замінити всю кришку на одну від
звичайного X200/X201.

Як визначити, чи у нього LED, чи CCFL? {#led_howtotell}
-------------------------------------

Деякі X200 мають підсвічування CCFL, а деякі - світлодіодне підсвічування на РК-панелі.
Це також означає, що інвертори відрізнятимуться, тому ви повинні бути обережними,
коли замінюєте панель та/або інвертор. (інвертор CCFL має
високу напругу і зруйнює світлодіодну панель із підсвічуванням).

CCFL містять меркурій. На X200 з CCFL підсвіткою (якщо його не було замінено на світлодіодне з правильним
інвертором. Зверніться до свого постачальника!) буде написано
наступне: *"Цей продукт містить літій-іонну батарею, літієву батарею та лампу,
яка містить ртуть; утилізуйте відповідно до місцевих, державних або федеральних
законів"* (на тому, що має світлодіодне підсвічування, буде написано щось інше).

Дампи апаратного регістру {#regdumps}
-----------------------

Вікі coreboot
[показує](http://www.coreboot.org/Motherboard_Porting_Guide) як
збирати різноманітні логи, корисні для портування на нові плати. Нижче наведено
вихідні дані X200:

-   BIOS 3.15, EC 1.06
    -   [hwdumps/x200/](hwdumps/x200/)

