Canoeboot
=========

Find canoeboot documentation at <https://canoeboot.org/>

The `canoeboot` project provides
[libre](https://writefreesoftware.org/) *boot
firmware* that initializes the hardware (e.g. memory controller, CPU,
peripherals) on specific Intel/AMD x86 and ARM targets, which
then starts a bootloader for your operating system. Linux/BSD are
well-supported. It replaces proprietary BIOS/UEFI firmware. Help is available
via [\#canoeboot IRC](https://web.libera.chat/#canoeboot)
on [Libera](https://libera.chat/) IRC.

Canoeboot is maintained in parallel with Libreboot, by the same developer.
You are strongly advised to use *Libreboot*, but a certain minority may
prefer Canoeboot, which is essentially a *censored* Libreboot (no binary
blobs allowed, so only few boards supported whereas Libreboot supports more
boards while minimising the number of blobs to zero when possible).

For more context, please read Libreboot's Binary Blob Reduction Policy:

<https://libreboot.org/news/policy.html>

You may also read Canoeboot's about page, which contains more history pertaining
to *Canoeboot*. Please read this page:

<https://canoeboot.org/about.html>

Canoeboot is inferior to Libreboot, in every way, and you should never use it.

Project goals
=============

-   Be Libreboot, but adhere to GNU FSDG as policy. This means that many boards
    from Libreboot must be removed; Canoeboot is therefore inferior to Libreboot,
    and always will be. It provides a useful proof of concept, showing what
    is still possible when you completely bastardise Libreboot in like with
    FSF/GNU dogma - and Canoeboot does it better than GNU ever could.
-   *Support as much hardware as possible!* (within the restrictions imposed
    by GNU FSDG policy)
-   *Make coreboot easy to use*. Coreboot is notoriously difficult
    to install, due to an overall lack of user-focused documentation
    and support. Most people will simply give up before attempting to
    install coreboot. Canoeboot's automated build system and user-friendly
    installation instructions solves this problem.

Canoeboot attempts to bridge this divide by providing a build system
automating much of the coreboot image creation and customization.
Secondly, the project produces documentation aimed at non-technical users.
Thirdly, the project attempts to provide excellent user support via IRC.

Canoeboot already comes with a payload (GRUB), flashprog and other
needed parts. Everything is fully integrated, in a way where most of
the complicated steps that are otherwise required, are instead done
for the user in advance.

You can download ROM images for your canoeboot system and install
them without having to build anything from source. If, however, you are
interested in building your own image, the build system makes it relatively
easy to do so.

Not a coreboot fork!
--------------------

Canoeboot is not a fork of coreboot. Every so often, the project
re-bases on the latest version of coreboot, with the number of custom
patches in use minimized. Tested, *stable* (static) releases are then provided
in Canoeboot, based on specific coreboot revisions.

LICENSE FOR THIS README
=======================

It's just a README file. This README file is released under the terms of the
Creative Commons Zero license, version 1.0 of the license, which you can
read here:

<https://creativecommons.org/publicdomain/zero/1.0/legalcode.txt>

The documentation in Canoeboot will use a mix of other licenses, so you should
check that for more information.
