/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef SUPERIO_NUVOTON_NCT5535D_H
#define SUPERIO_NUVOTON_NCT5535D_H

#include "../nct6779d/nct6779d.h"

/* All aliases to NCT6779D numbers. */
#define NCT5535D_SP1		NCT6779D_SP1
#define NCT5535D_KBC		NCT6779D_KBC
#define NCT5535D_GPIO78_V	NCT6779D_GPIO678_V
#define NCT5535D_WDT1_V		NCT6779D_WDT1_GPIO01_V
#define NCT5535D_GPIO_V		NCT6779D_GPIO12345678_V
#define NCT5535D_ACPI		NCT6779D_ACPI
#define NCT5535D_HWM_FPLED	NCT6779D_HWM_FPLED
#define NCT5535D_WDT1_MASK	NCT6779D_WDT1
#define NCT5535D_GPIO_PP_OD	NCT6779D_GPIO_PP_OD
#define NCT5535D_PRT80		NCT6779D_PRT80
#define NCT5535D_DSLP		NCT6779D_DSLP

#ifndef __ACPI__
#define NCT5535D_GPIOBASE	((3 << 8) | NCT5535D_WDT1_V)
#define NCT5535D_WDT1		NCT5535D_WDT1_V
#define NCT5535D_GPIO2		((2 << 8) | NCT5535D_GPIO_V)
#define NCT5535D_GPIO3		((3 << 8) | NCT5535D_GPIO_V)
#define NCT5535D_GPIO4		((4 << 8) | NCT5535D_GPIO_V)
#define NCT5535D_GPIO5		((5 << 8) | NCT5535D_GPIO_V)
#define NCT5535D_GPIO7		((7 << 8) | NCT5535D_GPIO_V)
#define NCT5535D_GPIO8		((0 << 8) | NCT5535D_GPIO_V)
#endif

#endif /* SUPERIO_NUVOTON_NCT5535D_H */
