/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_QUALCOMM_X1P42100_PMIC_H__
#define _SOC_QUALCOMM_X1P42100_PMIC_H__

#include <types.h>

#define PMIC_SLAVE_ID				0x00
#define SDAM05_BASE_ADDR			0x7400
#define MEM_OFFSET_START			0x40
#define PON_EVENT_LOG_AREA_SIZE			(127 - 11 + 1)
#define PON_EVENT_TOTAL_LOG_AREA_SIZE		(PON_EVENT_LOG_AREA_SIZE * 2)

#define PM_PON_SDAM_COUNT_ADDR			(SDAM05_BASE_ADDR + MEM_OFFSET_START + 5)
#define PM_PON_ENQUEUE_ADDR			(SDAM05_BASE_ADDR + MEM_OFFSET_START + 6)
#define PM_PON_ENQUEUE_SDAM_NUM			(SDAM05_BASE_ADDR + MEM_OFFSET_START + 7)
#define PM_PON_LOGGING_AREA_START		(SDAM05_BASE_ADDR + MEM_OFFSET_START + 11)
#define PM_PON_LOGGING_AREA_END			(SDAM05_BASE_ADDR + MEM_OFFSET_START + 127)
#define PM_PON_PUSH_PTR_INDEX(x)		(x - (MEM_OFFSET_START + 11))

#define PM_PON_EVENT_PON_TRIGGER		0x1
#define PM_PON_EVENT_RESET_TYPE			0x7
#define PM_PON_EVENT_FUNDAMENTAL_RESET		0xC
#define PM_PON_EVENT_RESET_TRIGGER		0x6
#define BEGIN_PON				0XD
#define PON_EVENT_PARSE_LIMIT			2

#define PON_KEYPD_PWR_N_S2_RSN			0x0080
#define PON_RESIN_N_S2_RSN			0x0081
#define PON_KPDPWR_AND_RESIN_RSN		0x0082
#define PON_PMIC_WD_RSN				0x0083
#define PON_PS_HOLD_RSN				0x0084
#define PON_SW_RST_RSN				0x0085
#define PON_RESIN_N_DEB_RSN			0x0086
#define PON_KEYPD_PWR_N_RSN			0x0087
#define PON_SMPL_RSN				0x0640
#define PON_PON1_RSN				0x18C1
#define PON_CBLPWR_RSN				0x18C0
#define PON_SYS_OK_RSN				0x71C2
#define PON_RTC_ALARM_RSN			0x0621

#define PON_RAW_XVDD_RB_MASK			0x8000
#define PON_RAW_DVDD_RB_MASK			0x4000
#define PON_S3_RESET_MASK			0xF0

#define PON_HARDRESET				0x7
#define PON_SHUTDOWN				0x4
#define PON_WARMRESET				0x1

int pm_pon_read_pon_hist(uint8_t *pon_hist_raw);
bool is_pon_on_ac(void);

#endif  // _SOC_QUALCOMM_X1P42100_PMIC_H__
