/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_MEDIATEK_MT8196_DSI_REG_H_
#define _SOC_MEDIATEK_MT8196_DSI_REG_H_

#include <commonlib/helpers.h>
#include <soc/addressmap.h>
#include <soc/dsi_register_v3.h>
#include <types.h>

/* MIPITX_REG */
struct mipi_tx_regs {
	u32 reserved0;
	u32 lane_con;
	u32 voltage_sel;
	u32 cdphy_preserved;
	u32 dphy_lane_con;
	u32 dphy_voltage_sel;
	u32 dphy_preserved;
	u32 test_con;
	u32 top_con;
	u32 ser_data;
	u32 pll_pwr;
	u32 pll_con0;
	u32 pll_con1;
	u32 pll_con2;
	u32 pll_con3;
	u32 pll_con4;
	u32 phy_sel0;
	u32 pa_con;
	u32 ser_data1;
	u32 ser_con;
	u32 sw_ctrl_con4;
	u32 gpio_con;
	u32 dbg_con;
	u32 err_sta;
	u32 in_mux_sel;
	u32 vidle_con;
	u32 vidle_trig;
	u32 vidle_timing_con0;
	u32 vidle_timing_con1;
	u32 vidle_dbg_sta0;
	u32 vidle_dbg_sta1;
	u32 vidle_cap_addr0;
	u32 vidle_cap_addr1;
	u32 vidle_cap_data0;
	u32 vidle_cap_data1;
	u32 vidle_cap_data2;
	u32 vidle_cap_data3;
	u32 reserved1[27];
	u32 d2p_rtcode3_0;
	u32 d2p_rtcode4;
	u32 d2n_rtcode3_0;
	u32 d2n_rtcode4;
	u32 d2p_skew_hi;
	u32 d2p_skew_lo;
	u32 d2n_skew_hi;
	u32 d2n_skew_lo;
	u32 d2_ckmode_en;
	u32 d2_ana_pn_swap_en;
	u32 d2_t0_tiel_en;
	u32 d2_ser_bisttog;
	u32 d2_ser_din_sel;
	u32 d2_ldoout_en;
	u32 d2_loopback_en;
	u32 d2_lptx_iplus1;
	u32 d2_lptx_iplus2;
	u32 d2_lptx_iminus;
	u32 d2_lpcd_iplus;
	u32 d2_lpcd_iminus;
	u32 d2_rtcode;
	u32 d2_cklane_en;
	u32 d2_dig_pn_swap_en;
	u32 d2_sw_ctl_en;
	u32 d2_sw_lptx_pre_oe;
	u32 d2_sw_lptx_oe;
	u32 d2_sw_lptx_dp;
	u32 d2_sw_lptx_dn;
	u32 d2_sw_lprx_en;
	u32 d2_sw_hstx_pre_oe;
	u32 d2_sw_hstx_oe;
	u32 d2_sw_hstx_rdy;
	u32 d2c_sw_lptx_pre_oe;
	u32 d2c_sw_lptx_oe;
	u32 d2c_sw_lprx_en;
	u32 d2c_sw_hstx_pre_oe;
	u32 d2c_sw_hstx_oe;
	u32 d2c_sw_hstx_rdy;
	u32 d2_sw_hstx_data1_0;
	u32 d2_sw_hstx_data3_2;
	u32 d2_sw_hstx_data5_4;
	u32 d2_sw_hstx_data7_6;
	u32 d2c_sw_hstx_data1_0;
	u32 d2c_sw_hstx_data3_2;
	u32 d2c_sw_hstx_data5_4;
	u32 d2c_sw_hstx_data6;
	u32 d2_sw_cd_con;
	u32 d2_ad_rx;
	u32 d2_ad_cd;
	u32 d2p_rt_dem_code;
	u32 d2n_rt_dem_code;
	u32 d2_hstx_ldo_iboost_en;
	u32 d2_dbg_sel;
	u32 d2_chksum0;
	u32 d2_chksum1;
	u32 d2_chksum2;
	u32 d2_chksum3;
	u32 d2_chksum4;
	u32 d2_chksum5;
	u32 d2_phy_rst_sel;
	u32 d2c_abc_swap_sel;
	u32 reserved2[3];
	u32 d0p_rtcode3_0;
	u32 d0p_rtcode4;
	u32 d0n_rtcode3_0;
	u32 d0n_rtcode4;
	u32 d0p_skew_hi;
	u32 d0p_skew_lo;
	u32 d0n_skew_hi;
	u32 d0n_skew_lo;
	u32 d0_ckmode_en;
	u32 d0_ana_pn_swap_en;
	u32 d0_t0_tiel_en;
	u32 d0_ser_bisttog;
	u32 d0_ser_din_sel;
	u32 d0_ldoout_en;
	u32 d0_loopback_en;
	u32 d0_lptx_iplus1;
	u32 d0_lptx_iplus2;
	u32 d0_lptx_iminus;
	u32 d0_lpcd_iplus;
	u32 d0_lpcd_iminus;
	u32 d0_rtcode;
	u32 d0_cklane_en;
	u32 d0_dig_pn_swap_en;
	u32 d0_sw_ctl_en;
	u32 d0_sw_lptx_pre_oe;
	u32 d0_sw_lptx_oe;
	u32 d0_sw_lptx_dp;
	u32 d0_sw_lptx_dn;
	u32 d0_sw_lprx_en;
	u32 d0_sw_hstx_pre_oe;
	u32 d0_sw_hstx_oe;
	u32 d0_sw_hstx_rdy;
	u32 d0c_sw_lptx_pre_oe;
	u32 d0c_sw_lptx_oe;
	u32 d0c_sw_lprx_en;
	u32 d0c_sw_hstx_pre_oe;
	u32 d0c_sw_hstx_oe;
	u32 d0c_sw_hstx_rdy;
	u32 d0_sw_hstx_data1_0;
	u32 d0_sw_hstx_data3_2;
	u32 d0_sw_hstx_data5_4;
	u32 d0_sw_hstx_data7_6;
	u32 d0c_sw_hstx_data1_0;
	u32 d0c_sw_hstx_data3_2;
	u32 d0c_sw_hstx_data5_4;
	u32 d0c_sw_hstx_data6;
	u32 d0_sw_cd_con;
	u32 d0_ad_rx;
	u32 d0_ad_cd;
	u32 d0p_rt_dem_code;
	u32 d0n_rt_dem_code;
	u32 d0_hstx_ldo_iboost_en;
	u32 d0_dbg_sel;
	u32 d0_chksum0;
	u32 d0_chksum1;
	u32 d0_chksum2;
	u32 d0_chksum3;
	u32 d0_chksum4;
	u32 d0_chksum5;
	u32 d0_phy_rst_sel;
	u32 d0c_abc_swap_sel;
	u32 reserved3[3];
	u32 ckp_rtcode3_0;
	u32 ckp_rtcode4;
	u32 ckn_rtcode3_0;
	u32 ckn_rtcode4;
	u32 ckp_skew_hi;
	u32 ckp_skew_lo;
	u32 ckn_skew_hi;
	u32 ckn_skew_lo;
	u32 ck_ckmode_en;
	u32 ck_ana_pn_swap_en;
	u32 ck_t0_tiel_en;
	u32 ck_ser_bisttog;
	u32 ck_ser_din_sel;
	u32 ck_ldoout_en;
	u32 ck_loopback_en;
	u32 ck_lptx_iplus1;
	u32 ck_lptx_iplus2;
	u32 ck_lptx_iminus;
	u32 ck_lpcd_iplus;
	u32 ck_lpcd_iminus;
	u32 ck_rtcode;
	u32 ck_cklane_en;
	u32 ck_dig_pn_swap_en;
	u32 ck_sw_ctl_en;
	u32 ck_sw_lptx_pre_oe;
	u32 ck_sw_lptx_oe;
	u32 ck_sw_lptx_dp;
	u32 ck_sw_lptx_dn;
	u32 ck_sw_lprx_en;
	u32 ck_sw_hstx_pre_oe;
	u32 ck_sw_hstx_oe;
	u32 ck_sw_hstx_rdy;
	u32 ckc_sw_lptx_pre_oe;
	u32 ckc_sw_lptx_oe;
	u32 ckc_sw_lprx_en;
	u32 ckc_sw_hstx_pre_oe;
	u32 ckc_sw_hstx_oe;
	u32 ckc_sw_hstx_rdy;
	u32 ck_sw_hstx_data1_0;
	u32 ck_sw_hstx_data3_2;
	u32 ck_sw_hstx_data5_4;
	u32 ck_sw_hstx_data7_6;
	u32 ckc_sw_hstx_data1_0;
	u32 ckc_sw_hstx_data3_2;
	u32 ckc_sw_hstx_data5_4;
	u32 ckc_sw_hstx_data6;
	u32 ck_sw_cd_con;
	u32 ck_ad_rx;
	u32 ck_ad_cd;
	u32 ckp_rt_dem_code;
	u32 ckn_rt_dem_code;
	u32 ck_hstx_ldo_iboost_en;
	u32 ck_dbg_sel;
	u32 ck_chksum0;
	u32 ck_chksum1;
	u32 ck_chksum2;
	u32 ck_chksum3;
	u32 ck_chksum4;
	u32 ck_chksum5;
	u32 ck_phy_rst_sel;
	u32 ckc_abc_swap_sel;
	u32 reserved4[3];
	u32 d1p_rtcode3_0;
	u32 d1p_rtcode4;
	u32 d1n_rtcode3_0;
	u32 d1n_rtcode4;
	u32 d1p_skew_hi;
	u32 d1p_skew_lo;
	u32 d1n_skew_hi;
	u32 d1n_skew_lo;
	u32 d1_ckmode_en;
	u32 d1_ana_pn_swap_en;
	u32 d1_t0_tiel_en;
	u32 d1_ser_bisttog;
	u32 d1_ser_din_sel;
	u32 d1_ldoout_en;
	u32 d1_loopback_en;
	u32 d1_lptx_iplus1;
	u32 d1_lptx_iplus2;
	u32 d1_lptx_iminus;
	u32 d1_lpcd_iplus;
	u32 d1_lpcd_iminus;
	u32 d1_rtcode;
	u32 d1_cklane_en;
	u32 d1_dig_pn_swap_en;
	u32 d1_sw_ctl_en;
	u32 d1_sw_lptx_pre_oe;
	u32 d1_sw_lptx_oe;
	u32 d1_sw_lptx_dp;
	u32 d1_sw_lptx_dn;
	u32 d1_sw_lprx_en;
	u32 d1_sw_hstx_pre_oe;
	u32 d1_sw_hstx_oe;
	u32 d1_sw_hstx_rdy;
	u32 d1c_sw_lptx_pre_oe;
	u32 d1c_sw_lptx_oe;
	u32 d1c_sw_lprx_en;
	u32 d1c_sw_hstx_pre_oe;
	u32 d1c_sw_hstx_oe;
	u32 d1c_sw_hstx_rdy;
	u32 d1_sw_hstx_data1_0;
	u32 d1_sw_hstx_data3_2;
	u32 d1_sw_hstx_data5_4;
	u32 d1_sw_hstx_data7_6;
	u32 d1c_sw_hstx_data1_0;
	u32 d1c_sw_hstx_data3_2;
	u32 d1c_sw_hstx_data5_4;
	u32 d1c_sw_hstx_data6;
	u32 d1_sw_cd_con;
	u32 d1_ad_rx;
	u32 d1_ad_cd;
	u32 d1p_rt_dem_code;
	u32 d1n_rt_dem_code;
	u32 d1_hstx_ldo_iboost_en;
	u32 d1_dbg_sel;
	u32 d1_chksum0;
	u32 d1_chksum1;
	u32 d1_chksum2;
	u32 d1_chksum3;
	u32 d1_chksum4;
	u32 d1_chksum5;
	u32 d1_phy_rst_sel;
	u32 d1c_abc_swap_sel;
	u32 reserved5[3];
	u32 d3p_rtcode3_0;
	u32 d3p_rtcode4;
	u32 d3n_rtcode3_0;
	u32 d3n_rtcode4;
	u32 d3p_skew_hi;
	u32 d3p_skew_lo;
	u32 d3n_skew_hi;
	u32 d3n_skew_lo;
	u32 d3_ckmode_en;
	u32 d3_ana_pn_swap_en;
	u32 d3_t0_tiel_en;
	u32 d3_ser_bisttog;
	u32 d3_ser_din_sel;
	u32 d3_ldoout_en;
	u32 d3_loopback_en;
	u32 d3_lptx_iplus1;
	u32 d3_lptx_iplus2;
	u32 d3_lptx_iminus;
	u32 d3_lpcd_iplus;
	u32 d3_lpcd_iminus;
	u32 d3_rtcode;
	u32 d3_cklane_en;
	u32 d3_dig_pn_swap_en;
	u32 d3_sw_ctl_en;
	u32 d3_sw_lptx_pre_oe;
	u32 d3_sw_lptx_oe;
	u32 d3_sw_lptx_dp;
	u32 d3_sw_lptx_dn;
	u32 d3_sw_lprx_en;
	u32 d3_sw_hstx_pre_oe;
	u32 d3_sw_hstx_oe;
	u32 d3_sw_hstx_rdy;
	u32 d3c_sw_lptx_pre_oe;
	u32 d3c_sw_lptx_oe;
	u32 d3c_sw_lprx_en;
	u32 d3c_sw_hstx_pre_oe;
	u32 d3c_sw_hstx_oe;
	u32 d3c_sw_hstx_rdy;
	u32 d3_sw_hstx_data1_0;
	u32 d3_sw_hstx_data3_2;
	u32 d3_sw_hstx_data5_4;
	u32 d3_sw_hstx_data7_6;
	u32 d3c_sw_hstx_data1_0;
	u32 d3c_sw_hstx_data3_2;
	u32 d3c_sw_hstx_data5_4;
	u32 d3c_sw_hstx_data6;
	u32 d3_sw_cd_con;
	u32 d3_ad_rx;
	u32 d3_ad_cd;
	u32 d3p_rt_dem_code;
	u32 d3n_rt_dem_code;
	u32 d3_hstx_ldo_iboost_en;
	u32 d3_dbg_sel;
	u32 d3_chksum0;
	u32 d3_chksum1;
	u32 d3_chksum2;
	u32 d3_chksum3;
	u32 d3_chksum4;
	u32 d3_chksum5;
	u32 d3_phy_rst_sel;
	u32 d3c_abc_swap_sel;
	u32 reserved6[3];
	u32 dphy_bist_con0;
	u32 dphy_bist_con1;
	u32 dphy_bist_con2;
	u32 reserved7[2];
	u32 dphy_bist_pattern_0;
	u32 dphy_bist_pattern_1;
	u32 dphy_bist_pattern_2;
	u32 dphy_bist_pattern_3;
	u32 dphy_bist_pattern_4;
	u32 dphy_bist_pattern_5;
	u32 dphy_bist_pattern_6;
	u32 dphy_bist_pattern_7;
	u32 cphy_bist_con0;
	u32 cphy_bist_con1;
	u32 cphy_bist_wire_state;
	u32 cphy_bist_prb_sel;
	u32 reserved8[4];
	u32 cphy_bist_progseq_lsb_0;
	u32 cphy_bist_progseq_lsb_1;
	u32 cphy_bist_progseq_lsb_2;
	u32 cphy_bist_progseq_lsb_3;
	u32 cphy_bist_progseq_lsb_4;
	u32 cphy_bist_progseq_lsb_5;
	u32 cphy_bist_progseq_lsb_6;
	u32 cphy_bist_progseq_lsb_7;
	u32 cphy_bist_progseq_msb_0;
	u32 cphy_bist_progseq_msb_1;
	u32 cphy_bist_progseq_msb_2;
	u32 cphy_bist_prb_seed_0;
	u32 cphy_bist_prb_seed_1;
	u32 cphy_bist_prb_seed_2;
	u32 cphy_bist_prb_seed_3;
	u32 cphy_bist_prb_seed_4;
	u32 cphy_bist_prebegin_sym;
	u32 cphy_bist_preend_sym;
	u32 reserved9;
	u32 bist_timing00_hi;
	u32 bist_timing00_lo;
	u32 bist_timing01_hi;
	u32 bist_timing01_lo;
	u32 bist_timing02_hi;
	u32 bist_timing02_lo;
	u32 bist_timing03_hi;
	u32 bist_timing03_lo;
	u32 bist_timing04_hi;
	u32 bist_timing04_lo;
	u32 bist_timing05_hi;
	u32 bist_timing05_lo;
	u32 bist_timing06_hi;
	u32 bist_timing06_lo;
	u32 bist_timing07_hi;
	u32 bist_timing07_lo;
	u32 bist_timing08_hi;
	u32 bist_timing08_lo;
	u32 bist_timing09_hi;
	u32 bist_timing09_lo;
	u32 bist_timing10_hi;
	u32 bist_timing10_lo;
	u32 reserved10[2];
	u32 ck1p_rtcode3_0;
	u32 ck1p_rtcode4;
	u32 ck1n_rtcode3_0;
	u32 ck1n_rtcode4;
	u32 ck1p_skew_hi;
	u32 ck1p_skew_lo;
	u32 ck1n_skew_hi;
	u32 ck1n_skew_lo;
	u32 ck1_ckmode_en;
	u32 ck1_ana_pn_swap_en;
	u32 ck1_t0_tiel_en;
	u32 ck1_ser_bisttog;
	u32 ck1_ser_din_sel;
	u32 ck1_ldoout_en;
	u32 ck1_loopback_en;
	u32 ck1_lptx_iplus1;
	u32 ck1_lptx_iplus2;
	u32 ck1_lptx_iminus;
	u32 ck1_lpcd_iplus;
	u32 ck1_lpcd_iminus;
	u32 ck1_rtcode;
	u32 ck1_cklane_en;
	u32 ck1_dig_pn_swap_en;
	u32 ck1_sw_ctl_en;
	u32 ck1_sw_lptx_pre_oe;
	u32 ck1_sw_lptx_oe;
	u32 ck1_sw_lptx_dp;
	u32 ck1_sw_lptx_dn;
	u32 ck1_sw_lprx_en;
	u32 ck1_sw_hstx_pre_oe;
	u32 ck1_sw_hstx_oe;
	u32 ck1_sw_hstx_rdy;
	u32 ck1c_sw_lptx_pre_oe;
	u32 ck1c_sw_lptx_oe;
	u32 ck1c_sw_lprx_en;
	u32 ck1c_sw_hstx_pre_oe;
	u32 ck1c_sw_hstx_oe;
	u32 ck1c_sw_hstx_rdy;
	u32 ck1_sw_hstx_data1_0;
	u32 ck1_sw_hstx_data3_2;
	u32 ck1_sw_hstx_data5_4;
	u32 ck1_sw_hstx_data7_6;
	u32 ck1c_sw_hstx_data1_0;
	u32 ck1c_sw_hstx_data3_2;
	u32 ck1c_sw_hstx_data5_4;
	u32 ck1c_sw_hstx_data6;
	u32 ck1_sw_cd_con;
	u32 ck1_ad_rx;
	u32 ck1_ad_cd;
	u32 ck1p_rt_dem_code;
	u32 ck1n_rt_dem_code;
	u32 ck1_hstx_ldo_iboost_en;
	u32 ck1_dbg_sel;
	u32 ck1_chksum0;
	u32 ck1_chksum1;
	u32 ck1_chksum2;
	u32 ck1_chksum3;
	u32 ck1_chksum4;
	u32 ck1_chksum5;
	u32 ck1_phy_rst_sel;
	u32 ck1c_abc_swap_sel;
};

check_member(mipi_tx_regs, d2p_rtcode3_0, 0x100);
check_member(mipi_tx_regs, d0c_abc_swap_sel, 0x2F0);
check_member(mipi_tx_regs, ck1p_rtcode3_0, 0x700);
check_member(mipi_tx_regs, ck1c_abc_swap_sel, 0x7F0);

static struct mipi_tx_regs *const mipi_tx0 = (void *)MIPITX0_BASE;
static struct mipi_tx_regs *const mipi_tx1 = (void *)MIPITX1_BASE;

/* Register values */
#define RG_DSI_HSTX_LDO_REF_SEL		GENMASK(9, 6)
#define RG_DSI_PRD_REF_SEL		GENMASK(5, 0)
#define RG_DSI_PRD_REF_MINI		0
#define RG_DSI_PRD_REF_DEF		4
#define RG_DSI_PRD_REF_MAX		7

#define DSI_CK_CKMODE_EN	BIT(0)
#define DSI_SW_CTL_EN		BIT(0)
#define AD_DSI_PLL_SDM_PWR_ON	BIT(0)
#define AD_DSI_PLL_SDM_ISO_EN	BIT(1)

#define RG_DSI_PLL_EN		BIT(0)
#define RG_DSI_PLL_POSDIV	GENMASK(10, 8)

#endif /* _SOC_MEDIATEK_MT8196_DSI_REG_H_ */
