/*
 *
 * Copyright (C) 2008 Advanced Micro Devices, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <arch/asm.h>
#include <arch/lib_helpers.h>

/*
 * Our entry point
 */
ENTRY(_entry)
	/* Initialize SCTLR to intended state (icache and stack-alignment on) */
	ldr w1, =(SCTLR_RES1 | SCTLR_I | SCTLR_SA)
	msr sctlr_el2, x1

	/* Initialize HCR to intended state (route all exceptions to EL2) */
	mov x1, #HCR_TGE
	msr hcr_el2, x1

	/* Initialize PSTATE.DAIF to intended state (unmask all exceptions) */
	msr DAIFClr, #0xf

	/* Save off the location of the coreboot tables */
	ldr x1, 1f
	str x0, [x1]

	/* Setup new stack */
	ldr x1, 2f
	mov sp, x1

	/* Let's rock. */
	bl start_main

	ret
ENDPROC(_entry)

.align 4
1:
.quad	cb_header_ptr
2:
.quad	_estack
