#ifndef REFLOG_WALK_H
#define REFLOG_WALK_H

#include "cache.h"

struct reflog_walk_info;

extern void init_reflog_walk(struct reflog_walk_info **info);
extern int add_reflog_for_walk(struct reflog_walk_info *info,
		struct commit *commit, const char *name);
extern void show_reflog_message(struct reflog_walk_info *info, int,
				const struct date_mode *, int force_date);
extern void get_reflog_message(struct strbuf *sb,
		struct reflog_walk_info *reflog_info);
extern const char *get_reflog_ident(struct reflog_walk_info *reflog_info);
extern timestamp_t get_reflog_timestamp(struct reflog_walk_info *reflog_info);
extern void get_reflog_selector(struct strbuf *sb,
		struct reflog_walk_info *reflog_info,
		const struct date_mode *dmode, int force_date,
		int shorten);

extern int reflog_walk_empty(struct reflog_walk_info *walk);

struct commit *next_reflog_entry(struct reflog_walk_info *reflog_info);

#endif
