#include <stdio.h>
#include <stdlib.h>

#include <security/pam_modules.h>
#include <security/pam_client.h>

#undef DEBUG

#include <security/_pam_macros.h>


#define PLUGINNAME    "testing"
#define PLUGINNAMELEN (sizeof(PLUGINNAME)-1)

#define MSG1          "hello\nworld"
#define MSG1LEN       (sizeof(MSG1)-1)

int pam_sm_authenticate(pam_handle_t *pamh,int flags,int argc,
			const char **argv)
{
    struct pam_message msg[2],*pmsg[2];
    struct pam_response *resp=NULL;
    union pam_u_packet_p packet1, packet2;
    struct pam_conv *conv;
    int retval;
    unsigned length, control;

    D(("called"));

    /* please load "testing" authentication agent */
    packet1.data = malloc(8+PLUGINNAMELEN);        /* not <NUL> terminated! */
    pamc_write__u32(packet1.data, 4+PLUGINNAMELEN);
    pamc_write__u32(packet1.data+4, PAMC_CONTROL_SELECT);
    D(("%.8x %.8x", packet1.length[0], packet1.length[1]));
    memcpy(packet1.data+8, PLUGINNAME, PLUGINNAMELEN);
    D(("%.8x %.8x", packet1.length[0], packet1.length[1]));
    msg[0].msg_style = PAM_BINARY_PROMPT;
    msg[0].msg = packet1.prompt;
    pmsg[0] = &msg[0];

    D(("made select"));

    /* here is the data for that agent */
    packet2.data = malloc(8+MSG1LEN);              /* not <NUL> terminated! */
    pamc_write__u32(packet2.data, 4+MSG1LEN);
    pamc_write__u32(packet2.data+4, PAMC_CONTROL_EXCHANGE);
    memcpy(packet2.data+8, MSG1, MSG1LEN);
    msg[1].msg_style = PAM_BINARY_PROMPT;
    msg[1].msg = packet2.prompt;
    pmsg[1] = &msg[1];

    D(("made message"));

    /* let's converse about it */
    retval = pam_get_item(pamh,PAM_CONV,(const void **)&conv);
    D(("getting conversation fn(): %s", pam_strerror(pamh, retval)));


    D(("length, control: %u %u", packet1.length[0], packet1.length[2]));
    D(("message: %s", pmsg[0]->msg+8));
    retval = conv->conv(2, (const struct pam_message **) pmsg
			, &resp, conv->appdata_ptr);
    D(("conversation returned: %s", pam_strerror(pamh, retval)));

    /* clean up */
    free(packet1.text);
    free(packet2.text);

    packet1.text = resp[0].resp;
    length = pamc_packet_length(packet1.data);
    D(("length returned for packet[0] is %u", length));
    control = pamc_read__u32(4+packet1.data);
    D(("control returned for packet[0] is %u", control));
    free(packet1.text);

    packet2.text = resp[1].resp;
    length = pamc_packet_length(packet2.data);
    D(("length returned for packet[1] is %u", length));
    control = pamc_read__u32(4+packet2.data);
    D(("control returned for packet[1] is %u", control));
    free(packet2.text);
    

    D(("done"));
    return PAM_AUTH_ERR;
}

int pam_sm_setcred(pam_handle_t *pamh,int flags,int argc,
			const char **argv)
{
    D(("called"));
    D(("done"));
    return PAM_AUTH_ERR;
}

