<?php
/**
 * $Horde: horde/menu.php,v 2.43 2003/07/24 18:57:54 jwm Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 * Copyright 2003      Michael Pawlowsky <mjpawlowsky@yahoo.com>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

/**
 * Customized compare function used by uasort().
 */
function sortByMenu()
{
    global $registry;

    $children = array();
    foreach ($registry->applications as $app => $params) {
        if (array_key_exists('menu_parent', $params)) {
            $children[$params['menu_parent']][$app] = $params;
            unset($registry->applications[$app]);
        }
    }

    $tmp = array();
    foreach ($registry->applications as $app => $params) {
        $tmp[$app] = $params;
        if (array_key_exists($app, $children)) {
            $active = false;
            $tmp[$app]['children'] = true;
            foreach ($children[$app] as $capp => $cparams) {
                $tmp[$capp] = $cparams;
                if ($cparams['status'] == 'active') {
                    $active = true;
                }
            }
            if (!$active) {
                unset($tmp[$app]);
            }
        }
    }

    $registry->applications = $tmp;
}

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';
require_once HORDE_BASE . '/lib/Help.php';

if (!Auth::getAuth()) {
    Horde::authenticationFailureRedirect();
}

Horde::addScriptFile('menu.js');
Menu::useAccessKeys(false);

if ($browser->hasQuirk('scrollbar_in_way')) {
    $js_onLoad = 'correctWidthForScrollbar()';
}
$bodyClass = 'sidebar';
require HORDE_TEMPLATES . '/common-header.inc';

// Sort the array so we have parents and children all lined up.
sortByMenu();

// Loop through the registry and create the <div>s.
$menutext = '';    // Variable for the HTML output.
$i = 0;            // Counter for looping through the registry.
$last_group = -1;  // To track groups of menus to make <div>s.
$last_parent = 0;  // Track the last parent we used.

foreach ($registry->applications as $app => $params) {
    $params['name'] = gettext($params['name']);
    if ($params['status'] == 'active' || $params['status'] == 'heading') {
        $i++;
        $group = isset($params['menu_parent']) ? $params['menu_parent'] : null;
        $attr  = '';

        // When we switch groups close up the <div>.
        if (($i != 1) && ($group != $last_group)) {
            $menutext .= "</table></div>\n";
        }

        // Headings have no webroot; they're just containers for other
        // menu items.
        if ($params['status'] == 'heading' || !array_key_exists('webroot', $params)) {
            $url = '#';
        } else {
            $url = Horde::url($params['webroot'] . '/' . (isset($params['initial_page']) ? $params['initial_page'] : ''));
        }
        if (!array_key_exists('menu_parent', $params)) {
            // Standalone link or container heading.
            $menutext .= '<div class="head"><table border="0" cellpadding="0" cellspacing="0">';
            if (array_key_exists('children', $params) && $params['status'] == 'heading') {
                $link = Horde::link($url, $params['name'], 'menuitem', 'horde_main',
                                    "toggle('" . $app . "'); this.blur(); return false;", $params['name']);
                $image = $link . Horde::img($params['icon'], $params['name'], '', '') . '</a>';
                $text = $link . $params['name'] . '</a>';
            } else {
                $link = Horde::link($url, $params['name'], 'menuitem', isset($params['target']) ? $params['target'] : 'horde_main', 'this.blur()', $params['name']);
                $image = $link . Horde::img($params['icon'], $params['name'], '', '') . '</a>';
                $text = $link . $params['name'] . '</a>';
            }
        } else {
            // Subitem.
            if ($group != $last_group) {
                $menutext .= '<div class="para" id="menu_' . $group . '"><table border="0" cellpadding="0" cellspacing="0">';
                $last_group = $group;
            }

            $link  = Horde::link($url, $params['name'], 'menuitem', isset($params['target']) ? $params['target'] : 'horde_main', 'this.blur()', $params['name']);
            $image = Horde::img('tree/blank.gif', $params['name'], 'width="16" height="16"');
            $attr  = ' align="center" width="28" height="20"';
            $text  = $link . Horde::img($params['icon'], $params['name'], '', '') . '</a></td><td>';
            $text .= $link . $params['name'] . '</a>';
        }

        $menutext .= '<tr><td align="center" width="28" height="20">' . $image . '</td><td' . $attr . '>' . $text . '</td></tr>';
    }
}

$menutext .= '</table></div>';

/* Add the administration link if the user is an admin. */
if (Auth::isAdmin()) {
    $menutext .= '<div class="head"><table border="0" cellpadding="0" cellspacing="0">';
    $link = Horde::link('#', _("Administration"), 'menuitem', null,
                        "toggle('administration');this.blur()", _("Administration"));
    $menutext .= '<tr><td align="center" width="28" height="20">' . $link . Horde::img('administration.gif', _("Administration")) . '</a></td><td>' . $link . _("Administration") . '</a></td></tr></table>';

    $menutext .= '<div class="para" id="menu_administration"><table border="0" cellpadding="0" cellspacing="0">';

    $menutext .= '<tr><td align="center" width="28" height="20">' . Horde::img('tree/blank.gif', _("Configuration"), 'width="16" height="16"');
    $link = Horde::link(Horde::applicationUrl('admin/setup.php'), _("Configuration"), 'menuitem', 'horde_main', null, _("Configuration"));
    $menutext .= '</td><td>' . $link . Horde::img('administration.gif', _("Configuration")) . '</a></td><td>' . $link . _("Configuration") . '</a></td></tr>';

    foreach ($registry->listApps() as $app) {
        if ($registry->hasMethod('admin_list', $app)) {
            $list = $registry->callByPackage($app, 'admin_list');
            if (!is_a($list, 'PEAR_Error')) {
                foreach ($list as $method => $vals) {
                    if ($app != 'horde') {
                        $name = $registry->getParam('name', $app);
                        if (!empty($vals['name'])) {
                            $name .= ' ' . $vals['name'];
                        }
                    } else {
                        $name = $vals['name'];
                    }
                    $img = isset($vals['icon']) ? $registry->getParam('graphics', $app) . '/' . $vals['icon'] : $registry->getParam('icon', $app);

                    $menutext .= '<tr><td align="center" width="28" height="20">' . Horde::img('tree/blank.gif', $name, 'width="16" height="16"') . '</td>';
                    $link = Horde::link(Horde::url($registry->applicationWebPath($vals['link'], $app)),
                                        $name, 'menuitem', 'horde_main', 'this.blur()', $name);
                    $menutext .= '<td>' . $link . Horde::img($img, $name, '', '') . '</a></td><td>' . $link . $name . '</a></td></tr>';
                }
            }
        }
    }

    $menutext .= '</table></div></div>';
}

/* Add a logout link. */
$link = Horde::link(Horde::applicationUrl('login.php?reason=logout'), _("Logout"), 'menuitem', '_top',
                    null, sprintf(_("Log out of %s"), $registry->getParam('name')));
$menutext .= '<table border="0" cellpadding="0" cellspacing="0"><tr><td align="center" width="28" height="20">' . $link . Horde::img('logout.gif', _("Logout")) . '</a></td><td>' . $link . _("Logout") . '</a></td></tr></table>';

require HORDE_TEMPLATES . '/horde/menu.inc';
require HORDE_TEMPLATES . '/common-footer.inc';
