<?php
    $sortImg = ($sortdir) ? 'za.gif' : 'az.gif';
    $sortText = _("Sort Direction");
    $headers = array(
        SORTARRIVAL => array(
            'stext' => _("Sort by Arrival"),
            'text' => _("#"),
            'width' => '4%'
        ),
        SORTDATE => array(
            'stext' => _("Sort by Date"),
            'text' => _("Date"),
            'width' => '12%'
        ),
        SORTTO => array(
            'stext' => _("Sort by To Address"),
            'text' => _("To"),
            'width' => '20%'
        ),
        SORTFROM => array(
            'stext' => _("Sort by From Address"),
            'text' => _("From"),
            'width' => '20%'
        ),
        SORTTHREAD => array(
            'stext' => _("Sort by Thread"),
            'text' => _("Thread"),
            'width' => '52%'
        ),
        SORTSUBJECT => array(
            'stext' => _("Sort by Subject"),
            'text' => _("Subject"),
            'width' => '52%'
        ),
        SORTSIZE => array(
            'stext' => _("Sort by Message Size"),
            'text' => _("Size"),
            'width' => '4%'
        )
    );

    /* If this is the Drafts or Sent-Mail Folder, sort by To instead of
       From.*/
    if ($drafts_sm_folder) {
        unset($headers[SORTFROM]);
    } else {
        unset($headers[SORTTO]);
    }

    /* Determine which of Subject/Thread to emphasize. */
    $extra = SORTTHREAD;
    $standard = SORTSUBJECT;
    if ($thread_sort) {
        $extra = SORTSUBJECT;
        $standard = SORTTHREAD;
    }
    $headers[$standard]['extra'] = '&nbsp;<span style="font-size: 10px;">[' . Horde::widget(Horde::addParameter($mailbox_url, 'sortby', $extra), $headers[$extra]['stext'], 'widget" style="font-size: 10px; font-weight: normal;', null, null, $headers[$extra]['text']) . ']</span>';
    unset($headers[$extra]);
?>
<tr class="control"><td colspan="6">
<form method="post" name="messages" action="<?php echo $mailbox_url ?>">
<?php Horde::pformInput() ?>
<table width="100%" border="0" cellpadding="0" cellspacing="1">
<tr class="item">
    <th align="left" nowrap="nowrap" width="8%"><input type="checkbox" name="checkAll" onclick="makeSelection(-1);" title="<?php echo _("Check All/None") ?>" /></th>
<?php foreach ($headers as $key => $val): ?>
    <th class="<?php echo ($sortby == $key) ? 'selected' : 'item' ?>" width="<?php echo $val['width'] ?>" align="left" nowrap="nowrap">
<?php if ($sortlimit): ?>
        <?php echo $val['text'] ?>
<?php else: ?>
        <?php echo Horde::link(Horde::addParameter($sort_url, 'sortby', $key), $val['stext'], null, null, null, $val['stext']) . Horde::img($sortImg, $sortText, null, $registry->getParam('graphics', 'horde')) ?></a>
        <?php echo Horde::widget(Horde::addParameter($mailbox_url, 'sortby', $key), $val['stext'], 'widget', null, null, $val['text']) ?>
<?php if (isset($val['extra'])) echo $val['extra']; ?>
<?php endif; ?>
    </th>
<?php endforeach; ?>
</tr>
