<?php
/**
 * The IMP_MIME_Viewer_rfc822 class renders out messages from
 * message/rfc822 content types.
 *
 * $Horde: imp/lib/MIME/Viewer/rfc822.php,v 1.18 2003/08/06 21:35:56 slusarz Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.18 $
 * @since   IMP 4.0
 * @package horde.mime.viewer
 */
class IMP_MIME_Viewer_rfc822 extends MIME_Viewer {

    /**
     * Render out the currently set contents.
     *
     * @access public
     *
     * @param array $params  An array with a reference to a MIME_Contents
     *                       object.
     *
     * @return string  The rendered text in HTML.
     */
    function render($params)
    {
        $contents = &$params[0];

        /* Get the entire body part of the message/rfc822 contents. */
        $part = &$contents->getDecodedMIMEPart($this->mime_part->getMIMEId(), true);

        if (!($body = $part->getContents())) {
            return $contents->formatStatusMsg(_("There was an error displaying this message part"));
        } else {
            return $body;
        }
    }

    /**
     * Return the MIME content type for the rendered data.
     *
     * @access public
     *
     * @return string  The content type of the data.
     */
    function getType()
    {
        return 'text/plain';
    }

}
