<?php
/**
 * $Horde: imp/config/servers.php.dist,v 1.33 2003/02/12 11:18:56 jan Exp $
 *
 * This file is where you specify what servers people using your
 * installation of IMP can log in to. There are a number of properties
 * that you can set for each server:
 *
 * name: This is the plaintext, english name that you want displayed
 *       to people if you are using the drop down server list.
 *
 * server: The hostname of the mail server to connect to.
 *
 * protocol: One of 'imap/notls' (or only 'imap' if you have a c-client
 *           version 2000c or older), 'pop3', 'imap/ssl', or 'pop3/ssl'.
 *           If it's pop3 you're going to be connecting to a POP3 mail
 *           server instead of IMAP (so make sure the port is correct -
 *           110 by default), and all folder options will be automatically
 *           turned off. The two ssl options will only work if you've
 *           compiled PHP against an SSL-enabled version of c-client, used
 *           the --with-imap-ssl flag compiling PHP, and you have a mail
 *           server which supports SSL. The default ports are 993 for IMAP
 *           over SSL, and 995 for POP3 over SSL.
 *
 *           NOTE - If you are using a self-signed server certificate with
 *           either imap/ssl or pop3/ssl, you MUST add /novalidate-cert at
 *           the end of the protocol string. So for imap, this would be
 *           'imap/ssl/novalidate-cert', and for pop3 it would be
 *           'pop3/ssl/novalidate-cert'. This is necessary to tell c-client
 *           not to complain about the lack of a valid CA on the
 *           certificate.
 *
 * port: The port that the mail (imap or pop) service this server runs is
 *       on.
 *
 * folders: The folder path for the IMAP server. i.e. UW IMAP generally
 *          looks to 'mail/' while Cyrus and Courier put folders under
 *          'INBOX.' (note the trailing dot). IMPORTANT: Use this only if
 *          you want to restrict users to this subfolder. If you set this
 *          to 'INBOX.' with Cyrus or Courier-IMAPd, then users will not
 *          be able to use any shared folders - nothing outside of 'INBOX.'
 *          will be visible (except, of course, their INBOX itself). If you
 *          simply want to mask out the INBOX. prefix (or another prefix)
 *          for display purposes, use the 'namespace' attribute.  NOTE: If
 *          you use this option, DO NOT SET 'namespace' ALSO!
 *
 * namespace: This is where you put any paths that you want stripped out
 *            for presentation purposes (i.e. you don't want your users to
 *            have to know that their personal folders are actually
 *            subfolders of their INBOX). A common value for this with
 *            Cyrus-style IMAP servers is 'INBOX.'. NOTE: If you have
 *            shared folders, using this may create confusion between shared
 *            sharedfolders and personal folders, if users have folders with
 *            the same name as a shared folder.  NOTE: If you use this
 *            option, DO NOT SET 'folders' ALSO!
 *
 * maildomain: What to put after the @ when sending mail. i.e. if you want
 *             all mail to look like 'From: user@example.com' set
 *             maildomain to 'example.com'. It is generally useful when
 *             the IMAP host is different from the mail receiving host. This
 *             will also be used to complete unqualified addresses when
 *             composing mail.
 *
 * smtphost: If specified, and $conf['mailer']['type'] is set to 'smtp',
 *           IMP will use this host for outbound SMTP connections.  This
 *           value overrides any existing $conf['mailer']['params']['host']
 *           value at runtime.
 *
 * realm: ONLY USE REALM IF: YOU ARE USING IMP FOR HORDE AUTHENTICATION,
 *        AND YOU HAVE MULTIPLE SERVERS AND USERNAMES OVERLAP BETWEEN
 *        THOSE SERVERS. If you only have one server, or have multiple
 *        servers with no username clashes, or have full user@example.com
 *        usernames, you DO NOT need a realm setting. If you set one, an
 *        '@' symbol plus the realm will be appended to the username that
 *        users log in to IMP with to create the username that Horde treats
 *        the user as. So with a realm of 'example.com', the username
 *        'jane' would be treated by Horde (NOT your IMAP server) as
 *        'jane@example.com', and the username 'jane@example.com' would be
 *        treated as 'jane@example.com@example.com' - an occasion where you
 *        probably don't need a realm setting.
 *
 * preferred: Only useful if you want to use the same servers.php file
 *            for different machines: if the hostname of the IMP machine is
 *            identical to one of those in the preferred list, then the
 *            corresponding option in the select box will include SELECTED
 *            (i.e. it is selected per default). Otherwise the first entry
 *            in the list is selected.
 *
 * quota: Use this if you want to display a users quota status on various
 *        IMP pages. Set 'driver' equal to the mailserver and 'params'
 *        equal to any extra parameters needed by the driver. Set to
 *        false to disable quota display. NOTE: Not all IMAP servers
 *        currently support this feature.
 *        Currently available drivers: 'command', 'courier', 'cyrus',
 *                                     'logfile', 'mdaemon'
 *
 * acl: Use this if you want to use Access Control Lists (folder sharing)
 *      Set 'driver' equal to the type of ACL your server supports and
 *      'params' to an array containing any additional parameters the
 *      driver needs. Not all IMAP servers currently support this
 *      feature.
 *      At present the only driver supported is 'rfc2086', which does not
 *      require any params. NOTE: if you do not have the PEAR Auth_SASL
 *      module installed the rfc2086 driver will send user's passwords to
 *      the IMAP server in plain text when retrieving ACLs.
 *
 * dotfiles: Should files that begin with a '.' be shown in the folder lists?
 *           This should be either true or false.
 *
 * hierarchies: Should we enable any folder hierarchies that aren't shown by
 *              default? For instance, UW can be configured to serve out
 *              folder hierarchies. This entry must be an array.
 *              Example folder hierarchies: #shared/, #news/, #ftp/, $public/
 *
 * Here are some example configurations:
 */

// Any entries whose key value ('foo' in $servers['foo']) begin with
// '_' (an underscore character) will be treated as prompts, and you
// won't be able to log in to them. The only property these entries
// need is 'name'. This lets you put labels in the list, like this
// example:

$servers['kolab'] = array(
    'name' => 'Kolab IMAP Server',
    'server' => $conf['server']['name'],
    'protocol' => 'imap/notls',
    'port' => 143,
    'folders' => '',
    'namespace' => 'INBOX/',
    'maildomain' => $conf['server']['maildomain'],
    'smtphost' => $conf['server']['smtphost'],
    'realm' => '',
    'preferred' => '',
    'quota' => array(
        'driver' => 'cyrus',
        'params' => array(
            'login' => 'admin',
            'password' => 'admin_pass'
        )
    ),
    'acl' => array(
        'driver' => 'rfc2086',
    ),
    'dotfiles' => false,
    'hierarchies' => array()
);
