<?php
/**
 * $Horde: forwards/lib/base.php,v 1.26 2003/09/24 20:42:51 chuck Exp $
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * Forwards base inclusion file.
 *
 * This file brings in all of the dependencies that every Forwards script
 * will need, and sets up objects that all scripts use.
 */

// Check for a prior definition of HORDE_BASE (perhaps by an
// auto_prepend_file definition for site customization).
if (!defined('HORDE_BASE')) {
    @define('HORDE_BASE', dirname(__FILE__) . '/../..');
}

// Load the Horde Framework core, and set up inclusion paths.
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';
require_once HORDE_BASE . '/lib/Notification.php';
require_once HORDE_BASE . '/lib/Registry.php';

// Registry.
$registry = &Registry::singleton();
if (is_a($registry->pushApp('forwards'), 'PEAR_Error')) {
    Horde::fatal(PEAR::raiseError(_("Forwards is not correctly configured or there was an error loading configuration files.")), __FILE__, __LINE__, false);
}
$conf = &$GLOBALS['conf'];
@define('FORWARDS_TEMPLATES', $registry->getParam('templates'));

// Notification system.
$notification = &Notification::singleton();
$notification->attach('status');

// Don't allow access unless there is a Horde login NOTE: We
// explicitely do NOT honor the guests flag here.
if (!Auth::isAuthenticated()) {
    Horde::authenticationFailureRedirect();
}

// Find the base file path of Forwards.
@define('FORWARDS_BASE', dirname(__FILE__) . '/..');

// Help.
require_once HORDE_BASE . '/lib/Help.php';

/**
 * Define a Forwards base class.
 */
class Forwards {

    function menu()
    {
        global $conf, $notification, $registry;
        require_once HORDE_BASE . '/lib/Menu.php';
        require FORWARDS_TEMPLATES . '/menu/menu.inc';

        $notification->notify();

        /* Include the JavaScript for the help system (if enabled). */
        Help::javascript();
    }

}
