/*
    This file is part of KOrganizer.
    Copyright (c) 2002 Klarlvdalens Datakonsult AB <info@klaralvdalens-datakonsult.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

/* This comes from KMLineEdit in KMail. This code reduplication is
   unfortunate, but necessary in order to avoid compile-time
   dependencies between kdenetwork and kdepim, unless the whole scheme
   of addressbook-based completion is moved into kdelibs. Copyright of
   the initial version (C) 1998 Markus Wuebben.
*/

#ifndef KOLINEEDIT_H
#define KOLINEEDIT_H

#include <klineedit.h>
class KOEditorDetails;

#define KOLineEditInherited KLineEdit
class KOLineEdit : public KLineEdit
{
  Q_OBJECT

public:
  KOLineEdit(KOEditorDetails* editor, 
             bool useCompletion, QWidget *parent = 0,
             const char *name = 0);
  /** What is this editordetails pointer for anyway? */
  KOLineEdit(bool useCompletion, QWidget *parent = 0,
             const char *name = 0);
  /** like the above with useCompletion = true */
  KOLineEdit(QWidget *parent = 0,
             const char *name = 0);
  virtual ~KOLineEdit();

  virtual void setFont( const QFont& );
  virtual void setText( const QString& );

  void setEmailLineEdit( QLineEdit* mailEdit );

public slots:
  void undo();
  /**
   * Set cursor to end of line.
   */
  void cursorAtEnd();

protected:
  virtual bool eventFilter(QObject*, QEvent*);
  virtual void paste();
  virtual void insert(const QString &t);
  virtual void mouseReleaseEvent( QMouseEvent * e );
  void doCompletion(bool ctrlT);
  KOEditorDetails* mEditor;

private slots:
  void slotCompletion() { doCompletion(false); }
  void slotPopupCompletion( const QString& );

private:
  void init();
  
  void loadAddresses();
  /** Strip email address from string. Examples:
   * "Stefan Taferner <taferner@kde.org>" returns "Stefan Taferner"
   * "joe@nowhere.com" returns "joe@nowhere.com". Note that this only
   * returns the first name, e.g. "Peter Test <p@t.de>, Harald Tester <ht@test.de>"
   * returns "Peter Test" */
  static QString stripEmailAddr(const QString& emailAddr);

  /** Return email address from string. Examples:
   * "Stefan Taferner <taferner@kde.org>" returns "taferner@kde.org"
   * "joe@nowhere.com" returns "joe@nowhere.com". Note that this only
   * returns the first address. */
  static QCString getEmailAddr(const QString& emailAddr);

  /** Split a comma separated list of email addresses. */
  static QStringList splitEmailAddrList(const QString&);

  QString m_previousAddresses;
  bool m_useCompletion;
  QLineEdit* mMailEdit;

  static bool s_addressesDirty;
  static KCompletion *s_completion;
};

class KOabcBridge {
public:
  static void addresses(QStringList* result);
  static QString expandDistributionLists(QString recipients);
};

#endif
