// This file is part of Kig, a KDE program for Interactive Geometry.
// SPDX-FileCopyrightText: 2002 Dominique Devriese <devriese@kde.org>

// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "filter.h"

class CabriReader;

/**
 * This is an import filter for the output of the commercial program
 * Cabri ("CAhier de BRouillon Interactif" or something like that),
 * which is being pushed by Texas Instruments, but only exists for
 * the Windows operating system and some TI scientific calculators.
 *
 * \note
 * This is completely free code, i have not looked at any Cabri source
 * code, and have implemented this implementation of the Cabri file
 * format from zero, by just looking at the input and output from a
 * (properly licensed) Cabri program.
 */
class KigFilterCabri : public KigFilter
{
    KigFilterCabri();
    ~KigFilterCabri();

public:
    static KigFilterCabri *instance();

    bool supportMime(const QString &mime) override;
    KigDocument *load(const QString &fromfile) override;

    friend class CabriReader;
};
