% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.select.R
\name{rk.XML.select}
\alias{rk.XML.select}
\title{Create XML node "select" for RKWard plugins}
\usage{
rk.XML.select(
  label,
  options = list(label = c(val = "", chk = FALSE, i18n = NULL)),
  single = FALSE,
  id.name = "auto",
  help = NULL,
  component = rk.get.comp(),
  i18n = NULL
)
}
\arguments{
\item{label}{Character string, a text label for this plugin element.}

\item{options}{A named list with options to choose from. The names of the list elements will become
labels of the options, \code{val} defines the value to submit if the option is selected,
      and
\code{chk=TRUE} should be set in the one option which is selected by default. You might also provide an \code{i18n}
for this particular option (see \code{i18n}). Objects generated with \code{\link[rkwarddev:rk.XML.option]{rk.XML.option}}
are accepted as well.}

\item{single}{Logical, if set to \code{TRUE}, only a single value will be selectable,
      instead of multiple values at once
(requires RKWard >= 0.7.1).}

\item{id.name}{Character string, a unique ID for this plugin element.
If \code{"auto"} and a label was provided,
      an ID will be generated automatically from the label.}

\item{help}{Character string or list of character values and XiMpLe nodes,
      will be used as the \code{text} value for a setting node in the .rkh file.
If set to \code{FALSE},
      \code{\link[rkwarddev:rk.rkh.scan]{rk.rkh.scan}} will ignore this node.
Also needs \code{component} to be set accordingly!}

\item{component}{Character string,
      name of the component this node belongs to. Only needed if you
want to use the scan features for automatic help file generation; needs \code{help} to be set
accordingly, too!}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML node "select" for RKWard plugins
}
\examples{
test.select <- rk.XML.select("myselect",
  options=list("First Option"=c(val="val1"),
  "Second Option"=c(val="val2", chk=TRUE)))
cat(pasteXML(test.select))
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
