% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.cbox.R
\name{rk.XML.cbox}
\alias{rk.XML.cbox}
\alias{rk.XML.checkbox}
\title{Create XML node "checkbox" for RKWard plugins}
\usage{
rk.XML.cbox(
  label,
  value = "true",
  un.value = NULL,
  chk = FALSE,
  id.name = "auto",
  help = NULL,
  component = rk.get.comp(),
  i18n = NULL
)
}
\arguments{
\item{label}{Character string, a text label for this plugin element.}

\item{value}{Character string, the value to submit if the element is checked.}

\item{un.value}{Character string, an optional value for the unchecked option.}

\item{chk}{Logical, whether this element should be checked by default.}

\item{id.name}{Character string, a unique ID for this plugin element.
If \code{"auto"}, an ID will be generated automatically from the label.}

\item{help}{Character string or list of character values and XiMpLe nodes,
      will be used as the \code{text} value for a setting node in the .rkh file.
If set to \code{FALSE},
      \code{\link[rkwarddev:rk.rkh.scan]{rk.rkh.scan}} will ignore this node.
Also needs \code{component} to be set accordingly!}

\item{component}{Character string,
      name of the component this node belongs to. Only needed if you
want to use the scan features for automatic help file generation; needs \code{help} to be set
accordingly, too!}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML node "checkbox" for RKWard plugins
}
\note{
There's also a simple wrapper function \code{rk.XML.checkbox}.
}
\examples{
test.checkboxes <- rk.XML.row(rk.XML.col(
  list(
    rk.XML.cbox(label="foo", value="foo1", chk=TRUE),
    rk.XML.cbox(label="bar", value="bar2"))))
cat(pasteXML(test.checkboxes))
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
