% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.attribute.R
\name{rk.XML.attribute}
\alias{rk.XML.attribute}
\title{Create XML "attribute" node for RKWard plugins}
\usage{
rk.XML.attribute(id, value = NULL, label = NULL, i18n = NULL)
}
\arguments{
\item{id}{Either a character string (the \code{id} of the property whose attribute should be set),
or an object of class \code{XiMpLe.node} (whose \code{id} will be extracted and used).}

\item{value}{Character string, new value for the attribute.}

\item{label}{Character string, label associated with the attribute.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
This function will create a attribute node for component sections in .pluginmap files.
Only meaningful for import plugins.
}
\examples{
test.checkbox <- rk.XML.cbox(label="foo", value="foo1", chk=TRUE)
# re-set the attribute
test.attribute <- rk.XML.attribute(test.checkbox, value="bar2", label="bar")
cat(pasteXML(test.attribute))
}
\seealso{
\code{\link[rkwarddev:rk.XML.components]{rk.XML.components}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
