% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.JS.header.R
\name{rk.JS.header}
\alias{rk.JS.header}
\title{Generate JavaScript header object}
\usage{
rk.JS.header(title, ..., level = NULL, guess.getter = FALSE, .add = list())
}
\arguments{
\item{title}{Either a character string or object of class \code{rk.JS.i18n}. Will become the header title,
nested in an i18n() call.}

\item{...}{An optional number of additional info to add to the header. Each entry must be named \code{add}
or \code{addFromUI} -- note that you can use multiple entries with the same name here. Entries named
\code{add} must be vectors of legth 2, the first being the caption (character),
      the second its value (either
character,
      a XiMpLe node from the dialog or a single \code{rk.JS.ite} object); if the second value is named
\code{noquote} or \code{nq},
      the JS output will be nested inside \code{noquote()}. \code{rk.JS.ite} objects
will be printed in a condensed format. Entries named \code{addFromUI} must have exactly one value
specifying the GUI element to query (either character or a XiMpLe node from the dialog).}

\item{level}{Integer, if not \code{NULL} will be added as the header level.}

\item{guess.getter}{Locigal,
      if \code{TRUE} try to get a good default getter function for JavaScript
variable values.}

\item{.add}{Same as \code{...}, but provided as a single list. If used,
      values will be appended to \code{...}.}
}
\value{
A character string.
}
\description{
Generate JavaScript header object
}
\examples{
my.cbox <- rk.XML.cbox("This is a test")
rk.JS.header("Test results", addFromUI=my.cbox)

# let's assume we create an R object called "results"
# in the plugin dialog, this is how you could fetch
# portions of it to be added as a parameter in the output
rk.JS.header(
  "Test results",
  add=c("Significance level", noquote="results[[\\\\\"alpha\\\\\"]]")
)

# a dummy example using an rk.JS.ite object made with js()
rk.JS.header(
  "Test results",
  add=c(
    "Significance level",
    js(
      if(my.cbox){
        "this"
      } else {
        "that"
      },
      keep.ite=TRUE
    )
  )
)
}
