% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.JS.doc.R
\name{rk.JS.doc}
\alias{rk.JS.doc}
\title{Create JavaScript outline from RKWard plugin XML}
\usage{
rk.JS.doc(
  require = c(),
  variables = NULL,
  globals = NULL,
  results.header = NULL,
  header.add = list(),
  preprocess = NULL,
  calculate = NULL,
  printout = NULL,
  doPrintout = NULL,
  preview = FALSE,
  load.silencer = NULL,
  gen.info = TRUE,
  indent.by = rk.get.indent(),
  level = 2,
  guess.getter = FALSE
)
}
\arguments{
\item{require}{A character vector with names of R packages that the dialog depends on.}

\item{variables}{Either a character string to be included to read in all needed variables from the dialog (see \code{\link{rk.JS.scan}}),
or a (list of) objects of class \code{rk.JS.var} which will be coerced into character. These variables will be defined in
the \code{calculate()} and/or \code{printout()} functions.}

\item{globals}{Like \code{variables},
      but these variables will be defined globally. If \code{variables} is set as well,
the function tries to remove duplicate definitions.}

\item{results.header}{A character string to headline the printed results. Include escapes quotes (\\") if needed.
Set to \code{FALSE} or \code{""} if you need more control and want to define the header section in \code{printout}.}

\item{header.add}{A named list of additional info to add to the header. Each entry must be named \code{add}
or \code{addFromUI} -- see \code{\link[rkwarddev:rk.JS.header]{rk.JS.header}} for details.}

\item{preprocess}{A character string to be included in the \code{preprocess()} function. This string will be
pasted as-is, after \code{require} has been evaluated.}

\item{calculate}{A character string to be included in the \code{calculate()} function. This string will be
pasted as-is, after \code{variables} has been evaluated.}

\item{printout}{A character string to be included in the \code{printout()} function. This string will be
pasted as-is,
      after \code{results.header} has been evaluated. Appended after \code{doPrintout} if set (which is deprecated).}

\item{doPrintout}{Deprecated: A character string to be included in the \code{doPrintout()} function. This string will be
pasted as-is.}

\item{preview}{Either a logical value, if \code{TRUE},
      a \code{preview()} function will be added in any case.
Can also be a character string to be used as-is inside the \code{preview()} function.}

\item{load.silencer}{Either a character string (ID of probably a checkbox),
      or an object of class \code{XiMpLe.node}.
This defines a switch you can add to your plugin,
      to set the \code{require()} call inside \code{suppressMessages()},
hence suppressing all load messages (except for warnings and errors) of required packages in the output.}

\item{gen.info}{Logical, if \code{TRUE} a comment note will be written into the document,
that it was generated by \code{rkwarddev} and changes should be done to the script.
You can also provide a character string naming the very rkwarddev script file that generates this JS file,
which will then also be added to the comment.}

\item{indent.by}{A character string defining how indentation should be done.}

\item{level}{Integer, which indentation level to use, minimum is 1.}

\item{guess.getter}{Locigal,
      if \code{TRUE} try to get a good default getter function for JavaScript
variable values. Only used if \code{header.add} contains XiMpLe nodes.}
}
\value{
A character string.
}
\description{
You don't need to define a \code{preview()} function,
      as this can be added automatically by rkwarddev's code scanners.
}
\details{
For previews,
      use \code{js(if("!is_preview") {...})} style JavaScript code to toggle between modes (applies to \code{preprocess}, \code{calculate} and 
\code{printout}).
}
\seealso{
\code{\link[rkwarddev:rk.paste.JS]{rk.paste.JS}},
   \code{\link[rkwarddev:rk.JS.vars]{rk.JS.vars}},
   \code{\link[rkwarddev:rk.JS.array]{rk.JS.array}},
   \code{\link[rkwarddev:js]{js}},
   \code{\link[rkwarddev:echo]{echo}},
   \code{\link[rkwarddev:id]{id}},
   \code{\link[rkwarddev:rk.JS.header]{rk.JS.header}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
