// Copyright 2021-2026 The Khronos Group Inc.
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

module;

#define VULKAN_HPP_CXX_MODULE 1

#include <vulkan/vulkan_hpp_macros.hpp>

#if !defined( VULKAN_HPP_CXX_MODULE_EXPERIMENTAL_WARNING )
#  define VULKAN_HPP_CXX_MODULE_EXPERIMENTAL_WARNING \
    "\n\tThe Vulkan-Hpp C++ named module is experimental. It is subject to change without prior notice.\n" \
  "\tTo silence this warning, define the VULKAN_HPP_CXX_MODULE_EXPERIMENTAL_WARNING macro.\n" \
  "\tFor feedback, go to: https://github.com/KhronosGroup/Vulkan-Hpp/issues"

VULKAN_HPP_COMPILE_WARNING( VULKAN_HPP_CXX_MODULE_EXPERIMENTAL_WARNING )
#endif

#include <vulkan/vulkan_video.hpp>

export module vulkan:video;

export namespace VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE
{
  //=================
  //=== CONSTANTs ===
  //=================

#if defined( VULKAN_VIDEO_CODEC_H264STD_H_ )
  //=== vulkan_video_codec_h264std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264CpbCntListSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264MaxChromaPlanes;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264MaxNumListRef;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264NoReferencePicture;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ScalingList4X4NumElements;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ScalingList4X4NumLists;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ScalingList8X8NumElements;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ScalingList8X8NumLists;
#endif

#if defined( VULKAN_VIDEO_CODEC_H264STD_DECODE_H_ )
  //=== vulkan_video_codec_h264std_decode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH264FieldOrderCountListSize;
#endif

#if defined( VULKAN_VIDEO_CODEC_H265STD_H_ )
  //=== vulkan_video_codec_h265std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ChromaQpOffsetListSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ChromaQpOffsetTileColsListSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ChromaQpOffsetTileRowsListSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265CpbCntListSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265MaxChromaPlanes;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265MaxDeltaPoc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265MaxDpbSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265MaxLongTermPics;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265MaxLongTermRefPicsSps;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265MaxNumListRef;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265MaxShortTermRefPicSets;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265NoReferencePicture;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265PredictorPaletteCompEntriesListSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265PredictorPaletteComponentsListSize;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList16X16NumElements;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList16X16NumLists;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList32X32NumElements;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList32X32NumLists;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList4X4NumElements;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList4X4NumLists;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList8X8NumElements;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingList8X8NumLists;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265SublayersListSize;
#endif

#if defined( VULKAN_VIDEO_CODEC_H265STD_DECODE_H_ )
  //=== vulkan_video_codec_h265std_decode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH265RefPicSetListSize;
#endif

#if defined( VULKAN_VIDEO_CODEC_VP9STD_H_ )
  //=== vulkan_video_codec_vp9std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9LoopFilterAdjustments;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9MaxRefFrames;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9MaxSegmentationPredProb;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9MaxSegmentationTreeProbs;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9MaxSegments;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9NumRefFrames;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9RefsPerFrame;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Vp9SegLvlMax;
#endif

#if defined( VULKAN_VIDEO_CODEC_AV1STD_H_ )
  //=== vulkan_video_codec_av1std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1GlobalMotionParams;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1LoopFilterAdjustments;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxCdefFilterStrengths;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxLoopFilterStrengths;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxNumCbPoints;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxNumCrPoints;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxNumPlanes;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxNumPosChroma;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxNumPosLuma;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxNumYPoints;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxSegments;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxTileCols;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1MaxTileRows;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1NumRefFrames;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1PrimaryRefNone;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1RefsPerFrame;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1SegLvlMax;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1SelectIntegerMv;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1SelectScreenContentTools;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1SkipModeFrames;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::Av1TotalRefsPerFrame;
#endif

  //=============
  //=== ENUMs ===
  //=============

#if defined( VULKAN_VIDEO_CODEC_H264STD_H_ )
  //=== vulkan_video_codec_h264std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264AspectRatioIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264CabacInitIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ChromaFormatIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264DisableDeblockingFilterIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264LevelIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264MemMgmtControlOp;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ModificationOfPicNumsIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264NonVclNaluType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264PictureType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264PocType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ProfileIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264SliceType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264WeightedBipredIdc;
#endif

#if defined( VULKAN_VIDEO_CODEC_H264STD_DECODE_H_ )
  //=== vulkan_video_codec_h264std_decode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH264FieldOrderCount;
#endif

#if defined( VULKAN_VIDEO_CODEC_H265STD_H_ )
  //=== vulkan_video_codec_h265std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265AspectRatioIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ChromaFormatIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265LevelIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265PictureType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ProfileIdc;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265SliceType;
#endif

#if defined( VULKAN_VIDEO_CODEC_VP9STD_H_ )
  //=== vulkan_video_codec_vp9std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9ColorSpace;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9FrameType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9InterpolationFilter;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9Level;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9Profile;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9ReferenceName;
#endif

#if defined( VULKAN_VIDEO_CODEC_AV1STD_H_ )
  //=== vulkan_video_codec_av1std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1ChromaSamplePosition;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1ColorPrimaries;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1FrameRestorationType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1FrameType;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1InterpolationFilter;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1Level;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1MatrixCoefficients;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1Profile;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1ReferenceName;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1TransferCharacteristics;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1TxMode;
#endif

  //===============
  //=== STRUCTS ===
  //===============

#if defined( VULKAN_VIDEO_CODEC_H264STD_H_ )
  //=== vulkan_video_codec_h264std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264HrdParameters;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264PictureParameterSet;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264PpsFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264ScalingLists;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264SequenceParameterSet;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264SequenceParameterSetVui;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264SpsFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H264SpsVuiFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_H264STD_DECODE_H_ )
  //=== vulkan_video_codec_h264std_decode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH264PictureInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH264PictureInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH264ReferenceInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH264ReferenceInfoFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_H264STD_ENCODE_H_ )
  //=== vulkan_video_codec_h264std_encode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264PictureInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264PictureInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264ReferenceInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264ReferenceInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264ReferenceListsInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264ReferenceListsInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264RefListModEntry;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264RefPicMarkingEntry;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264SliceHeader;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264SliceHeaderFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264WeightTable;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH264WeightTableFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_H265STD_H_ )
  //=== vulkan_video_codec_h265std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265DecPicBufMgr;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265HrdFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265HrdParameters;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265LongTermRefPicsSps;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265PictureParameterSet;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265PpsFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265PredictorPaletteEntries;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ProfileTierLevel;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ProfileTierLevelFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ScalingLists;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265SequenceParameterSet;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265SequenceParameterSetVui;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ShortTermRefPicSet;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265ShortTermRefPicSetFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265SpsFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265SpsVuiFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265SubLayerHrdParameters;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265VideoParameterSet;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::H265VpsFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_H265STD_DECODE_H_ )
  //=== vulkan_video_codec_h265std_decode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH265PictureInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH265PictureInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH265ReferenceInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeH265ReferenceInfoFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_H265STD_ENCODE_H_ )
  //=== vulkan_video_codec_h265std_encode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265LongTermRefPics;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265PictureInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265PictureInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265ReferenceInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265ReferenceInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265ReferenceListsInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265ReferenceListsInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265SliceSegmentHeader;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265SliceSegmentHeaderFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265WeightTable;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeH265WeightTableFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_VP9STD_H_ )
  //=== vulkan_video_codec_vp9std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9ColorConfig;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9ColorConfigFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9LoopFilter;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9LoopFilterFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9Segmentation;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::VP9SegmentationFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_VP9STD_DECODE_H_ )
  //=== vulkan_video_codec_vp9std_decode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeVP9PictureInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeVP9PictureInfoFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_AV1STD_H_ )
  //=== vulkan_video_codec_av1std ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1CDEF;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1ColorConfig;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1ColorConfigFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1FilmGrain;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1FilmGrainFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1GlobalMotion;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1LoopFilter;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1LoopFilterFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1LoopRestoration;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1Quantization;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1QuantizationFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1Segmentation;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1SequenceHeader;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1SequenceHeaderFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1TileInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1TileInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1TimingInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::AV1TimingInfoFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_AV1STD_DECODE_H_ )
  //=== vulkan_video_codec_av1std_decode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeAV1PictureInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeAV1PictureInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeAV1ReferenceInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::DecodeAV1ReferenceInfoFlags;
#endif

#if defined( VULKAN_VIDEO_CODEC_AV1STD_ENCODE_H_ )
  //=== vulkan_video_codec_av1std_encode ===
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1DecoderModelInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1ExtensionHeader;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1OperatingPointInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1OperatingPointInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1PictureInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1PictureInfoFlags;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1ReferenceInfo;
  using VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE::EncodeAV1ReferenceInfoFlags;
#endif
}  // namespace VULKAN_HPP_NAMESPACE::VULKAN_HPP_VIDEO_NAMESPACE
