// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeInt32Array
 * @brief   strided implicit array of vtkTypeInt32.
 *
 * vtkStridedTypeInt32Array is an strided implicit array of values of type vtkTypeInt32.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeInt32Array_h
#define vtkStridedTypeInt32Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeInt32Array* New();
  static vtkStridedTypeInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeInt32Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeInt32* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeInt32* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeInt32* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeInt32Array();
  ~vtkStridedTypeInt32Array() override;

private:
  typedef vtkStridedArray<vtkTypeInt32> RealSuperclass;

  vtkStridedTypeInt32Array(const vtkStridedTypeInt32Array&) = delete;
  void operator=(const vtkStridedTypeInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
