// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStdFunctionTypeUInt64Array
 * @brief   std function implicit array of vtkTypeUInt64.
 *
 * vtkStdFunctionTypeUInt64Array is an affine implicit array of values of type vtkTypeUInt64.
 * see vtkStdFunctionArray, std::function<vtkTypeUInt64(int)>
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStdFunctionTypeUInt64Array_h
#define vtkStdFunctionTypeUInt64Array_h

#include "vtkStdFunctionArray.h" // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStdFunctionArray<vtkTypeUInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStdFunctionTypeUInt64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStdFunctionTypeUInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStdFunctionTypeUInt64Array* New();
  static vtkStdFunctionTypeUInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStdFunctionTypeUInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStdFunctionTypeUInt64Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the std::function to be used as backend.
   */
  void ConstructBackend(std::function<vtkTypeUInt64(int)> func);

protected:
  vtkStdFunctionTypeUInt64Array();
  ~vtkStdFunctionTypeUInt64Array() override;

private:
  typedef vtkStdFunctionArray<vtkTypeUInt64> RealSuperclass;

  vtkStdFunctionTypeUInt64Array(const vtkStdFunctionTypeUInt64Array&) = delete;
  void operator=(const vtkStdFunctionTypeUInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStdFunctionTypeUInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
