// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeInt64Array
 * @brief   scaled soa array of vtkTypeInt64.
 *
 * vtkScaledSOATypeInt64Array is a scaled soa array of values of type vtkTypeInt64.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeInt64Array_h
#define vtkScaledSOATypeInt64Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeInt64Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeInt64Array* New();
  static vtkScaledSOATypeInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeInt64Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeInt64Array();
  ~vtkScaledSOATypeInt64Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeInt64> RealSuperclass;

  vtkScaledSOATypeInt64Array(const vtkScaledSOATypeInt64Array&) = delete;
  void operator=(const vtkScaledSOATypeInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
