// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeFloat64Array
 * @brief   scaled soa array of vtkTypeFloat64.
 *
 * vtkScaledSOATypeFloat64Array is a scaled soa array of values of type vtkTypeFloat64.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeFloat64Array_h
#define vtkScaledSOATypeFloat64Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeFloat64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeFloat64Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeFloat64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeFloat64Array* New();
  static vtkScaledSOATypeFloat64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeFloat64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeFloat64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeFloat64Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeFloat64Array();
  ~vtkScaledSOATypeFloat64Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeFloat64> RealSuperclass;

  vtkScaledSOATypeFloat64Array(const vtkScaledSOATypeFloat64Array&) = delete;
  void operator=(const vtkScaledSOATypeFloat64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeFloat64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
