// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeInt64Array
 * @brief   soa array of vtkTypeInt64.
 *
 * vtkSOATypeInt64Array is a soa array of values of type vtkTypeInt64.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeInt64Array_h
#define vtkSOATypeInt64Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeInt64Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeInt64Array* New();
  static vtkSOATypeInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeInt64Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeInt64Array();
  ~vtkSOATypeInt64Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeInt64> RealSuperclass;

  vtkSOATypeInt64Array(const vtkSOATypeInt64Array&) = delete;
  void operator=(const vtkSOATypeInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
