// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeFloat32Array
 * @brief   soa array of vtkTypeFloat32.
 *
 * vtkSOATypeFloat32Array is a soa array of values of type vtkTypeFloat32.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeFloat32Array_h
#define vtkSOATypeFloat32Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeFloat32Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeFloat32Array* New();
  static vtkSOATypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeFloat32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeFloat32Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeFloat32Array();
  ~vtkSOATypeFloat32Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeFloat32> RealSuperclass;

  vtkSOATypeFloat32Array(const vtkSOATypeFloat32Array&) = delete;
  void operator=(const vtkSOATypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
