// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkQuadraturePointsGenerator
 *
 *
 * Create a vtkPolyData on its output containing the vertices
 * for the quadrature points for one of the vtkDataArrays present
 * on its input vtkUnstructuredGrid. If the input data set has
 * has FieldData generated by vtkQuadraturePointInterpolator then
 * this will be set as point data. Note: Point sets are generated
 * per field array. This is because each field array may contain
 * its own dictionary.
 *
 * @sa
 * vtkQuadraturePointInterpolator, vtkQuadratureSchemeDefinition,
 * vtkInformationQuadratureSchemeDefinitionVectorKey
 */

#ifndef vtkQuadraturePointsGenerator_h
#define vtkQuadraturePointsGenerator_h

#include "vtkDataSetAlgorithm.h"
#include "vtkFiltersGeneralModule.h" // For export macro

VTK_ABI_NAMESPACE_BEGIN
class vtkDataSet;
class vtkPolyData;
class vtkUnstructuredGrid;
class vtkInformation;
class vtkInformationVector;

class VTKFILTERSGENERAL_EXPORT vtkQuadraturePointsGenerator : public vtkDataSetAlgorithm
{
public:
  vtkTypeMacro(vtkQuadraturePointsGenerator, vtkDataSetAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;
  static vtkQuadraturePointsGenerator* New();

protected:
  int FillOutputPortInformation(int port, vtkInformation* info) override;
  int RequestData(
    vtkInformation* req, vtkInformationVector** input, vtkInformationVector* output) override;

  /**
   * Generate the point set .
   */
  int Generate(vtkDataSet* datasetIn, vtkDataArray* offsets, vtkPolyData* pdOut);

  int GenerateField(
    vtkDataSet* datasetIn, vtkDataArray* data, vtkDataArray* offsets, vtkPolyData* pdOut);

  vtkQuadraturePointsGenerator();
  ~vtkQuadraturePointsGenerator() override;

private:
  vtkQuadraturePointsGenerator(const vtkQuadraturePointsGenerator&) = delete;
  void operator=(const vtkQuadraturePointsGenerator&) = delete;
};

VTK_ABI_NAMESPACE_END
#endif
