// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantTypeFloat64Array
 * @brief   constant implicit array of vtkTypeFloat64.
 *
 * vtkConstantTypeFloat64Array is a constant implicit array of values of type vtkTypeFloat64.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantTypeFloat64Array_h
#define vtkConstantTypeFloat64Array_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkTypeFloat64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkConstantTypeFloat64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantTypeFloat64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat64);
#endif

  static vtkConstantTypeFloat64Array* New();
  static vtkConstantTypeFloat64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantTypeFloat64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantTypeFloat64Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkTypeFloat64 value);

protected:
  vtkConstantTypeFloat64Array();
  ~vtkConstantTypeFloat64Array() override;

private:
  typedef vtkConstantArray<vtkTypeFloat64> RealSuperclass;

  vtkConstantTypeFloat64Array(const vtkConstantTypeFloat64Array&) = delete;
  void operator=(const vtkConstantTypeFloat64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantTypeFloat64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
