// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantIdTypeArray
 * @brief   constant implicit array of vtkIdType.
 *
 * vtkConstantIdTypeArray is a constant implicit array of values of type vtkIdType.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantIdTypeArray_h
#define vtkConstantIdTypeArray_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkIdType>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkConstantType*Array instead") vtkConstantIdTypeArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantIdTypeArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkIdType);
#endif

  static vtkConstantIdTypeArray* New();
  static vtkConstantIdTypeArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantIdTypeArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantIdTypeArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkIdType value);

protected:
  vtkConstantIdTypeArray();
  ~vtkConstantIdTypeArray() override;

private:
  typedef vtkConstantArray<vtkIdType> RealSuperclass;

  vtkConstantIdTypeArray(const vtkConstantIdTypeArray&) = delete;
  void operator=(const vtkConstantIdTypeArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantIdTypeArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
