// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeUnsignedLongArray
 * @brief   composite implicit array of unsigned long.
 *
 * vtkCompositeUnsignedLongArray is a composite implicit array of values of type unsigned long.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeUnsignedLongArray_h
#define vtkCompositeUnsignedLongArray_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<unsigned long>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkCompositeType*Array instead") vtkCompositeUnsignedLongArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeUnsignedLongArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeUnsignedLongArray* New();
  static vtkCompositeUnsignedLongArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned long);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeUnsignedLongArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeUnsignedLongArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeUnsignedLongArray();
  ~vtkCompositeUnsignedLongArray() override;

private:
  typedef vtkCompositeArray<unsigned long> RealSuperclass;

  vtkCompositeUnsignedLongArray(const vtkCompositeUnsignedLongArray&) = delete;
  void operator=(const vtkCompositeUnsignedLongArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeUnsignedLongArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
