// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeTypeUInt64Array
 * @brief   composite implicit array of vtkTypeUInt64.
 *
 * vtkCompositeTypeUInt64Array is a composite implicit array of values of type vtkTypeUInt64.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeTypeUInt64Array_h
#define vtkCompositeTypeUInt64Array_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<vtkTypeUInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT  vtkCompositeTypeUInt64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeTypeUInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeTypeUInt64Array* New();
  static vtkCompositeTypeUInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeTypeUInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeTypeUInt64Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeTypeUInt64Array();
  ~vtkCompositeTypeUInt64Array() override;

private:
  typedef vtkCompositeArray<vtkTypeUInt64> RealSuperclass;

  vtkCompositeTypeUInt64Array(const vtkCompositeTypeUInt64Array&) = delete;
  void operator=(const vtkCompositeTypeUInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeTypeUInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
