// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeTypeFloat32Array
 * @brief   composite implicit array of vtkTypeFloat32.
 *
 * vtkCompositeTypeFloat32Array is a composite implicit array of values of type vtkTypeFloat32.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeTypeFloat32Array_h
#define vtkCompositeTypeFloat32Array_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT  vtkCompositeTypeFloat32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeTypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeTypeFloat32Array* New();
  static vtkCompositeTypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeTypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeTypeFloat32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeTypeFloat32Array();
  ~vtkCompositeTypeFloat32Array() override;

private:
  typedef vtkCompositeArray<vtkTypeFloat32> RealSuperclass;

  vtkCompositeTypeFloat32Array(const vtkCompositeTypeFloat32Array&) = delete;
  void operator=(const vtkCompositeTypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeTypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
