/*
    This file is part of the Kasten Framework, made within the KDE community.

    SPDX-FileCopyrightText: 2019 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_SELECTCONTROLLERFACTORY_HPP
#define KASTEN_SELECTCONTROLLERFACTORY_HPP

// lib
#include "kastencontrollers_export.hpp"
// Kasten core
#include <Kasten/AbstractXmlGuiControllerFactory>

namespace Kasten {

class KASTENCONTROLLERS_EXPORT SelectControllerFactory : public AbstractXmlGuiControllerFactory
{
public:
    SelectControllerFactory();
    SelectControllerFactory(const SelectControllerFactory&) = delete;
    SelectControllerFactory(SelectControllerFactory&&) = delete;

    ~SelectControllerFactory() override;

    SelectControllerFactory& operator=(const SelectControllerFactory&) = delete;
    SelectControllerFactory& operator=(SelectControllerFactory&&) = delete;

public: // AbstractXmlGuiControllerFactory API
    [[nodiscard]]
    std::unique_ptr<AbstractXmlGuiController> create(KXMLGUIClient* guiClient) const override;
};

}

#endif
