//--------------------------------------------------------------//
// difference.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( "Difference", "Mixes", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( fg, bg );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Amplify,   "Amplify",   kNoGroup, kNoFlags, 1, 1, 10 );
DeclareFloatParam( Threshold, "Threshold", kNoGroup, kNoFlags, 0, 0, 1 );
DeclareBoolParam( Overlay,    "Overlay",   kNoGroup, false );

float4 kWhite = float4( 1,1,1,1 );
float4 kBlack = float4( 0,0,0,1 );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 ret = abs( fgPix - bgPix );

   if ( Overlay )
   {
      if ( ( ( ret.r + ret.g + ret.b ) * 10 ) > Threshold )
      {
         ret  = kWhite;
         ret.a = 1.0;
      }
      else
         ret = fgPix;
   }
   else
   {
      if ( ( ( ret.r + ret.g + ret.b ) * 10 ) > Threshold )
      {
         ret  = min( ret * Amplify, kWhite );
         ret.a = 1.0;
      }
      else
         ret = kBlack;
   }

   return ret;
}
