//--------------------------------------------------------------
// curves.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( Curves, Colour, Internal, kNoNotes, CanSize );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;
DeclareInput( Map );

float _offset = 0.5 / 256.0;
float _scale   = 255.0 / 256.0;

//---------------------------------------------------------------------------------------
// Logic
//---------------------------------------------------------------------------------------
float2 makeLUTCoordinate( float componentValue )
{
   return float2( ( componentValue * _scale ) + _offset, 0.5 );
}
//---------------------------------------------------------------------------------------
DeclareEntryPoint( RGB )
{
   float4 source  = ReadPixel( Input,  uv1 );
   float4 mappedR = tex2D( Map, makeLUTCoordinate( source.r ) );
   float4 mappedG = tex2D( Map, makeLUTCoordinate( source.g ) );
   float4 mappedB = tex2D( Map, makeLUTCoordinate( source.b ) );

   float4 res = float4( mappedR.r, mappedG.g, mappedB.b, source.a );
   return lerp( source, res, tex2D( Mask, uv2 ) );
}
//---------------------------------------------------------------------------------------
DeclareEntryPoint( RGBL )
{
   float4 source  = ReadPixel( Input,  uv1 );
   float4 mappedR = tex2D( Map, makeLUTCoordinate( source.r ) );
   float4 mappedG = tex2D( Map, makeLUTCoordinate( source.g ) );
   float4 mappedB = tex2D( Map, makeLUTCoordinate( source.b ) );

   // Calc pixel luminance
   float lum = ( source.r * 0.3 ) + ( source.g * 0.59 ) + ( source.b * 0.11 );

   // Get the mapped luminance value
   float4 mappedLum = tex2D( Map,  makeLUTCoordinate( lum )  );

   // Recalc RGB using the new luminance value
   float lumMultiplier = 1;

   if ( lum != 0 )
      lumMultiplier = mappedLum.a / lum;

   float4 res = float4( mappedR.r * lumMultiplier, mappedG.g * lumMultiplier, mappedB.b * lumMultiplier, source.a );
   return lerp( source, res, tex2D( Mask, uv2 ) );
}
