//--------------------------------------------------------------
// ChannelExpand
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( ChannelExpand, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input, Point );

DeclareFloatParam( _Width );

DeclareEntryPoint()
{
   float4 src = tex2D( Input, uv1 );

   float f = floor( ( frac( ( uv1.x * _Width ) / 4.0 ) * 4.0 ) + 0.5 );

   if ( f == 0 )
      f = src.b;
   else if ( f == 1 )
      f = src.g;
   else if ( f == 2 )
      f = src.r;
   else
      f = src.a;

   return float4( f, f, f, 1.0 );
}
