/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Formatter;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.Parser;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.SyntaxFactory;
import uk.me.nxg.unity.Token;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitVal;
import uk.me.nxg.unity.Version;
import uk.me.nxg.unity.Yylex;

public class UnitParser {
    private String inputString;
    private final Syntax syntax;
    private final Parser yyparser;
    private UnitExpr parseResult = null;
    private Yylex helperLexer;
    protected boolean guessUnits = false;

    public UnitParser(Syntax syntax, String string) throws UnitParserException {
        this(syntax);
        this.parse(string);
        assert (this.helperLexer == null);
        assert (this.inputString != null);
        assert (this.parseResult != null);
    }

    public UnitParser(Syntax syntax) throws UnitParserException {
        if (syntax == null) {
            throw new IllegalArgumentException("null parser type");
        }
        this.syntax = syntax;
        this.inputString = null;
        this.yyparser = SyntaxFactory.createParser(this.syntax, null);
        assert (this.yyparser != null);
    }

    public UnitExpr parse(String string) throws UnitParserException {
        if (string == null) {
            throw new IllegalArgumentException("parse must have a non-null argument");
        }
        if (this.helperLexer != null) {
            throw new IllegalStateException("Can't mix getLexeme and getParsed in UnitParser");
        }
        this.inputString = string;
        this.yyparser.setReader(new StringReader(string), this.syntax);
        this.yyparser.setGuessing(this.guessUnits);
        this.yyparser.parse();
        this.parseResult = this.yyparser.getParseResult();
        assert (this.parseResult != null);
        return this.parseResult;
    }

    public void lex(String string) {
        if (this.parseResult != null) {
            throw new IllegalStateException("Can't mix getLexeme and getParsed in UnitParser");
        }
        this.inputString = string;
        this.yyparser.setReader(new StringReader(string), this.syntax);
        this.helperLexer = this.yyparser.lexer;
    }

    public UnitExpr getParsed() throws UnitParserException {
        if (this.helperLexer != null) {
            throw new IllegalStateException("Can't mix getLexeme and getParsed in UnitParser");
        }
        if (this.parseResult == null) {
            this.yyparser.parse();
            this.parseResult = this.yyparser.getParseResult();
            assert (this.parseResult != null);
        }
        return this.parseResult;
    }

    public static boolean isKnownParser(String string) {
        return Syntax.lookup(string) != null;
    }

    public void setGuessing(boolean bl) {
        this.guessUnits = bl;
    }

    public Lexeme getLexeme() throws UnitParserException {
        if (this.parseResult != null) {
            throw new IllegalStateException("Can't mix getLexeme and getParsed in UnitParser");
        }
        try {
            int n = this.helperLexer.yylex();
            if (n == 0) {
                this.helperLexer = null;
                return null;
            }
            return new Lexeme(n, this.yyparser.yylval);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
            this.helperLexer = null;
            return null;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Syntax syntax = Syntax.FITS;
        Syntax syntax2 = Syntax.FITS;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        block13: for (String object2 : stringArray) {
            if (object2.charAt(0) == '-') {
                if (object2.length() < 2) {
                    UnitParser.Usage();
                }
                switch (object2.charAt(1)) {
                    case 'i': {
                        syntax = Syntax.lookup(object2.substring(2));
                        if (syntax != null) continue block13;
                        System.err.println("Unrecognised input syntax: " + object2.substring(2));
                        System.exit(1);
                        break;
                    }
                    case 'o': {
                        syntax2 = Syntax.lookup(object2.substring(2));
                        if (syntax2 != null) continue block13;
                        System.err.println("Unrecognised output syntax: " + object2.substring(2));
                        System.exit(1);
                        break;
                    }
                    case 'g': {
                        bl4 = true;
                        break;
                    }
                    case 'S': {
                        bl = true;
                        break;
                    }
                    case 'l': {
                        bl2 = true;
                        break;
                    }
                    case 'v': {
                        bl3 = true;
                        break;
                    }
                    case 'V': {
                        System.out.println(Version.versionString());
                        System.exit(0);
                        break;
                    }
                    default: {
                        UnitParser.Usage();
                        break;
                    }
                }
                continue;
            }
            arrayList.add(object2);
        }
        if (!bl && arrayList.size() <= 0) {
            UnitParser.Usage();
        }
        if (bl) {
            for (Syntax syntax3 : Syntax.values()) {
                System.out.print(" " + syntax3);
            }
            System.out.println();
        } else if (bl2) {
            try {
                Lexeme lexeme;
                object = new UnitParser(syntax);
                ((UnitParser)object).lex((String)arrayList.get(0));
                while ((lexeme = ((UnitParser)object).getLexeme()) != null) {
                    System.out.println(lexeme);
                }
            }
            catch (UnitParserException unitParserException) {
                System.err.println("Can't lex expression \"" + (String)arrayList.get(0) + "\": " + unitParserException);
            }
        } else {
            try {
                object = new UnitParser(syntax);
                ((UnitParser)object).setGuessing(bl4);
                for (String string : arrayList) {
                    UnitExpr unitExpr = ((UnitParser)object).parse(string);
                    System.out.println(unitExpr.toString(syntax2));
                    if (!bl3) continue;
                    boolean bl5 = unitExpr.allUnitsRecognised(syntax);
                    boolean bl6 = unitExpr.allUnitsRecognised(syntax, true);
                    System.out.println("Checking <" + string + ">, in input syntax " + (Object)((Object)syntax) + ":");
                    System.out.println("check: all units recognised?        " + (bl5 ? "yes" : "no"));
                    if (!bl5 && bl4) {
                        System.out.println("       ...with guessing?            " + (bl6 ? "yes" : "no"));
                    }
                    System.out.println("check: all units recommended?       " + (unitExpr.allUnitsRecommended(syntax) ? "yes" : "no"));
                    System.out.println("check: all constraints satisfied?   " + (unitExpr.allUsageConstraintsSatisfied(syntax) ? "yes" : "no"));
                    System.out.println("Result:");
                    for (OneUnit oneUnit : unitExpr) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Formatter formatter = new Formatter(stringBuilder);
                        formatter.format("  %-20s (%s%s)%s%s", oneUnit, (double)oneUnit.getPrefix() == 0.0 ? "" : "10^" + oneUnit.getPrefix() + " ", oneUnit.getBaseUnitName(), (double)oneUnit.getExponent() == 1.0 ? "" : "^" + oneUnit.getExponent(), oneUnit.wasGuessed() ? ", guessed" : "");
                        UnitDefinition unitDefinition = oneUnit.getBaseUnitDefinition();
                        if (unitDefinition == null) {
                            formatter.format("\n    (unrecognised)", new Object[0]);
                        } else {
                            formatter.format("\n    %s / %s", unitDefinition, unitDefinition.getRepresentation(Syntax.VOUNITS));
                        }
                        System.out.println(formatter.toString());
                    }
                }
            }
            catch (UnitParserException unitParserException) {
                System.err.println("Error parsing units: " + unitParserException.getMessage());
            }
        }
    }

    private static void Usage() {
        System.err.println(Version.versionString());
        System.err.println("Usage:");
        System.err.println("    UnitParser [-isyntax] [-osyntax] [-v] [-g] unit-expression ...");
        System.err.println("    UnitParser -S     : show syntaxes");
        System.err.println("    UnitParser -V     : show version");
        System.err.println();
        System.err.println("Options:");
        System.err.println("  -i, -o   : input or output syntax");
        System.err.println("  -g       : try guessing unrecognised units");
        System.err.println("  -v       : validate the parsed expression");
        System.exit(1);
    }

    public static class Lexeme {
        public final int token;
        public final UnitVal value;

        private Lexeme(int n, UnitVal unitVal) {
            this.token = n;
            this.value = unitVal;
        }

        public String toString() {
            Token token = Token.lookup(this.token);
            if (token.type == null) {
                return token.name;
            }
            return String.format("%s: %s", token.name, this.value.toString());
        }
    }
}

